/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.pathmap;

import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.server.pathmap.PathSpecGroup;

public class ServletPathSpec
extends PathSpec {
    public static final String PATH_SPEC_SEPARATORS = ":,";

    public static ServletPathSpec[] getMultiPathSpecs(String servletPathSpec) {
        String[] pathSpecs = servletPathSpec.split(PATH_SPEC_SEPARATORS);
        int len = pathSpecs.length;
        ServletPathSpec[] sps = new ServletPathSpec[len];
        int i = 0;
        while (i < len) {
            sps[i] = new ServletPathSpec(pathSpecs[i]);
            ++i;
        }
        return sps;
    }

    public ServletPathSpec(String servletPathSpec) {
        this.assertValidServletPathSpec(servletPathSpec);
        if (servletPathSpec == null || servletPathSpec.length() == 0 || "/".equals(servletPathSpec)) {
            this.pathSpec = "/";
            this.pathDepth = -1;
            this.specLength = 1;
            this.group = PathSpecGroup.DEFAULT;
            return;
        }
        this.specLength = servletPathSpec.length();
        this.pathDepth = 0;
        char lastChar = servletPathSpec.charAt(this.specLength - 1);
        this.group = servletPathSpec.charAt(0) == '/' && this.specLength > 1 && lastChar == '*' ? PathSpecGroup.PREFIX_GLOB : (servletPathSpec.charAt(0) == '*' ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.EXACT);
        int i = 0;
        while (i < this.specLength) {
            int cp = servletPathSpec.codePointAt(i);
            if (cp < 128) {
                char c = (char)cp;
                switch (c) {
                    case '/': {
                        ++this.pathDepth;
                    }
                }
            }
            ++i;
        }
        this.pathSpec = servletPathSpec;
    }

    private void assertValidServletPathSpec(String servletPathSpec) {
        int idx;
        if (servletPathSpec == null || servletPathSpec.equals("")) {
            return;
        }
        char[] cArray = PATH_SPEC_SEPARATORS.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (servletPathSpec.indexOf(c) >= 0) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: encountered Path Spec Separator [:,] within specified path spec. did you forget to split this path spec up?");
            }
            ++n2;
        }
        int len = servletPathSpec.length();
        if (servletPathSpec.charAt(0) == '/') {
            if (len == 1) {
                return;
            }
            idx = servletPathSpec.indexOf(42);
            if (idx < 0) {
                return;
            }
            if (idx != len - 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: glob '*' can only exist at end of prefix based matches");
            }
        } else if (servletPathSpec.startsWith("*.")) {
            idx = servletPathSpec.indexOf(47);
            if (idx >= 0) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have path separators");
            }
            idx = servletPathSpec.indexOf(42, 2);
            if (idx >= 1) {
                throw new IllegalArgumentException("Servlet Spec 12.2 violation: suffix based path spec cannot have multiple glob '*'");
            }
        } else {
            throw new IllegalArgumentException("Servlet Spec 12.2 violation: path spec must start with \"/\" or \"*.\"");
        }
    }

    @Override
    public String getPathInfo(String path) {
        if (this.group == PathSpecGroup.PREFIX_GLOB) {
            if (path.length() == this.specLength - 2) {
                return null;
            }
            return path.substring(this.specLength - 2);
        }
        return null;
    }

    @Override
    public String getPathMatch(String path) {
        switch (this.group) {
            case EXACT: {
                if (this.pathSpec.equals(path)) {
                    return path;
                }
                return null;
            }
            case PREFIX_GLOB: {
                if (this.isWildcardMatch(path)) {
                    return path.substring(0, this.specLength - 2);
                }
                return null;
            }
            case SUFFIX_GLOB: {
                if (path.regionMatches(path.length() - (this.specLength - 1), this.pathSpec, 1, this.specLength - 1)) {
                    return path;
                }
                return null;
            }
            case DEFAULT: {
                return path;
            }
        }
        return null;
    }

    @Override
    public String getRelativePath(String base, String path) {
        String info = this.getPathInfo(path);
        if (info == null) {
            info = path;
        }
        if (info.startsWith("./")) {
            info = info.substring(2);
        }
        path = base.endsWith("/") ? (info.startsWith("/") ? String.valueOf(base) + info.substring(1) : String.valueOf(base) + info) : (info.startsWith("/") ? String.valueOf(base) + info : String.valueOf(base) + "/" + info);
        return path;
    }

    private boolean isExactMatch(String path) {
        if (this.group == PathSpecGroup.EXACT) {
            if (this.pathSpec.equals(path)) {
                return true;
            }
            return path.charAt(path.length() - 1) == '/' && path.equals(String.valueOf(this.pathSpec) + '/');
        }
        return false;
    }

    private boolean isWildcardMatch(String path) {
        int cpl = this.specLength - 2;
        return this.group == PathSpecGroup.PREFIX_GLOB && path.regionMatches(0, this.pathSpec, 0, cpl) && (path.length() == cpl || '/' == path.charAt(cpl));
    }

    @Override
    public boolean matches(String path) {
        switch (this.group) {
            case EXACT: {
                return this.isExactMatch(path);
            }
            case PREFIX_GLOB: {
                return this.isWildcardMatch(path);
            }
            case SUFFIX_GLOB: {
                return path.regionMatches(path.length() - this.specLength + 1, this.pathSpec, 1, this.specLength - 1);
            }
            case DEFAULT: {
                return true;
            }
        }
        return false;
    }
}

