/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Stack;

public class XmlAppendable {
    private final String SPACES = "                                                                 ";
    private final Appendable _out;
    private final int _indent;
    private final Stack<String> _tags = new Stack();
    private String _space = "";

    public XmlAppendable(OutputStream out, String encoding) throws IOException {
        this((Appendable)new OutputStreamWriter(out, encoding), encoding);
    }

    public XmlAppendable(Appendable out) throws IOException {
        this(out, 2);
    }

    public XmlAppendable(Appendable out, String encoding) throws IOException {
        this(out, 2, encoding);
    }

    public XmlAppendable(Appendable out, int indent) throws IOException {
        this(out, indent, "UTF-8");
    }

    public XmlAppendable(Appendable out, int indent, String encoding) throws IOException {
        this._out = out;
        this._indent = indent;
        this._out.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
    }

    public XmlAppendable open(String tag, Map<String, String> attributes) throws IOException {
        this._out.append(this._space).append('<').append(tag);
        this.attributes(attributes);
        this._out.append(">\n");
        this._space = String.valueOf(this._space) + "                                                                 ".substring(0, this._indent);
        this._tags.push(tag);
        return this;
    }

    public XmlAppendable open(String tag) throws IOException {
        this._out.append(this._space).append('<').append(tag).append(">\n");
        this._space = String.valueOf(this._space) + "                                                                 ".substring(0, this._indent);
        this._tags.push(tag);
        return this;
    }

    public XmlAppendable content(String s) throws IOException {
        if (s != null) {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                switch (c) {
                    case '<': {
                        this._out.append("&lt;");
                        break;
                    }
                    case '>': {
                        this._out.append("&gt;");
                        break;
                    }
                    case '&': {
                        this._out.append("&amp;");
                        break;
                    }
                    case '\'': {
                        this._out.append("&apos;");
                        break;
                    }
                    case '\"': {
                        this._out.append("&quot;");
                        break;
                    }
                    default: {
                        this._out.append(c);
                    }
                }
                ++i;
            }
        }
        return this;
    }

    public XmlAppendable cdata(String s) throws IOException {
        this._out.append("<![CDATA[").append(s).append("]]>");
        return this;
    }

    public XmlAppendable tag(String tag) throws IOException {
        this._out.append(this._space).append('<').append(tag).append("/>\n");
        return this;
    }

    public XmlAppendable tag(String tag, Map<String, String> attributes) throws IOException {
        this._out.append(this._space).append('<').append(tag);
        this.attributes(attributes);
        this._out.append("/>\n");
        return this;
    }

    public XmlAppendable tag(String tag, String content) throws IOException {
        this._out.append(this._space).append('<').append(tag).append('>');
        this.content(content);
        this._out.append("</").append(tag).append(">\n");
        return this;
    }

    public XmlAppendable tagCDATA(String tag, String data) throws IOException {
        this._out.append(this._space).append('<').append(tag).append('>');
        this.cdata(data);
        this._out.append("</").append(tag).append(">\n");
        return this;
    }

    public XmlAppendable tag(String tag, Map<String, String> attributes, String content) throws IOException {
        this._out.append(this._space).append('<').append(tag);
        this.attributes(attributes);
        this._out.append('>');
        this.content(content);
        this._out.append("</").append(tag).append(">\n");
        return this;
    }

    public XmlAppendable close() throws IOException {
        if (this._tags.isEmpty()) {
            throw new IllegalStateException("Tags closed");
        }
        String tag = this._tags.pop();
        this._space = this._space.substring(0, this._space.length() - this._indent);
        this._out.append(this._space).append("</").append(tag).append(">\n");
        if (this._tags.isEmpty() && this._out instanceof Closeable) {
            ((Closeable)((Object)this._out)).close();
        }
        return this;
    }

    private void attributes(Map<String, String> attributes) throws IOException {
        for (String k : attributes.keySet()) {
            String v = attributes.get(k);
            this._out.append(' ').append(k).append("=\"");
            this.content(v);
            this._out.append('\"');
        }
    }

    public void literal(String xml) throws IOException {
        this._out.append(xml);
    }
}

