/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static final Logger LOG = Log.getLogger(XmlConfiguration.class);
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __boxedPrimitives = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] __supportedCollections = new Class[]{ArrayList.class, ArrayQueue.class, HashSet.class, Queue.class, List.class, Set.class, Collection.class};
    private static final Iterable<ConfigurationProcessorFactory> __factoryLoader = ServiceLoader.load(ConfigurationProcessorFactory.class);
    private static final XmlParser __parser = XmlConfiguration.initParser();
    private final Map<String, Object> _idMap = new HashMap<String, Object>();
    private final Map<String, String> _propertyMap = new HashMap<String, String>();
    private final URL _url;
    private final String _dtd;
    private ConfigurationProcessor _processor;

    private static synchronized XmlParser initParser() {
        XmlParser parser = new XmlParser();
        URL config60 = Loader.getResource(XmlConfiguration.class, "org/eclipse/jetty/xml/configure_6_0.dtd");
        URL config76 = Loader.getResource(XmlConfiguration.class, "org/eclipse/jetty/xml/configure_7_6.dtd");
        URL config90 = Loader.getResource(XmlConfiguration.class, "org/eclipse/jetty/xml/configure_9_0.dtd");
        parser.redirectEntity("configure.dtd", config90);
        parser.redirectEntity("configure_1_0.dtd", config60);
        parser.redirectEntity("configure_1_1.dtd", config60);
        parser.redirectEntity("configure_1_2.dtd", config60);
        parser.redirectEntity("configure_1_3.dtd", config60);
        parser.redirectEntity("configure_6_0.dtd", config60);
        parser.redirectEntity("configure_7_6.dtd", config76);
        parser.redirectEntity("configure_9_0.dtd", config90);
        parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", config90);
        parser.redirectEntity("http://jetty.eclipse.org/configure.dtd", config90);
        parser.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", config90);
        parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config90);
        parser.redirectEntity("-//Jetty//Configure//EN", config90);
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = configuration;
            this.setConfig(__parser.parse(configuration.toString()));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        configuration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"http://eclipse.org/jetty/configure.dtd\">" + configuration;
        InputSource source = new InputSource(new StringReader(configuration));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = null;
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        InputSource source = new InputSource(configuration);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = null;
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    private void setConfig(XmlParser.Node config) {
        if ("Configure".equals(config.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (__factoryLoader != null) {
            for (ConfigurationProcessorFactory factory : __factoryLoader) {
                this._processor = factory.getConfigurationProcessor(this._dtd, config.getTag());
                if (this._processor != null) break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + config.getTag() + " in " + this);
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + config.getTag());
        }
        this._processor.init(this._url, config, this);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object obj) throws Exception {
        return this._processor.configure(obj);
    }

    public Object configure() throws Exception {
        return this._processor.configure();
    }

    public void initializeDefaults(Object object) {
    }

    public static void main(final String ... args) throws Exception {
        final AtomicReference exception = new AtomicReference();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Properties properties = null;
                    try {
                        Class<?> config = XmlConfiguration.class.getClassLoader().loadClass("org.eclipse.jetty.start.Config");
                        properties = (Properties)config.getMethod("getProperties", new Class[0]).invoke(null, new Object[0]);
                        LOG.debug("org.eclipse.jetty.start.Config properties = {}", properties);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        LOG.ignore(e);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                    if (properties == null) {
                        properties = new Properties();
                        Enumeration<?> ensysprop = System.getProperties().propertyNames();
                        while (ensysprop.hasMoreElements()) {
                            String name = (String)ensysprop.nextElement();
                            properties.put(name, System.getProperty(name));
                        }
                    }
                    String[] stringArray = args;
                    int n = args.length;
                    int name = 0;
                    while (name < n) {
                        String arg = stringArray[name];
                        if (arg.toLowerCase(Locale.ENGLISH).endsWith(".properties")) {
                            properties.load(Resource.newResource(arg).getInputStream());
                        }
                        ++name;
                    }
                    XmlConfiguration last = null;
                    Object[] obj = new Object[args.length];
                    int i = 0;
                    while (i < args.length) {
                        if (!args[i].toLowerCase(Locale.ENGLISH).endsWith(".properties")) {
                            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(args[i]).getURL());
                            if (last != null) {
                                configuration.getIdMap().putAll(last.getIdMap());
                            }
                            if (properties.size() > 0) {
                                HashMap<String, String> props = new HashMap<String, String>();
                                for (Object key : properties.keySet()) {
                                    props.put(key.toString(), String.valueOf(properties.get(key)));
                                }
                                configuration.getProperties().putAll(props);
                            }
                            obj[i] = configuration.configure();
                            last = configuration;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < args.length) {
                        LifeCycle lc;
                        if (obj[i] instanceof LifeCycle && !(lc = (LifeCycle)obj[i]).isRunning()) {
                            lc.start();
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    LOG.debug("EXCEPTION ", e);
                    exception.set(e);
                }
                return null;
            }
        });
        Throwable th = (Throwable)exception.get();
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new Error(th);
        }
    }

    static /* synthetic */ Class[] access$2() {
        return __primitives;
    }

    static /* synthetic */ Class[] access$3() {
        return __boxedPrimitives;
    }

    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        private String _url;
        XmlParser.Node _root;
        XmlConfiguration _configuration;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(URL url, XmlParser.Node root, XmlConfiguration configuration) {
            this._url = url == null ? null : url.toString();
            this._root = root;
            this._configuration = configuration;
        }

        @Override
        public Object configure(Object obj) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            if (oClass != null && !oClass.isInstance(obj)) {
                String loaders = oClass.getClassLoader() == obj.getClass().getClassLoader() ? "" : "Object Class and type Class are from different loaders.";
                throw new IllegalArgumentException("Object of class '" + obj.getClass().getCanonicalName() + "' is not of type '" + oClass.getCanonicalName() + "'. " + loaders + " in " + this._url);
            }
            this.configure(obj, this._root, 0);
            return obj;
        }

        @Override
        public Object configure() throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            String id = this._root.getAttribute("id");
            Object obj = id == null ? null : this._configuration.getIdMap().get(id);
            int index = 0;
            if (obj == null && oClass != null) {
                index = this._root.size();
                HashMap<String, Object> namedArgMap = new HashMap<String, Object>();
                LinkedList<Object> arguments = new LinkedList<Object>();
                int i = 0;
                while (i < this._root.size()) {
                    Object o = this._root.get(i);
                    if (!(o instanceof String)) {
                        XmlParser.Node node = (XmlParser.Node)o;
                        if (!node.getTag().equals("Arg")) {
                            index = i;
                            break;
                        }
                        String namedAttribute = node.getAttribute("name");
                        Object value = this.value(obj, (XmlParser.Node)o);
                        if (namedAttribute != null) {
                            namedArgMap.put(namedAttribute, value);
                        }
                        arguments.add(value);
                    }
                    ++i;
                }
                try {
                    obj = namedArgMap.size() > 0 ? TypeUtil.construct(oClass, arguments.toArray(), namedArgMap) : TypeUtil.construct(oClass, arguments.toArray());
                }
                catch (NoSuchMethodException x) {
                    throw new IllegalStateException("No suitable constructor on " + oClass, x);
                }
            }
            this._configuration.initializeDefaults(obj);
            this.configure(obj, this._root, index);
            return obj;
        }

        private static Class<?> nodeClass(XmlParser.Node node) throws ClassNotFoundException {
            String className = node.getAttribute("class");
            if (className == null) {
                return null;
            }
            return Loader.loadClass(XmlConfiguration.class, className);
        }

        public void configure(Object obj, XmlParser.Node cfg, int i) throws Exception {
            XmlParser.Node node;
            Object o;
            String id = cfg.getAttribute("id");
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            while (i < cfg.size()) {
                o = cfg.get(i);
                if (!(o instanceof String)) {
                    node = (XmlParser.Node)o;
                    if (!"Arg".equals(node.getTag())) break;
                    LOG.warn("Ignored arg: " + node, new Object[0]);
                }
                ++i;
            }
            while (i < cfg.size()) {
                block34: {
                    o = cfg.get(i);
                    if (o instanceof String) break block34;
                    node = (XmlParser.Node)o;
                    try {
                        String tag;
                        switch (tag = node.getTag()) {
                            case "Set": {
                                this.set(obj, node);
                                break;
                            }
                            case "Put": {
                                this.put(obj, node);
                                break;
                            }
                            case "Call": {
                                this.call(obj, node);
                                break;
                            }
                            case "Get": {
                                this.get(obj, node);
                                break;
                            }
                            case "New": {
                                this.newObj(obj, node);
                                break;
                            }
                            case "Array": {
                                this.newArray(obj, node);
                                break;
                            }
                            case "Ref": {
                                this.refObj(obj, node);
                                break;
                            }
                            case "Property": {
                                this.propertyObj(node);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown tag: " + tag + " in " + this._url);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Config error at " + node, String.valueOf(e.toString()) + " in " + this._url);
                        throw e;
                    }
                }
                ++i;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void set(Object obj, XmlParser.Node node) throws Exception {
            attr = node.getAttribute("name");
            name = "set" + attr.substring(0, 1).toUpperCase(Locale.ENGLISH) + attr.substring(1);
            value = this.value(obj, node);
            arg = new Object[]{value};
            oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            vClass = new Class[]{Object.class};
            if (value != null) {
                vClass[0] = value.getClass();
            }
            if (XmlConfiguration.access$0().isDebugEnabled()) {
                XmlConfiguration.access$0().debug("XML " + (obj != null ? obj.toString() : oClass.getName()) + "." + name + "(" + value + ")", new Object[0]);
            }
            try {
                set = oClass.getMethod(name, vClass);
                set.invoke(obj, arg);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
                XmlConfiguration.access$0().ignore(e);
                try {
                    type = vClass[0].getField("TYPE");
                    vClass[0] = (Class)type.get(null);
                    set = oClass.getMethod(name, vClass);
                    set.invoke(obj, arg);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException e) {
                    XmlConfiguration.access$0().ignore(e);
                    try {
                        field = oClass.getField(attr);
                        if (Modifier.isPublic(field.getModifiers())) {
                            field.set(obj, value);
                            return;
                        }
                    }
                    catch (NoSuchFieldException e) {
                        XmlConfiguration.access$0().ignore(e);
                    }
                    sets = oClass.getMethods();
                    set = null;
                    s = 0;
                    ** while (sets != null && s < sets.length)
                }
            }
lbl-1000:
            // 1 sources

            {
                paramTypes = sets[s].getParameterTypes();
                if (name.equals(sets[s].getName()) && paramTypes.length == 1) {
                    try {
                        set = sets[s];
                        sets[s].invoke(obj, arg);
                        return;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        XmlConfiguration.access$0().ignore(e);
                        try {
                            var16_28 = XmlConfiguration.access$1();
                            var15_27 = var16_28.length;
                            var14_26 = 0;
                            while (var14_26 < var15_27) {
                                c = var16_28[var14_26];
                                if (paramTypes[0].isAssignableFrom(c)) {
                                    sets[s].invoke(obj, new Object[]{JettyXmlConfiguration.convertArrayToCollection(value, c)});
                                    return;
                                }
                                ++var14_26;
                            }
                        }
                        catch (IllegalAccessException e) {
                            XmlConfiguration.access$0().ignore(e);
                        }
                    }
                }
                ++s;
                continue;
            }
lbl69:
            // 1 sources

            if (set != null) {
                try {
                    sClass = set.getParameterTypes()[0];
                    if (sClass.isPrimitive()) {
                        t = 0;
                        while (t < XmlConfiguration.access$2().length) {
                            if (sClass.equals(XmlConfiguration.access$2()[t])) {
                                sClass = XmlConfiguration.access$3()[t];
                                break;
                            }
                            ++t;
                        }
                    }
                    cons = sClass.getConstructor(vClass);
                    arg[0] = cons.newInstance(arg);
                    this._configuration.initializeDefaults(arg[0]);
                    set.invoke(obj, arg);
                    return;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    XmlConfiguration.access$0().ignore(e);
                }
            }
            throw new NoSuchMethodException(oClass + "." + name + "(" + vClass[0] + ")");
        }

        private static Collection<?> convertArrayToCollection(Object array, Class<?> collectionType) {
            AbstractCollection collection = null;
            if (array.getClass().isArray()) {
                if (collectionType.isAssignableFrom(ArrayList.class)) {
                    collection = JettyXmlConfiguration.convertArrayToArrayList(array);
                } else if (collectionType.isAssignableFrom(HashSet.class)) {
                    collection = new HashSet<Object>(JettyXmlConfiguration.convertArrayToArrayList(array));
                } else if (collectionType.isAssignableFrom(ArrayQueue.class)) {
                    ArrayQueue<Object> q = new ArrayQueue<Object>();
                    q.addAll(JettyXmlConfiguration.convertArrayToArrayList(array));
                    collection = q;
                }
            }
            if (collection == null) {
                throw new IllegalArgumentException("Can't convert \"" + array.getClass() + "\" to " + collectionType);
            }
            return collection;
        }

        private static ArrayList<Object> convertArrayToArrayList(Object array) {
            int length = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(length);
            int i = 0;
            while (i < length) {
                list.add(Array.get(array, i));
                ++i;
            }
            return list;
        }

        private void put(Object obj, XmlParser.Node node) throws Exception {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + obj);
            }
            Map map = (Map)obj;
            String name = node.getAttribute("name");
            Object value = this.value(obj, node);
            map.put(name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + obj + ".put(" + name + "," + value + ")", new Object[0]);
            }
        }

        private Object get(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            String name = node.getAttribute("name");
            String id = node.getAttribute("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML get " + name, new Object[0]);
            }
            try {
                Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), null);
                obj = method.invoke(obj, null);
                this.configure(obj, node, 0);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field field = oClass.getField(name);
                    obj = field.get(obj);
                    this.configure(obj, node, 0);
                }
                catch (NoSuchFieldException nsfe) {
                    throw nsme;
                }
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            return obj;
        }

        private Object call(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else if (obj != null) {
                oClass = obj.getClass();
            }
            if (oClass == null) {
                throw new IllegalArgumentException(node.toString());
            }
            int size = 0;
            int argIndex = node.size();
            int i = 0;
            while (i < node.size()) {
                Object o = node.get(i);
                if (!(o instanceof String)) {
                    if (!((XmlParser.Node)o).getTag().equals("Arg")) {
                        argIndex = i;
                        break;
                    }
                    ++size;
                }
                ++i;
            }
            Object[] arg = new Object[size];
            int i2 = 0;
            int j = 0;
            while (j < size) {
                Object o = node.get(i2);
                if (!(o instanceof String)) {
                    arg[j++] = this.value(obj, (XmlParser.Node)o);
                }
                ++i2;
            }
            String method = node.getAttribute("name");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML call " + method, new Object[0]);
            }
            try {
                Object n = TypeUtil.call(oClass, method, obj, arg);
                if (id != null) {
                    this._configuration.getIdMap().put(id, n);
                }
                this.configure(n, node, argIndex);
                return n;
            }
            catch (NoSuchMethodException e) {
                IllegalStateException ise = new IllegalStateException("No Method: " + node + " on " + oClass);
                ise.initCause(e);
                throw ise;
            }
        }

        private Object newObj(Object obj, XmlParser.Node node) throws Exception {
            Object n;
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            int argIndex = node.size();
            HashMap<String, Object> namedArgMap = new HashMap<String, Object>();
            LinkedList<Object> arguments = new LinkedList<Object>();
            int i = 0;
            while (i < node.size()) {
                Object o = node.get(i);
                if (!(o instanceof String)) {
                    XmlParser.Node child = (XmlParser.Node)o;
                    if (child.getTag().equals("Arg")) {
                        String namedAttribute = child.getAttribute("name");
                        Object value = this.value(obj, child);
                        if (namedAttribute != null) {
                            namedArgMap.put(namedAttribute, value);
                        }
                        arguments.add(value);
                    } else {
                        argIndex = i;
                        break;
                    }
                }
                ++i;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML new " + oClass, new Object[0]);
            }
            try {
                if (namedArgMap.size() > 0) {
                    LOG.debug("using named mapping", new Object[0]);
                    n = TypeUtil.construct(oClass, arguments.toArray(), namedArgMap);
                } else {
                    LOG.debug("using normal mapping", new Object[0]);
                    n = TypeUtil.construct(oClass, arguments.toArray());
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No suitable constructor: " + node + " on " + obj);
            }
            this._configuration.initializeDefaults(n);
            this.configure(n, node, argIndex);
            return n;
        }

        private Object refObj(Object obj, XmlParser.Node node) throws Exception {
            String refid = node.getAttribute("refid");
            if (refid == null) {
                refid = node.getAttribute("id");
            }
            if ((obj = this._configuration.getIdMap().get(refid)) == null && node.size() > 0) {
                throw new IllegalStateException("No object for refid=" + refid);
            }
            this.configure(obj, node, 0);
            return obj;
        }

        private Object newArray(Object obj, XmlParser.Node node) throws Exception {
            String id;
            Class aClass;
            block15: {
                aClass = Object.class;
                String type = node.getAttribute("type");
                id = node.getAttribute("id");
                if (type == null || (aClass = TypeUtil.fromName(type)) != null) break block15;
                switch (type) {
                    case "String": {
                        aClass = String.class;
                        break;
                    }
                    case "URL": {
                        aClass = URL.class;
                        break;
                    }
                    case "InetAddress": {
                        aClass = InetAddress.class;
                        break;
                    }
                    default: {
                        aClass = Loader.loadClass(XmlConfiguration.class, type);
                    }
                }
            }
            Object al = null;
            for (Object nodeObject : node) {
                XmlParser.Node item = (XmlParser.Node)nodeObject;
                String nid = item.getAttribute("id");
                Object v = this.value(obj, item);
                al = LazyList.add(al, v == null && aClass.isPrimitive() ? Integer.valueOf(0) : v);
                if (nid == null) continue;
                this._configuration.getIdMap().put(nid, v);
            }
            Object array = LazyList.toArray(al, aClass);
            if (id != null) {
                this._configuration.getIdMap().put(id, array);
            }
            return array;
        }

        private Object newMap(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (id != null) {
                this._configuration.getIdMap().put(id, map);
            }
            for (Object o : node) {
                if (o instanceof String) continue;
                XmlParser.Node entry = (XmlParser.Node)o;
                if (!entry.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node key = null;
                XmlParser.Node value = null;
                for (Object object : entry) {
                    if (object instanceof String) continue;
                    XmlParser.Node item = (XmlParser.Node)object;
                    if (!item.getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (key == null) {
                        key = item;
                        continue;
                    }
                    value = item;
                }
                if (key == null || value == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String kid = key.getAttribute("id");
                String vid = value.getAttribute("id");
                Object k = this.value(obj, key);
                Object v = this.value(obj, value);
                map.put(k, v);
                if (kid != null) {
                    this._configuration.getIdMap().put(kid, k);
                }
                if (vid == null) continue;
                this._configuration.getIdMap().put(vid, v);
            }
            return map;
        }

        private Object propertyObj(XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            String name = node.getAttribute("name");
            String defaultValue = node.getAttribute("default");
            Map<String, String> property_map = this._configuration.getProperties();
            String prop = property_map != null && property_map.containsKey(name) ? property_map.get(name) : defaultValue;
            if (id != null) {
                this._configuration.getIdMap().put(id, prop);
            }
            if (prop != null) {
                this.configure(prop, node, 0);
            }
            return prop;
        }

        private Object value(Object obj, XmlParser.Node node) throws Exception {
            Object value;
            String type = node.getAttribute("type");
            String ref = node.getAttribute("ref");
            if (ref != null) {
                value = this._configuration.getIdMap().get(ref);
            } else {
                if (node.size() == 0) {
                    if ("String".equals(type)) {
                        return "";
                    }
                    return null;
                }
                int first = 0;
                int last = node.size() - 1;
                if (type == null || !"String".equals(type)) {
                    Object item;
                    while (first <= last) {
                        item = node.get(first);
                        if (!(item instanceof String) || ((String)(item = ((String)item).trim())).length() > 0) break;
                        ++first;
                    }
                    while (first < last) {
                        item = node.get(last);
                        if (!(item instanceof String) || ((String)(item = ((String)item).trim())).length() > 0) break;
                        --last;
                    }
                    if (first > last) {
                        return null;
                    }
                }
                if (first == last) {
                    value = this.itemValue(obj, node.get(first));
                } else {
                    StringBuilder buf = new StringBuilder();
                    int i = first;
                    while (i <= last) {
                        Object item = node.get(i);
                        buf.append(this.itemValue(obj, item));
                        ++i;
                    }
                    value = buf.toString();
                }
            }
            if (value == null) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            if (type == null) {
                if (value instanceof String) {
                    return ((String)value).trim();
                }
                return value;
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, String.class)) {
                return value.toString();
            }
            Class<?> pClass = TypeUtil.fromName(type);
            if (pClass != null) {
                return TypeUtil.valueOf(pClass, value.toString());
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, URL.class)) {
                if (value instanceof URL) {
                    return value;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, InetAddress.class)) {
                if (value instanceof InetAddress) {
                    return value;
                }
                try {
                    return InetAddress.getByName(value.toString());
                }
                catch (UnknownHostException e) {
                    throw new InvocationTargetException(e);
                }
            }
            Class[] classArray = __supportedCollections;
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class collectionClass = classArray[n2];
                if (JettyXmlConfiguration.isTypeMatchingClass(type, collectionClass)) {
                    return JettyXmlConfiguration.convertArrayToCollection(value, collectionClass);
                }
                ++n2;
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        private static boolean isTypeMatchingClass(String type, Class<?> classToMatch) {
            return classToMatch.getSimpleName().equalsIgnoreCase(type) || classToMatch.getName().equals(type);
        }

        private Object itemValue(Object obj, Object item) throws Exception {
            if (item instanceof String) {
                return item;
            }
            XmlParser.Node node = (XmlParser.Node)item;
            String tag = node.getTag();
            if ("Call".equals(tag)) {
                return this.call(obj, node);
            }
            if ("Get".equals(tag)) {
                return this.get(obj, node);
            }
            if ("New".equals(tag)) {
                return this.newObj(obj, node);
            }
            if ("Ref".equals(tag)) {
                return this.refObj(obj, node);
            }
            if ("Array".equals(tag)) {
                return this.newArray(obj, node);
            }
            if ("Map".equals(tag)) {
                return this.newMap(obj, node);
            }
            if ("Property".equals(tag)) {
                return this.propertyObj(node);
            }
            if ("SystemProperty".equals(tag)) {
                String name = node.getAttribute("name");
                String defaultValue = node.getAttribute("default");
                return System.getProperty(name, defaultValue);
            }
            if ("Env".equals(tag)) {
                String name = node.getAttribute("name");
                String defaultValue = node.getAttribute("default");
                String value = System.getenv(name);
                return value == null ? defaultValue : value;
            }
            LOG.warn("Unknown value tag: " + node, new Throwable());
            return null;
        }
    }
}

