/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

@BA.Version(value=1.3f)
@BA.ShortName(value="SQL")
public class SQL
implements BA.CheckForReinitialize {
    @BA.Hide
    public Connection connection;
    @BA.Hide
    public static final int THREAD_LOCK_TIMEOUT = 60000;
    private ReentrantLock sqliteLock;
    private volatile ArrayList<Object[]> nonQueryStatementsList = new ArrayList();

    public void Initialize(String DriverClass, String JdbcUrl) throws ClassNotFoundException, SQLException {
        this.Initialize2(DriverClass, JdbcUrl, null, null);
    }

    public void Initialize2(String DriverClass, String JdbcUrl, String UserName, String Password) throws SQLException {
        try {
            Class.forName(DriverClass);
        }
        catch (ClassNotFoundException c) {
            throw new RuntimeException("Class not found: " + DriverClass + "\nAre you missing an #AdditionalJar attribute setting?");
        }
        this.connection = DriverManager.getConnection(JdbcUrl, UserName, Password);
    }

    public void InitializeAsync(BA ba, String EventName, final String DriverClass, final String JdbcUrl, final String UserName, final String Password) {
        BA.runAsync((BA)ba, (Object)this, (String)(String.valueOf(EventName) + "_ready"), (Object[])new Object[]{false}, (Callable)new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                SQL.this.Initialize2(DriverClass, JdbcUrl, UserName, Password);
                return new Object[]{true};
            }
        });
    }

    public void InitializeSQLite(String Dir, String FileName, boolean CreateIfNecessary) throws ClassNotFoundException, SQLException, FileNotFoundException {
        if ("".equals(Dir)) {
            Dir = null;
        }
        File f = new File(Dir, FileName);
        if (!CreateIfNecessary && !f.exists()) {
            throw new FileNotFoundException(f.toString());
        }
        this.Initialize("org.sqlite.JDBC", "jdbc:sqlite:" + f.toString().replace('\\', '/'));
        this.sqliteLock = new ReentrantLock();
    }

    public static void LIBRARY_DOC() {
    }

    protected void checkNull() {
        if (this.connection == null) {
            throw new RuntimeException("Object should first be initialized.");
        }
    }

    public boolean IsInitialized() {
        if (this.connection == null) {
            return false;
        }
        try {
            return !this.connection.isClosed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void ExecNonQuery(String Statement2) throws SQLException {
        this.checkNull();
        Statement st = this.connection.createStatement();
        try {
            this.startLock();
            st.execute(Statement2);
        }
        finally {
            try {
                st.close();
            }
            finally {
                this.releaseLock();
            }
        }
    }

    private void startLock() {
        if (this.sqliteLock != null) {
            try {
                if (!this.sqliteLock.tryLock(60000L, TimeUnit.MILLISECONDS)) {
                    System.err.println("Thread is waiting for more than 60 seconds for the previous transaction to complete...");
                    Thread.dumpStack();
                    this.sqliteLock.lock();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void releaseLock() {
        if (this.sqliteLock != null) {
            this.sqliteLock.unlock();
        }
    }

    public void ExecNonQuery2(String Statement2, List Args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(Statement2);
        try {
            int numArgs = !Args.IsInitialized() ? 0 : Args.getSize();
            int i = 0;
            while (i < numArgs) {
                ps.setObject(i + 1, Args.Get(i));
                ++i;
            }
            this.startLock();
            ps.execute();
        }
        finally {
            try {
                ps.close();
            }
            finally {
                this.releaseLock();
            }
        }
    }

    public void AddNonQueryToBatch(String Statement2, List Args) {
        this.nonQueryStatementsList.add(new Object[]{Statement2, Args});
    }

    public void ExecNonQueryBatch(final BA ba, final String EventName) {
        final ArrayList<Object[]> myList = this.nonQueryStatementsList;
        this.nonQueryStatementsList = new ArrayList();
        BA.submitRunnable((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Connection connection = SQL.this.connection;
                synchronized (connection) {
                    try {
                        SQL.this.BeginTransaction();
                        for (Object[] o : myList) {
                            SQL.this.ExecNonQuery2((String)o[0], (List)o[1]);
                        }
                        SQL.this.TransactionSuccessful();
                        ba.raiseEventFromDifferentThread((Object)SQL.this, null, 0, String.valueOf(EventName.toLowerCase(BA.cul)) + "_nonquerycomplete", true, new Object[]{true});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            SQL.this.Rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                        ba.setLastException(e);
                        ba.raiseEventFromDifferentThread((Object)SQL.this, null, 0, String.valueOf(EventName.toLowerCase(BA.cul)) + "_nonquerycomplete", true, new Object[]{false});
                    }
                }
            }
        }, null, (int)0);
    }

    public ResultSetWrapper ExecQuery(String Query) throws SQLException {
        this.checkNull();
        return this.ExecQuery2(Query, null);
    }

    public ResultSetWrapper ExecQuery2(String Query, List Args) throws SQLException {
        this.checkNull();
        PreparedStatement ps = this.connection.prepareStatement(Query);
        if (Args != null && Args.IsInitialized()) {
            int i = 0;
            while (i < Args.getSize()) {
                ps.setObject(i + 1, Args.Get(i));
                ++i;
            }
        }
        ResultSetWrapper rs = new ResultSetWrapper();
        rs.setObject(ps.executeQuery());
        ResultSetWrapper.closePS.put((ResultSet)rs.getObject(), ps);
        return rs;
    }

    public Object CreateCallStatement(String Query, List Args) throws SQLException {
        this.checkNull();
        CallableStatement cs = this.connection.prepareCall(Query);
        if (Args != null && Args.IsInitialized()) {
            int i = 0;
            while (i < Args.getSize()) {
                cs.setObject(i + 1, Args.Get(i));
                ++i;
            }
        }
        return cs;
    }

    public ResultSetWrapper ExecCall(Object CallStatement) throws SQLException {
        this.checkNull();
        CallableStatement cs = (CallableStatement)CallStatement;
        ResultSetWrapper rs = new ResultSetWrapper();
        rs.setObject(cs.executeQuery());
        ResultSetWrapper.closePS.put((ResultSet)rs.getObject(), cs);
        return rs;
    }

    public void ExecQueryAsync(final BA ba, final String EventName, final String Query, final List Args) {
        BA.submitRunnable((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ResultSetWrapper c = SQL.this.ExecQuery2(Query, Args);
                    ba.raiseEventFromDifferentThread((Object)SQL.this, null, 0, String.valueOf(EventName.toLowerCase(BA.cul)) + "_querycomplete", true, new Object[]{true, c});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ba.setLastException(e);
                    ba.raiseEventFromDifferentThread((Object)SQL.this, null, 0, String.valueOf(EventName.toLowerCase(BA.cul)) + "_querycomplete", true, new Object[]{false, AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new ResultSetWrapper(), null)});
                }
            }
        }, (Object)this, (int)0);
    }

    public String ExecQuerySingleResult(String Query) throws SQLException {
        return this.ExecQuerySingleResult2(Query, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String ExecQuerySingleResult2(String Query, List Args) throws SQLException {
        this.checkNull();
        ResultSetWrapper cursor = this.ExecQuery2(Query, Args);
        try {
            if (!cursor.NextRow()) {
                return null;
            }
            if (cursor.getColumnCount() == 0) {
                return null;
            }
            String string = cursor.GetString2(0);
            return string;
        }
        finally {
            cursor.Close();
        }
    }

    public void BeginTransaction() throws SQLException {
        this.checkNull();
        this.startLock();
        this.connection.setAutoCommit(false);
    }

    public void TransactionSuccessful() throws SQLException {
        try {
            this.connection.setAutoCommit(true);
        }
        finally {
            this.releaseLock();
        }
    }

    public void Rollback() throws SQLException {
        try {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
        }
        finally {
            this.releaseLock();
        }
    }

    public void Close() throws SQLException {
        if (this.sqliteLock != null && this.sqliteLock.isHeldByCurrentThread()) {
            this.releaseLock();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    @BA.ShortName(value="ResultSet")
    public static class ResultSetWrapper
    extends AbsObjectWrapper<ResultSet> {
        @BA.Hide
        public static final ConcurrentHashMap<ResultSet, Statement> closePS = new ConcurrentHashMap();

        public boolean NextRow() throws SQLException {
            return ((ResultSet)this.getObject()).next();
        }

        public String GetColumnName(int Index) throws SQLException {
            return ((ResultSet)this.getObject()).getMetaData().getColumnLabel(Index + 1);
        }

        public int getColumnCount() throws SQLException {
            return ((ResultSet)this.getObject()).getMetaData().getColumnCount();
        }

        public int GetInt2(int Index) throws SQLException {
            return ((ResultSet)this.getObject()).getInt(Index + 1);
        }

        public int GetInt(String ColumnName) throws SQLException {
            return ((ResultSet)this.getObject()).getInt(ColumnName);
        }

        public String GetString2(int Index) throws SQLException {
            return ((ResultSet)this.getObject()).getString(Index + 1);
        }

        public String GetString(String ColumnName) throws SQLException {
            return ((ResultSet)this.getObject()).getString(ColumnName);
        }

        public Long GetLong2(int Index) throws SQLException {
            return ((ResultSet)this.getObject()).getLong(Index + 1);
        }

        public Long GetLong(String ColumnName) throws SQLException {
            return ((ResultSet)this.getObject()).getLong(ColumnName);
        }

        public Double GetDouble2(int Index) throws SQLException {
            return ((ResultSet)this.getObject()).getDouble(Index + 1);
        }

        public Double GetDouble(String ColumnName) throws SQLException {
            return ((ResultSet)this.getObject()).getDouble(ColumnName);
        }

        public byte[] GetBlob(String ColumnName) throws SQLException {
            return ((ResultSet)this.getObject()).getBytes(ColumnName);
        }

        public byte[] GetBlob2(int Index) throws SQLException {
            return ((ResultSet)this.getObject()).getBytes(Index + 1);
        }

        public void Close() throws SQLException {
            ((ResultSet)this.getObject()).close();
            Statement ps = closePS.remove(this.getObject());
            if (ps != null) {
                ps.close();
            }
        }
    }
}

