/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4j.objects.JFX;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.DefaultPropertyEditorFactory;
import org.controlsfx.property.editor.Editors;
import org.controlsfx.property.editor.PropertyEditor;

@BA.ShortName(value="PropertySheet")
public class PropertySheetWrapper
extends NodeWrapper.ControlWrapper<PropertySheet> {
    @BA.Hide
    public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new PropertySheet());
        }
        super.innerInitialize(ba, eventName, true);
        ((PropertySheet)this.getObject()).setPropertyEditorFactory((Callback)new DefaultPropertyEditorFactory(){

            public PropertyEditor<?> call(PropertySheet.Item item) {
                TypePropertyItem tpi = (TypePropertyItem)item;
                if (tpi.metaData.choices != null) {
                    return Editors.createChoiceEditor((PropertySheet.Item)tpi, (Collection)((Collection)tpi.metaData.choices.getObject()));
                }
                return super.call(item);
            }
        });
    }

    public void Set(Object DataObject, Map MetaData) throws NoSuchFieldException, SecurityException {
        ObservableList items = FXCollections.observableArrayList();
        for (Map.Entry e : ((Map.MyMap)MetaData.getObjectOrNull()).entrySet()) {
            String fieldName = (String)e.getKey();
            PropertyMetaData pmd = (PropertyMetaData)e.getValue();
            Field f = DataObject.getClass().getDeclaredField(fieldName);
            TypePropertyItem tpi = f.getType() == JFX.FontWrapper.class ? new TypePropertyItem(f, DataObject, pmd){

                @Override
                public Class<?> getType() {
                    return Font.class;
                }

                @Override
                public Object getValue() {
                    try {
                        JFX.FontWrapper fw = (JFX.FontWrapper)this.field.get(this.target);
                        if (!fw.IsInitialized()) {
                            return JFX.DefaultFont((double)12.0).getObject();
                        }
                        return fw.getObject();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void setValue(Object value) {
                    try {
                        this.field.set(this.target, AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new JFX.FontWrapper(), (Object)value));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } : (f.getType() == JFX.PaintWrapper.class ? new TypePropertyItem(f, DataObject, pmd){

                @Override
                public Class<?> getType() {
                    return Color.class;
                }

                @Override
                public Object getValue() {
                    try {
                        JFX.PaintWrapper fw = (JFX.PaintWrapper)this.field.get(this.target);
                        if (!fw.IsInitialized()) {
                            return JFX.Colors.Black;
                        }
                        return fw.getObject();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void setValue(Object value) {
                    try {
                        this.field.set(this.target, AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new JFX.PaintWrapper(), (Object)value));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } : (f.getType() == Long.TYPE ? new TypePropertyItem(f, DataObject, pmd){

                @Override
                public Class<?> getType() {
                    return LocalDate.class;
                }

                @Override
                public Object getValue() {
                    try {
                        long value = (Long)this.field.get(this.target);
                        Instant i = Instant.ofEpochMilli(value);
                        ZonedDateTime zdt = ZonedDateTime.ofInstant(i, ZoneId.systemDefault());
                        return zdt.toLocalDate();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void setValue(Object value) {
                    try {
                        this.field.set(this.target, PropertySheetWrapper.this.LocaleDateToLong((LocalDate)value));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } : new TypePropertyItem(f, DataObject, pmd)));
            items.add((Object)tpi);
        }
        ((PropertySheet)this.getObject()).getItems().setAll((Collection)items);
    }

    public PropertyMetaData CreateMeta(String Name, String Category2, String Description) {
        return new PropertyMetaData(Name, Category2, Description);
    }

    public boolean getSearchBoxVisible() {
        return ((PropertySheet)this.getObject()).isSearchBoxVisible();
    }

    public void setSearchBoxVisible(boolean b) {
        ((PropertySheet)this.getObject()).setSearchBoxVisible(b);
    }

    public boolean getModeSwitcherVisible() {
        return ((PropertySheet)this.getObject()).isModeSwitcherVisible();
    }

    public void setModeSwitcherVisible(boolean b) {
        ((PropertySheet)this.getObject()).setModeSwitcherVisible(b);
    }

    private long LocaleDateToLong(LocalDate ld) {
        if (ld == null) {
            return 0L;
        }
        return ld.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @BA.ShortName(value="PropertyMetaData")
    public static class PropertyMetaData {
        public String Name;
        public String Category;
        public String Description;
        List choices;
        boolean Readonly;

        public PropertyMetaData() {
            this.Name = "";
            this.Category = "";
            this.Description = "";
        }

        public PropertyMetaData(String name, String category, String description) {
            this.Name = name;
            this.Category = category;
            this.Description = description;
        }

        public PropertyMetaData SetChoices(List Values) {
            this.choices = Values;
            return this;
        }

        public PropertyMetaData SetReadonly() {
            this.Readonly = true;
            return this;
        }
    }

    @BA.Hide
    public static class TypePropertyItem
    implements PropertySheet.Item {
        protected final Field field;
        protected final Object target;
        public final PropertyMetaData metaData;

        public TypePropertyItem(Field field, Object target, PropertyMetaData metaData) {
            this.field = field;
            this.target = target;
            this.metaData = metaData;
        }

        public String getCategory() {
            return this.metaData.Category;
        }

        public String getName() {
            return this.metaData.Name;
        }

        public String getDescription() {
            return this.metaData.Description;
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public Object getValue() {
            try {
                return this.field.get(this.target);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setValue(Object value) {
            try {
                this.field.set(this.target, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isEditable() {
            return !this.metaData.Readonly;
        }
    }
}

