/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.randomaccessfile;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.streams.File;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

@BA.ShortName(value="CompressedStreams")
public class CompressedStreams {
    public File.InputStreamWrapper WrapInputStream(InputStream In, String CompressMethod) throws IOException {
        InputStream cin = this.getInputStream(CompressMethod, In);
        File.InputStreamWrapper i = new File.InputStreamWrapper();
        i.setObject((Object)cin);
        return i;
    }

    public File.OutputStreamWrapper WrapOutputStream(OutputStream Out, String CompressMethod) throws IOException {
        OutputStream cout = this.getOutputStream(CompressMethod, Out);
        File.OutputStreamWrapper i = new File.OutputStreamWrapper();
        i.setObject((Object)cout);
        return i;
    }

    public byte[] CompressBytes(byte[] Data, String CompressMethod) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream(Data.length);
        OutputStream outputStream = this.getOutputStream(CompressMethod, b);
        outputStream.write(Data);
        outputStream.close();
        return b.toByteArray();
    }

    public byte[] DecompressBytes(byte[] CompressedData, String CompressMethod) throws IOException {
        ByteArrayInputStream b = new ByteArrayInputStream(CompressedData);
        InputStream in = this.getInputStream(CompressMethod, b);
        ByteArrayOutputStream out = new ByteArrayOutputStream(CompressedData.length);
        File.Copy2((InputStream)in, (OutputStream)out);
        return out.toByteArray();
    }

    private InputStream getInputStream(String CompressMethod, InputStream In) throws IOException {
        InflaterInputStream cin;
        String m = CompressMethod.toLowerCase(BA.cul);
        if (m.equals("gzip")) {
            cin = new GZIPInputStream(In);
        } else if (m.equals("zlib")) {
            cin = new InflaterInputStream(In);
        } else {
            throw new RuntimeException("Unknown compression method: " + CompressMethod);
        }
        return cin;
    }

    private OutputStream getOutputStream(String CompressMethod, OutputStream out) throws IOException {
        DeflaterOutputStream cout;
        String m = CompressMethod.toLowerCase(BA.cul);
        if (m.equals("gzip")) {
            cout = new GZIPOutputStream(out);
        } else if (m.equals("zlib")) {
            cout = new DeflaterOutputStream(out);
        } else {
            throw new RuntimeException("Unknown compression method: " + CompressMethod);
        }
        return cout;
    }
}

