/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;

@BA.Version(value=1.0f)
@BA.ShortName(value="SystemTray")
public class SystemTrayWrapper {
    @BA.Hide
    public SystemTray st;

    public void Initialize() {
        if (SystemTray.isSupported()) {
            this.st = SystemTray.getSystemTray();
        }
    }

    public boolean getSupported() {
        return SystemTray.isSupported();
    }

    public void AddTrayIcon(TrayIconWrapper TrayIcon2) throws AWTException {
        if (this.st.getTrayIcons().length == 0) {
            Platform.setImplicitExit((boolean)false);
        }
        this.st.add((TrayIcon)TrayIcon2.getObject());
    }

    public void RemoveTrayIcon(TrayIconWrapper TrayIcon2) {
        this.st.remove((TrayIcon)TrayIcon2.getObject());
        if (this.st.getTrayIcons().length == 0) {
            Platform.setImplicitExit((boolean)true);
        }
    }

    @BA.ShortName(value="TrayIcon")
    public static class TrayIconWrapper
    extends AbsObjectWrapper<TrayIcon> {
        public void Initialize(final BA ba, String EventName, Image Image2, List MenuItems) {
            final TrayIcon ti = new TrayIcon(SwingFXUtils.fromFXImage((Image)Image2, null));
            this.setObject(ti);
            ti.setImageAutoSize(true);
            final String eventName = EventName.toLowerCase(BA.cul);
            if (ba.subExists(String.valueOf(eventName) + "_doubleclick")) {
                ti.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ba.raiseEventFromDifferentThread((Object)ti, null, 0, String.valueOf(eventName) + "_doubleclick", false, null);
                    }
                });
            }
            if (MenuItems != null && MenuItems.IsInitialized()) {
                PopupMenu menu = new PopupMenu();
                for (Object s : (java.util.List)MenuItems.getObject()) {
                    final MenuItem mi = new MenuItem(String.valueOf(s));
                    menu.add(mi);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ba.raiseEventFromDifferentThread((Object)ti, null, 0, String.valueOf(eventName) + "_menuclick", true, new Object[]{mi.getLabel()});
                        }
                    });
                }
                ti.setPopupMenu(menu);
            }
        }

        public void SetImage(Image Image2) {
            ((TrayIcon)this.getObject()).setImage(SwingFXUtils.fromFXImage((Image)Image2, null));
        }

        public void setToolTip(String s) {
            ((TrayIcon)this.getObject()).setToolTip(s);
        }

        public String getToolTip() {
            return ((TrayIcon)this.getObject()).getToolTip();
        }
    }
}

