/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.debug;

import anywheresoftware.b4a.B4AClass;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.ShellBA;
import anywheresoftware.b4a.debug.RDebugUtils;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.shell.Shell;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Semaphore;

public class Debug {
    private static final Semaphore semaphore = new Semaphore(0);
    public static HashSet<String> subsWithBreakpoints = new HashSet();
    public static boolean alreadyPausedOnce = false;
    public static boolean disableDelegate;
    private static final HashMap<Class<?>, HashMap<String, Method>> allSubs;

    static {
        allSubs = new HashMap();
    }

    public static void StartFromShell(BA ba) {
        BA.debugMode = true;
        BA.shellMode = true;
        Debug.wait(ba, 0, null);
    }

    public static void wait(BA ba, int line, String lineText) {
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void stopWaiting() {
        semaphore.release();
    }

    public static boolean shouldDelegate(String sub) {
        String s = String.valueOf(RDebugUtils.currentModule) + ":" + sub;
        if (disableDelegate) {
            subsWithBreakpoints.remove(s);
            disableDelegate = false;
            return false;
        }
        if (alreadyPausedOnce && !Shell.INSTANCE.inGoodChain) {
            return true;
        }
        return subsWithBreakpoints.contains(s);
    }

    public static Object delegate(BA ba, String sub, Object[] args) {
        return ba.raiseEvent2(null, true, sub, true, args);
    }

    public static void fillBreakpoints(Object[] bps) {
        if (!Shell.INSTANCE.inGoodChain && Shell.INSTANCE.raiseEventStack.size() == 1) {
            subsWithBreakpoints = new HashSet();
            alreadyPausedOnce = false;
        }
        int i = 0;
        while (i < bps.length) {
            subsWithBreakpoints.add(String.valueOf((String)bps[i]) + ":" + (String)bps[i + 1]);
            i += 2;
        }
    }

    public static Object CallSubNew(BA mine, Object Component, String Sub) {
        return Debug.CallSub4(mine, Component, Sub, null);
    }

    public static Object CallSubNew2(BA mine, Object Component, String Sub, Object Argument) {
        return Debug.CallSub4(mine, Component, Sub, new Object[]{Argument});
    }

    public static Object CallSubNew3(BA mine, Object Component, String Sub, Object Argument1, Object Argument2) {
        return Debug.CallSub4(mine, Component, Sub, new Object[]{Argument1, Argument2});
    }

    private static Object CallSub4(BA mine, Object Component, String Sub, Object[] Arguments) {
        try {
            Object o = null;
            BA ba = Common.getComponentBA((BA)mine, (Object)Component);
            if (ba != null) {
                Method m;
                HashMap<Object, Object> htSubs;
                boolean isTargetClass = Component instanceof B4AClass;
                Class<?> cls = Class.forName(ba.className);
                if (!allSubs.containsKey(cls)) {
                    htSubs = new HashMap();
                    Method[] methodArray = cls.getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        m = methodArray[n2];
                        if (m.getName().startsWith("_")) {
                            htSubs.put(m.getName().substring(1).toLowerCase(BA.cul), m);
                        }
                        ++n2;
                    }
                    allSubs.put(cls, htSubs);
                }
                htSubs = allSubs.get(cls);
                if (isTargetClass) {
                    Arguments = ShellBA.addItemToArray(null, Arguments);
                }
                if ((m = (Method)htSubs.get(Sub.toLowerCase(BA.cul))) != null) {
                    try {
                        o = m.invoke(ba.eventsTarget, Arguments);
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println(m);
                        throw new Exception("Sub " + Sub + " signature does not match expected signature.");
                    }
                } else if (!isTargetClass) {
                    throw new Exception("Sub " + Sub + " was not found.");
                }
            }
            if (o != null && o instanceof ObjectWrapper) {
                return ((ObjectWrapper)o).getObject();
            }
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

