/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.debug;

import anywheresoftware.b4a.ConnectorConsumer;
import anywheresoftware.b4a.ConnectorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

class DebugConnector
implements Runnable,
ConnectorConsumer {
    private static ConcurrentHashMap<Integer, Integer> usedPorts = new ConcurrentHashMap();
    public volatile boolean working = true;
    BlockingQueue<byte[]> writerQ = new ArrayBlockingQueue<byte[]>(20);
    public static final int PING = 1;
    private final MessageHandler handler;
    private volatile Writer writer;
    private final int port;
    private static final int NUMBER_OF_TIMES_TO_WAIT = 1;
    private final String uuid;
    private ServerSocket server;
    private Socket socket;
    private Thread writerT;
    private AtomicReference<Long> lastReadtime = new AtomicReference<Long>(0L);
    private static final int ALTERNATE_PORT_DELTA = 117;

    public DebugConnector(MessageHandler handler, int port, String UUID) {
        this.handler = handler;
        this.port = port;
        this.uuid = UUID;
    }

    public boolean shouldAddPrefix() {
        return this.uuid != null;
    }

    public void putTask(byte[] data) {
        if (!this.writerQ.offer(data)) {
            this.writerQ.clear();
            this.writerQ.add(data);
        }
    }

    @Override
    public void run() {
        while (usedPorts.putIfAbsent(this.port, 0) != null) {
            this.sleep(200);
        }
        try {
            this.mainLoop();
        }
        finally {
            usedPorts.remove(this.port);
        }
    }

    public void stop() {
        this.working = false;
        try {
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            if (this.writerT != null) {
                this.writer.writerWorking = false;
                this.writerT.interrupt();
                this.writerT = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mainLoop() {
        int waitingFor = 0;
        while (this.working) {
            this.server = null;
            this.socket = null;
            this.writerT = null;
            try {
                try {
                    try {
                        this.server = new ServerSocket(this.port, 1);
                    }
                    catch (BindException be) {
                        System.out.println("debugger switching to alternate port");
                        this.server = new ServerSocket(this.port + 117, 1);
                    }
                    this.server.setSoTimeout(10000);
                    this.socket = this.server.accept();
                    OutputStream out = this.socket.getOutputStream();
                    this.socket.setSoTimeout(10000);
                    InputStream in = this.socket.getInputStream();
                    waitingFor = 0;
                    this.writer = new Writer(out);
                    this.writerT = new Thread(this.writer);
                    this.writerT.setDaemon(true);
                    this.writerT.start();
                    ConnectorUtils.startMessage((byte)1);
                    ConnectorUtils.sendMessage((ConnectorConsumer)this);
                    this.handler.connectionStatus(true);
                    this.readData(in);
                }
                catch (Exception ste) {
                    ste.printStackTrace();
                    if (++waitingFor >= 1) {
                        this.working = false;
                    }
                    if (this.writer != null) {
                        this.writer.writerWorking = false;
                        if (this.writerT != null) {
                            this.writerT.interrupt();
                        }
                    }
                    try {
                        if (this.server != null) {
                            this.server.close();
                        }
                        if (this.socket != null) {
                            if (!this.socket.isInputShutdown()) {
                                this.socket.shutdownInput();
                            }
                            if (!this.socket.isOutputShutdown()) {
                                this.socket.shutdownOutput();
                            }
                            this.socket.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!this.working) continue;
                    this.sleep(500);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.writer != null) {
                    this.writer.writerWorking = false;
                    if (this.writerT != null) {
                        this.writerT.interrupt();
                    }
                }
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                    if (this.socket != null) {
                        if (!this.socket.isInputShutdown()) {
                            this.socket.shutdownInput();
                        }
                        if (!this.socket.isOutputShutdown()) {
                            this.socket.shutdownOutput();
                        }
                        this.socket.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.working) {
                    this.sleep(500);
                }
                throw throwable;
            }
            if (this.writer != null) {
                this.writer.writerWorking = false;
                if (this.writerT != null) {
                    this.writerT.interrupt();
                }
            }
            try {
                if (this.server != null) {
                    this.server.close();
                }
                if (this.socket != null) {
                    if (!this.socket.isInputShutdown()) {
                        this.socket.shutdownInput();
                    }
                    if (!this.socket.isOutputShutdown()) {
                        this.socket.shutdownOutput();
                    }
                    this.socket.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.working) continue;
            this.sleep(500);
        }
        this.handler.connectionStatus(false);
    }

    private void readData(InputStream in) throws IOException {
        while (this.working) {
            int b = in.read();
            this.lastReadtime.set(System.currentTimeMillis());
            if (b == 1) {
                ConnectorUtils.startMessage((byte)1);
                ConnectorUtils.sendMessage((ConnectorConsumer)this);
            }
            if (b == -1) {
                System.out.println("-1 received");
                break;
            }
            if (b > 0) {
                this.handler.handleIncomingData(b, in);
            }
            if (this.writer == null) break;
        }
    }

    void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public static interface MessageHandler {
        public void connectionStatus(boolean var1);

        public void handleIncomingData(int var1, InputStream var2);
    }

    class Writer
    implements Runnable {
        private OutputStream out;
        public volatile boolean writerWorking = true;

        public Writer(OutputStream out) {
            this.out = out;
        }

        @Override
        public void run() {
            while (DebugConnector.this.working && this.writerWorking) {
                try {
                    byte[] buffer = DebugConnector.this.writerQ.take();
                    this.out.write(buffer);
                }
                catch (InterruptedException buffer) {
                }
                catch (Exception e) {
                    System.out.println("writer error");
                    e.printStackTrace();
                    break;
                }
            }
            DebugConnector.this.writer = null;
        }
    }
}

