/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.debug;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.shell.ArraysUtils;
import anywheresoftware.b4a.shell.Shell;

public class RDebugUtils {
    public static int currentLine;
    public static String currentModule;

    public static BA processBAFromBA(BA _ba) {
        return _ba;
    }

    public static void setLastException(BA ba, String message) {
        ba.setLastException(new Exception(message.replace("anywheresoftware.b4a.shell.ShellConnector$DeviceException:", "")));
    }

    public static void LogErrorAndExit(String error) {
        if (error.length() > 0) {
            BA.LogError((String)error);
        }
        if (BA.exitOnUnhandledExceptions) {
            Shell.INSTANCE.stopProgram();
        }
    }

    public static boolean msgboxDismissing() {
        return false;
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1 instanceof Long) {
                return ((Number)o1).longValue() == ((Number)o2).longValue();
            }
            return ((Number)o1).doubleValue() == ((Number)o2).doubleValue();
        }
        return o1.equals(o2);
    }

    public static Number numberCast(String targetType, Object obj) {
        Class<?> outputType = ArraysUtils.primitives.get(targetType);
        Number value = obj instanceof Number ? (Number)((Number)obj) : (Number)(obj instanceof String ? (Number)Double.parseDouble((String)obj) : (Number)(Long.TYPE.equals(outputType) ? (Number)Long.parseLong(String.valueOf(obj)) : (Number)Double.parseDouble(String.valueOf(obj))));
        if (Byte.TYPE.equals(outputType)) {
            return value.byteValue();
        }
        if (Short.TYPE.equals(outputType)) {
            return value.shortValue();
        }
        if (Integer.TYPE.equals(outputType)) {
            return value.intValue();
        }
        if (Long.TYPE.equals(outputType)) {
            return value.longValue();
        }
        if (Float.TYPE.equals(outputType)) {
            return Float.valueOf(value.floatValue());
        }
        if (Double.TYPE.equals(outputType)) {
            return value.doubleValue();
        }
        throw new RuntimeException("Unknown type: " + value);
    }

    public static String ObjectToString(Object o) {
        return String.valueOf(o);
    }

    public static String concat(Object[] strings) {
        String ret = "";
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            String com = s instanceof Long ? BA.NumberToString((Number)((Long)s)) : (s instanceof Number ? BA.NumberToString((double)((Number)s).doubleValue()) : String.valueOf(s));
            ret = String.valueOf(ret) + com;
            ++n2;
        }
        return ret;
    }

    public static boolean solveBoolean(String operations, Object[] operands) throws ClassNotFoundException {
        int operandsIndex = 0;
        boolean currentResult = false;
        int i = 0;
        while (i < operations.length()) {
            char operator = operations.charAt(i);
            if (operator == '=' || operator == '!') {
                currentResult = RDebugUtils.equals(operands[operandsIndex++], operands[operandsIndex++]);
                if (operator == '!') {
                    currentResult = !currentResult;
                }
            } else if (operator == '.') {
                currentResult = (Boolean)operands[operandsIndex++];
            } else if (operator == 'n') {
                currentResult = operands[operandsIndex++] == null;
            } else if (operator == 'N') {
                currentResult = operands[operandsIndex++] != null;
            } else if (operator == 'i') {
                Object target = operands[operandsIndex++];
                Class<?> cls = Shell.getCorrectClassName((String)operands[operandsIndex++]);
                currentResult = target == null ? false : cls.isAssignableFrom(target.getClass());
            } else {
                Number n1 = (Number)operands[operandsIndex++];
                Number n2 = (Number)operands[operandsIndex++];
                int compare = n1 instanceof Long ? ((Long)n1).compareTo(n2.longValue()) : Double.compare(n1.doubleValue(), n2.doubleValue());
                if (operator == '<') {
                    currentResult = compare < 0;
                } else if (operator == '>') {
                    currentResult = compare > 0;
                } else if (operator == 'k') {
                    currentResult = compare <= 0;
                } else if (operator == 'g') {
                    currentResult = compare >= 0;
                }
            }
            ++i;
        }
        return currentResult;
    }

    public static Number solve(Object[] numbers, String operations, int numberOfSums, int calcType) {
        if (numberOfSums + 1 == numbers.length) {
            if (calcType == 0) {
                double sum = ((Number)numbers[0]).doubleValue();
                int i = 0;
                while (i < numbers.length - 1) {
                    char o = operations.charAt(i);
                    if (o == '+') {
                        sum += ((Number)numbers[i + 1]).doubleValue();
                    } else if (o == '-') {
                        sum -= ((Number)numbers[i + 1]).doubleValue();
                    }
                    ++i;
                }
                return sum;
            }
            if (calcType == 1) {
                int sum = ((Number)numbers[0]).intValue();
                int i = 0;
                while (i < numbers.length - 1) {
                    char o = operations.charAt(i);
                    if (o == '+') {
                        sum += ((Number)numbers[i + 1]).intValue();
                    } else if (o == '-') {
                        sum -= ((Number)numbers[i + 1]).intValue();
                    }
                    ++i;
                }
                return sum;
            }
            long sum = ((Number)numbers[0]).longValue();
            int i = 0;
            while (i < numbers.length - 1) {
                char o = operations.charAt(i);
                if (o == '+') {
                    sum += ((Number)numbers[i + 1]).longValue();
                } else if (o == '-') {
                    sum -= ((Number)numbers[i + 1]).longValue();
                }
                ++i;
            }
            return sum;
        }
        if (calcType == 0) {
            double[] sums = new double[numberOfSums + 1];
            int sumIndex = 0;
            int i = 0;
            while (i < numbers.length - 1) {
                char o = operations.charAt(i);
                double d = ((Number)numbers[i]).doubleValue();
                while (i < operations.length() && ((o = operations.charAt(i)) == '*' || o == '/' || o == '%')) {
                    d = o == '*' ? (d *= ((Number)numbers[i + 1]).doubleValue()) : (o == '/' ? (d /= ((Number)numbers[i + 1]).doubleValue()) : (d %= ((Number)numbers[i + 1]).doubleValue()));
                    ++i;
                }
                sums[sumIndex++] = d;
                ++i;
            }
            if (sumIndex < sums.length) {
                sums[sumIndex] = ((Number)numbers[numbers.length - 1]).doubleValue();
            }
            sumIndex = 1;
            double sum = sums[0];
            int i2 = 0;
            while (i2 < numbers.length - 1) {
                char o = operations.charAt(i2);
                if (o == '+') {
                    sum += sums[sumIndex++];
                } else if (o == '-') {
                    sum -= sums[sumIndex++];
                }
                ++i2;
            }
            return sum;
        }
        if (calcType == 1) {
            int[] sums = new int[numberOfSums + 1];
            int sumIndex = 0;
            int i = 0;
            while (i < numbers.length - 1) {
                char o = operations.charAt(i);
                int d = ((Number)numbers[i]).intValue();
                while (i < operations.length() && ((o = operations.charAt(i)) == '*' || o == '/' || o == '%')) {
                    d = o == '*' ? (d *= ((Number)numbers[i + 1]).intValue()) : (o == '/' ? (d /= ((Number)numbers[i + 1]).intValue()) : (d %= ((Number)numbers[i + 1]).intValue()));
                    ++i;
                }
                sums[sumIndex++] = d;
                ++i;
            }
            if (sumIndex < sums.length) {
                sums[sumIndex] = ((Number)numbers[numbers.length - 1]).intValue();
            }
            sumIndex = 1;
            int sum = sums[0];
            int i3 = 0;
            while (i3 < numbers.length - 1) {
                char o = operations.charAt(i3);
                if (o == '+') {
                    sum += sums[sumIndex++];
                } else if (o == '-') {
                    sum -= sums[sumIndex++];
                }
                ++i3;
            }
            return sum;
        }
        long[] sums = new long[numberOfSums + 1];
        int sumIndex = 0;
        int i = 0;
        while (i < numbers.length - 1) {
            char o = operations.charAt(i);
            long d = ((Number)numbers[i]).longValue();
            while (i < operations.length() && ((o = operations.charAt(i)) == '*' || o == '/' || o == '%')) {
                d = o == '*' ? (d *= ((Number)numbers[i + 1]).longValue()) : (o == '/' ? (d /= ((Number)numbers[i + 1]).longValue()) : (d %= ((Number)numbers[i + 1]).longValue()));
                ++i;
            }
            sums[sumIndex++] = d;
            ++i;
        }
        if (sumIndex < sums.length) {
            sums[sumIndex] = ((Number)numbers[numbers.length - 1]).longValue();
        }
        sumIndex = 1;
        long sum = sums[0];
        int i4 = 0;
        while (i4 < numbers.length - 1) {
            char o = operations.charAt(i4);
            if (o == '+') {
                sum += sums[sumIndex++];
            } else if (o == '-') {
                sum -= sums[sumIndex++];
            }
            ++i4;
        }
        return sum;
    }
}

