/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.shell;

import anywheresoftware.b4a.shell.Shell;
import anywheresoftware.b4a.shell.ShellConnector;
import java.io.DataOutputStream;
import java.lang.reflect.Array;
import java.util.HashMap;

public class ArraysUtils {
    public static final HashMap<String, Class<?>> primitives = new HashMap();
    public static final HashMap<Class<?>, Class<?>> primitiveToBoxed = new HashMap();

    static {
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitiveToBoxed.put(Byte.TYPE, Byte.class);
        primitiveToBoxed.put(Character.TYPE, Character.class);
        primitiveToBoxed.put(Short.TYPE, Short.class);
        primitiveToBoxed.put(Integer.TYPE, Integer.class);
        primitiveToBoxed.put(Long.TYPE, Long.class);
        primitiveToBoxed.put(Float.TYPE, Float.class);
        primitiveToBoxed.put(Double.TYPE, Double.class);
        primitiveToBoxed.put(Boolean.TYPE, Boolean.class);
    }

    public static Object createArray(String type, int[] rank, Object[] values) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object arr;
        block7: {
            boolean primitive;
            Class<?> c;
            block6: {
                c = primitives.get(type);
                boolean bl = primitive = c != null;
                if (!primitive) {
                    c = Shell.getCorrectClassName(type);
                }
                arr = Array.newInstance(c, rank);
                if (values == null || values.length <= 0) break block6;
                int i = 0;
                while (i < values.length) {
                    Array.set(arr, i, values[i]);
                    ++i;
                }
                break block7;
            }
            if (primitive) break block7;
            int[] index = new int[rank.length];
            int total = 1;
            int[] nArray = rank;
            int n = rank.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                total *= t;
                ++n2;
            }
            int i = 0;
            while (i < total) {
                int t = 0;
                while (t < rank.length) {
                    if (index[t] != rank[t]) break;
                    index[t] = 0;
                    int n3 = t + 1;
                    index[n3] = index[n3] + 1;
                    ++t;
                }
                Object a = arr;
                int r = 0;
                while (r < index.length - 1) {
                    a = Array.get(a, index[r]);
                    ++r;
                }
                Array.set(a, index[index.length - 1], c.newInstance());
                index[0] = index[0] + 1;
                ++i;
            }
        }
        return arr;
    }

    public static Object getElement(Object arr, Object[] index) {
        Object a = arr;
        int r = 0;
        while (r < index.length - 1) {
            a = Array.get(a, (Integer)index[r]);
            ++r;
        }
        return Array.get(a, (Integer)index[index.length - 1]);
    }

    public static void setElement(Object arr, Object value, Object[] index) {
        Object a = arr;
        int r = 0;
        while (r < index.length - 1) {
            a = Array.get(a, (Integer)index[r]);
            ++r;
        }
        Array.set(a, (Integer)index[index.length - 1], value);
    }

    public static void writeArrayForDebugger(DataOutputStream dout, Object array, ShellConnector connector) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        if (array instanceof SubArray) {
            SubArray sa = (SubArray)array;
            int i = sa.start;
            while (i <= sa.end) {
                dout.write(1);
                connector.writeObject(dout, String.valueOf(i), true);
                connector.writeObject(dout, Array.get(sa.arr, i), true);
                ++i;
            }
        } else {
            int len = Array.getLength(array);
            if (len < 100) {
                int i = 0;
                while (i < len) {
                    dout.write(1);
                    connector.writeObject(dout, String.valueOf(i), true);
                    connector.writeObject(dout, Array.get(array, i), true);
                    ++i;
                }
            } else {
                len = Math.min(len, 1000);
                int s = 0;
                while (s < len) {
                    dout.write(1);
                    SubArray sa = new SubArray(array, s, Math.min(s + 100, len) - 1);
                    connector.writeObject(dout, sa.start + "..." + sa.end, true);
                    connector.writeObject(dout, sa, true);
                    s += 100;
                }
            }
        }
    }

    public static class SubArray {
        final Object arr;
        final int start;
        final int end;

        public SubArray(Object arr, int start, int end) {
            this.arr = arr;
            this.start = start;
            this.end = end;
        }
    }
}

