/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.shell;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.ShellBA;
import anywheresoftware.b4a.debug.Debug;
import anywheresoftware.b4a.debug.RDebugUtils;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.shell.ArraysUtils;
import anywheresoftware.b4a.shell.ShellConnector;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Shell
implements ShellConnector.ShellHandler {
    private static final byte CODE_CHAIN_START = 2;
    private static final byte STOP = 3;
    private static final byte CONTINUE = 4;
    private static final byte GET_DEBUG_VAR = 5;
    private static final byte RUN_METHOD = 1;
    private static final byte CREATE_OBJECT = 2;
    private static final byte FILL_HTSUBS = 3;
    private static final byte CODE_CHAIN_END = 4;
    private static final byte CLEAN_MEMORY = 5;
    private static final byte RUN_VOID_METHOD = 6;
    private static final byte GET_FIELD = 7;
    private static final byte SET_FIELD = 8;
    private static final byte CREATE_ARRAY = 9;
    private static final byte ARRAY_GET = 10;
    private static final byte ARRAY_SET = 11;
    private static final byte GET = 12;
    private static final byte RUN_METHOD_WITH_SYNC = 13;
    private static final byte PAUSE = 14;
    private static final byte RUN_MESSAGE_LOOP = 15;
    private static final byte SET_STATE_BEFORE_USER_SUB = 16;
    private static final byte GET_STATE_AFTER_USER_SUB = 17;
    private static final byte DONT_PRINT_ERRORS = 18;
    private static final byte FILL_CLASSES_HTSUBS = 19;
    private static final byte SEND_BREAKPOINTS_TO_DEVICE = 20;
    private static final byte SPECIAL_NESTED_EVENT = 1;
    private static final byte SPECIAL_LOADLAYOUT = 2;
    private static final byte SPECIAL_CREATE_CUSTOM_VIEW = 3;
    private static final byte SPECIAL_ROLLBACK_AFTER_MSGBOX_DISMISSED = 4;
    private ShellConnector connector;
    private Thread connectorT;
    private HashMap<Integer, RemoteObject> heap = new HashMap(1000);
    private MethodCache methodCache = new MethodCache();
    private FieldCache fieldCache = new FieldCache();
    public static Shell INSTANCE;
    public LinkedList<Object> raiseEventStack = new LinkedList();
    private int deviceSlotCounter;
    private DataOutputStream dout;
    private DataInputStream din;
    private ShellConnector.DeviceException currentException;
    private final EventsThreshold thresh = new EventsThreshold();
    private int syncCounter = 0;
    private HashSet<String> errorMessagesForSyncEvents;
    private final HashMap<String, GoodChainData> goodEvents = new HashMap();
    public final GoodChainData maybeGoodChain = new GoodChainData();
    public boolean inGoodChain = false;
    private boolean dontPrintErrors;
    private State currentState = State.Normal;

    public Shell(int port) {
        if (INSTANCE != null) {
            throw new RuntimeException("Shell already initialized.");
        }
        this.connector = new ShellConnector(this, port, null);
        this.connectorT = new Thread(this.connector);
        this.connectorT.setDaemon(true);
        INSTANCE = this;
    }

    public void start(BA ba) {
        this.connectorT.start();
        Debug.StartFromShell(ba);
    }

    @Override
    public void connectionStatus(boolean connected) {
        if (connected) {
            this.din = new DataInputStream(this.connector.getMainInputStream());
            this.dout = new DataOutputStream(this.connector.getMainOutputStream());
            Debug.stopWaiting();
        } else {
            this.stopProgram();
        }
    }

    public void stopProgram() {
        if (this.connector != null) {
            this.connector.stop();
        }
        Common.ExitApplication();
    }

    @Override
    public void handleIncomingData(int firstByte, InputStream in) {
        switch (firstByte) {
            case 3: {
                this.stopProgram();
                break;
            }
            case 4: {
                Debug.stopWaiting();
                break;
            }
            case 5: {
                this.getDebuggerVariable(new DataInputStream(in));
            }
        }
    }

    @Override
    public void writeRemoteObject(DataOutputStream dout, Object o, boolean stringsCacheDisabled) throws Exception {
        dout.write(8);
        RemoteObject ro = new RemoteObject(o.getClass().getName(), o);
        this.heap.put(--this.deviceSlotCounter, ro);
        dout.writeInt(this.deviceSlotCounter);
        this.connector.writeObject(dout, ro.className, stringsCacheDisabled);
    }

    @Override
    public Object readRemoteObject(DataInputStream din, boolean unwrapRemoteObject, boolean array) throws Exception {
        if (array) {
            int len = din.readShort();
            Object[] o = new Object[len];
            int i = 0;
            while (i < len) {
                o[i] = this.connector.readObject(din, true);
                ++i;
            }
            return o;
        }
        int key = din.readInt();
        if (key == 0) {
            return unwrapRemoteObject ? null : new RemoteObject((String)this.connector.readObject(din, false), null);
        }
        RemoteObject ro = this.heap.get(key);
        if (ro == null) {
            return null;
        }
        return unwrapRemoteObject ? ro.value : ro;
    }

    public static Object raiseEvent(String className, String method, Object[] args, Object pseudoTarget) throws Throwable {
        if (INSTANCE == null) {
            BA.LogError((String)"Program compiled in debug mode, can only run with debugger attached.");
            return null;
        }
        return INSTANCE.raiseEventImpl(className, method, args, pseudoTarget);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object raiseEventImpl(final String className, final String method, final Object[] args, final Object pseudoTarget) throws Throwable {
        if (this.currentState == State.Paused) {
            return null;
        }
        GoodChainData gcd = this.goodEvents.get(method);
        if (gcd != null && this.currentState == State.Normal && gcd.time + 100L > System.currentTimeMillis() && gcd.pseudoTarget == pseudoTarget) {
            return this.runGoodChain(gcd, args);
        }
        boolean nested = !this.raiseEventStack.isEmpty();
        this.raiseEventStack.addFirst(Boolean.TRUE);
        try {
            if (!nested) {
                if (this.thresh.codeChainStart(method)) {
                    return null;
                }
                this.connector.sendControlMessage(new byte[]{2});
            } else {
                if (this.syncCounter < this.raiseEventStack.size() - 1) {
                    if (this.errorMessagesForSyncEvents == null) {
                        this.errorMessagesForSyncEvents = new HashSet();
                    }
                    if (this.errorMessagesForSyncEvents.add(method) && !method.equals("activity_pause") && !method.endsWith("_resize")) {
                        BA.LogError((String)("Unexpected event (missing RaiseSynchronousEvents): " + method));
                    }
                    BA.firstInstance.postRunnable((Runnable)new BA.B4ARunnable(){

                        public void run() {
                            try {
                                Shell.raiseEvent(className, method, args, pseudoTarget);
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    return null;
                }
                this.dout.write(1);
            }
            this.maybeGoodChain.assigned = null;
            this.maybeGoodChain.method = null;
            this.maybeGoodChain.pseudoTarget = pseudoTarget;
            this.connector.writeObject(this.dout, className);
            this.connector.writeObject(this.dout, method);
            this.connector.writeList(this.dout, args);
            this.dout.flush();
            block30: while (true) {
                byte command = this.din.readByte();
                try {
                    switch (command) {
                        case 1: {
                            this.runMethod(false);
                            continue block30;
                        }
                        case 13: {
                            this.runMethod(true);
                            continue block30;
                        }
                        case 6: {
                            this.runVoidMethod();
                            continue block30;
                        }
                        case 12: {
                            this.getRemoteObjectValue(this.din);
                            continue block30;
                        }
                        case 7: {
                            this.getField();
                            continue block30;
                        }
                        case 8: {
                            this.setField();
                            continue block30;
                        }
                        case 2: {
                            this.createObject(this.din);
                            continue block30;
                        }
                        case 3: {
                            this.fillHtSubs(this.din);
                            continue block30;
                        }
                        case 19: {
                            this.fillClassesHtSubs(this.din);
                            continue block30;
                        }
                        case 5: {
                            Object[] slots;
                            Object[] objectArray = slots = this.connector.readList(this.din);
                            int n = slots.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block30;
                                Object s = objectArray[n2];
                                this.heap.remove(s);
                                ++n2;
                            }
                        }
                        case 9: {
                            this.createArray(this.din);
                            continue block30;
                        }
                        case 10: {
                            this.getArrayElement(this.din);
                            continue block30;
                        }
                        case 11: {
                            this.setArrayElement(this.din);
                            continue block30;
                        }
                        case 4: {
                            Object ret = this.connector.readObject(this.din, true);
                            byte isGoodChain = this.din.readByte();
                            if (isGoodChain == 1) {
                                GoodChainData gcd2 = new GoodChainData(this.maybeGoodChain);
                                gcd2.breakpointsSubs = Debug.subsWithBreakpoints;
                                this.goodEvents.put(method, new GoodChainData(gcd2));
                            } else {
                                this.goodEvents.clear();
                            }
                            if (!nested) {
                                this.checkAndSendError();
                                this.connector.writeObject(this.dout, (byte)4);
                                this.dout.flush();
                                this.thresh.codeChainComplete();
                            }
                            Object object = ret;
                            return object;
                        }
                        case 16: {
                            this.setStateBeforeUserSub(this.din);
                            continue block30;
                        }
                        case 17: {
                            this.getStateAfterUserSub(this.din);
                            continue block30;
                        }
                        case 14: {
                            this.debugPause(this.din);
                            continue block30;
                        }
                        case 18: {
                            this.dontPrintErrors = true;
                            continue block30;
                        }
                        case 15: {
                            Common.StartMessageLoop((BA)BA.firstInstance);
                            this.raiseEventStack.addFirst(Boolean.TRUE);
                            continue block30;
                        }
                        case 20: {
                            this.fillBreakpoints(this.din);
                            continue block30;
                        }
                    }
                    throw new RuntimeException("Unexpected command: " + command);
                }
                catch (Exception e) {
                    this.setError(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.raiseEventStack.removeFirst();
        }
    }

    public void setError(Throwable t) {
        if (this.currentState == State.Error) {
            return;
        }
        if (t instanceof SocketException) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.currentState = State.Error;
        String errorLing = this.createErrorLine();
        this.currentException = new ShellConnector.DeviceException(t.toString(), RDebugUtils.currentLine, RDebugUtils.currentModule);
        if (!this.dontPrintErrors) {
            BA.LogError((String)errorLing);
            BA.printException((Throwable)t, (boolean)true);
        }
    }

    private String createErrorLine() {
        StringBuilder sb = new StringBuilder();
        sb.append("~de").append(RDebugUtils.currentLine);
        return sb.toString();
    }

    private void fillBreakpoints(DataInputStream din) throws Exception {
        Object[] bps = this.connector.readList(din);
        Debug.fillBreakpoints(bps);
    }

    private Object runGoodChain(GoodChainData data, Object[] args) {
        try {
            this.inGoodChain = true;
            Debug.subsWithBreakpoints = data.breakpointsSubs;
            Object ret = data.method.invoke(data.target, args);
            if (data.assigned != null) {
                this.getStateAfterUserSubHelper(data.assigned);
            }
            Object object = ret;
            return object;
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
        finally {
            this.inGoodChain = false;
        }
    }

    private void setStateBeforeUserSub(DataInputStream din) throws Exception {
        Object[] used = this.connector.readList(din);
        int i = 0;
        while (i < used.length) {
            String cls;
            Object target;
            Object o = used[i];
            if (o instanceof String) {
                target = null;
                cls = (String)o;
            } else {
                target = o;
                cls = o.getClass().getName();
            }
            Field f = this.fieldCache.getField(cls, (String)used[i + 1]);
            if (!f.getType().isAssignableFrom(used[i + 2].getClass()) && ObjectWrapper.class.isAssignableFrom(f.getType())) {
                System.out.println("classes do not match: " + f.getType());
                ObjectWrapper ow = (ObjectWrapper)f.getType().newInstance();
                f.set(target, ow);
                ow.setObject(((ObjectWrapper)used[i + 2]).getObject());
            } else {
                f.set(target, used[i + 2]);
            }
            i += 3;
        }
    }

    private void getStateAfterUserSub(DataInputStream din) throws Exception {
        this.maybeGoodChain.assigned = this.connector.readList(din);
        this.getStateAfterUserSubHelper(this.maybeGoodChain.assigned);
    }

    private void getStateAfterUserSubHelper(Object[] assigned) throws Exception {
        int i = 0;
        while (i < assigned.length) {
            String cls;
            Object target;
            Object o = assigned[i];
            if (o instanceof String) {
                target = null;
                cls = (String)o;
            } else {
                target = o;
                cls = o.getClass().getName();
            }
            Field f = this.fieldCache.getField(cls, (String)assigned[i + 1]);
            int slot = (Integer)assigned[i + 2];
            Object value = f.get(target);
            this.saveResult(slot, f.get(target), value != null ? value.getClass().getName() : f.getDeclaringClass().getName());
            i += 3;
        }
    }

    private void debugPause(DataInputStream din) throws Exception {
        BA ba = (BA)this.connector.readObject(din, true);
        this.currentState = State.Paused;
        Debug.alreadyPausedOnce = true;
        Debug.wait(ba, din.readInt(), (String)this.connector.readObject(din, true));
        this.currentState = State.Normal;
        this.dontPrintErrors = false;
    }

    private void getRemoteObjectValue(DataInputStream din) throws Exception {
        int slot = din.readInt();
        RemoteObject ro = this.heap.get(slot);
        if (this.checkAndSendError()) {
            return;
        }
        this.connector.writeObject(this.dout, ro == null ? null : ro.value);
        this.dout.flush();
    }

    private boolean checkAndSendError() throws Exception {
        if (this.currentState == State.Error) {
            this.connector.writeException(this.dout, this.currentException);
            this.currentState = State.Normal;
            this.dout.flush();
            return true;
        }
        return false;
    }

    private void createArray(DataInputStream din) throws Exception {
        String type = (String)this.connector.readObject(din, false);
        int rank = din.readByte();
        int[] lengths = new int[rank];
        int i = 0;
        while (i < rank) {
            lengths[i] = din.readInt();
            ++i;
        }
        int valuesLen = din.readInt();
        Object[] values = new Object[valuesLen];
        int i2 = 0;
        while (i2 < valuesLen) {
            values[i2] = this.connector.readObject(din, true);
            ++i2;
        }
        Object o = ArraysUtils.createArray(type, lengths, values);
        int key = din.readInt();
        this.heap.put(key, new RemoteObject(null, o));
    }

    private void getArrayElement(DataInputStream din) throws Exception {
        Object o;
        Object arr = this.connector.readObject(din, true);
        Object[] ranks = (Object[])this.connector.readObject(din, true);
        int slot = din.readInt();
        this.saveResult(slot, o, (o = ArraysUtils.getElement(arr, ranks)) != null ? o.getClass().getName() : null);
    }

    private void setArrayElement(DataInputStream din) throws Exception {
        Object arr = this.connector.readObject(din, true);
        Object[] ranks = (Object[])this.connector.readObject(din, true);
        Object value = this.connector.readObject(din, true);
        ArraysUtils.setElement(arr, value, ranks);
    }

    private void fillHtSubs(DataInputStream din) throws Exception {
        ShellBA ba = (ShellBA)((Object)this.connector.readObject(din, true));
        ba.fillSubs(this.connector.readList(din));
    }

    private void fillClassesHtSubs(DataInputStream din) throws Exception {
        int numberOfClasses = din.readInt();
        int i = 0;
        while (i < numberOfClasses) {
            String className = (String)this.connector.readObject(din, false);
            ShellBA.classesSubs.put(String.valueOf(BA.packageName) + "." + className, this.connector.readList(din));
            ++i;
        }
    }

    private void createObject(DataInputStream din) throws Exception {
        String className = (String)this.connector.readObject(din, false);
        Class<?> cls = Shell.getCorrectClassName(className);
        Object o = cls.newInstance();
        int key = din.readInt();
        this.heap.put(key, new RemoteObject(cls.getName(), o));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getCorrectClassName(String className) throws ClassNotFoundException {
        if (className.equals("Object")) {
            return Object.class;
        }
        if (className.equals("String")) {
            return String.class;
        }
        Class<?> cls = null;
        int i = 0;
        while (i < 3) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException c) {
                int dot = className.lastIndexOf(".");
                if (dot == -1) {
                    if (i != 0) throw c;
                    className = "java.lang." + className;
                } else {
                    className = String.valueOf(className.substring(0, dot)) + "$" + className.substring(dot + 1);
                }
                ++i;
            }
        }
        throw new ClassNotFoundException(className);
    }

    private Method getMethod(RemoteObject rt, String methodName, Object[] params) throws Exception {
        String className = rt.className;
        List<Method> mm = this.methodCache.getMethod(className, methodName, params);
        if (mm.size() == 1) {
            return mm.get(0);
        }
        for (Method m : mm) {
            Class<?>[] mTypes = m.getParameterTypes();
            if (params.length != mTypes.length) continue;
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    Class<?> p = params[i].getClass();
                    if (mTypes[i].isPrimitive()) {
                        mTypes[i] = ArraysUtils.primitiveToBoxed.get(mTypes[i]);
                    }
                    if (!mTypes[i].isAssignableFrom(p)) break;
                }
                ++i;
            }
            if (i != params.length) continue;
            return m;
        }
        throw new RuntimeException("Method: " + methodName + " not matched.");
    }

    private void setField() throws Exception {
        RemoteObject target = (RemoteObject)this.connector.readObject(this.din, false);
        Field f = this.fieldCache.getField(target.value != null ? target.value.getClass().getName() : target.className, (String)this.connector.readObject(this.din, false));
        Object o = this.connector.readObject(this.din, true);
        if (this.currentState != State.Error) {
            f.set(target.value, o);
        }
    }

    private void getField() throws Exception {
        Object o;
        RemoteObject target = (RemoteObject)this.connector.readObject(this.din, false);
        String fieldName = (String)this.connector.readObject(this.din, false);
        int slot = this.din.readInt();
        String cls = target.className;
        String fieldType = null;
        if (fieldName.equals("length") && target.value != null && target.value.getClass().isArray()) {
            o = Array.getLength(target.value);
        } else {
            cls = target.value == null ? Shell.getCorrectClassName(target.className).getName() : target.value.getClass().getName();
            Field f = this.fieldCache.getField(cls, fieldName);
            o = f.get(target.value);
            fieldType = f.getType().getName();
        }
        this.saveResult(slot, o, fieldType);
    }

    private void runMethod(boolean withSync) throws Throwable {
        block14: {
            Method m = null;
            try {
                Object roo;
                if (withSync) {
                    ++this.syncCounter;
                }
                RemoteObject target = (roo = this.connector.readObject(this.din, false)) instanceof String ? new RemoteObject("java.lang.String", roo) : (RemoteObject)roo;
                String methodName = (String)this.connector.readObject(this.din, false);
                Object[] params = this.connector.readList(this.din);
                int targetSlot = this.din.readInt();
                try {
                    Class<?> o;
                    if (this.currentState == State.Error) {
                        o = null;
                    } else if (target.value == null && target.className.equals("java.lang.Class") && methodName.equals("forName")) {
                        Class<?> cls;
                        o = cls = Shell.getCorrectClassName((String)params[0]);
                    } else {
                        Debug.disableDelegate = true;
                        m = this.getMethod(target, methodName, params);
                        o = m.invoke(target.value, params);
                        if (this.maybeGoodChain.method == null) {
                            this.maybeGoodChain.method = m;
                            this.maybeGoodChain.target = target.value;
                        }
                    }
                    this.saveResult(targetSlot, o, o == null ? null : o.getClass().getName());
                }
                catch (IllegalArgumentException ile) {
                    Common.Log((String)(String.valueOf(target.className) + ":" + methodName + ", " + Arrays.toString(params)));
                    throw ile;
                }
                catch (InvocationTargetException e) {
                    if (!BA.exitOnUnhandledExceptions && m != null && m.getDeclaringClass().getName().startsWith(BA.packageName)) {
                        BA.LogError((String)this.createErrorLine());
                        e.getCause().printStackTrace();
                        break block14;
                    }
                    throw e.getCause();
                }
            }
            finally {
                Debug.disableDelegate = false;
                if (withSync) {
                    this.dout.write(13);
                    this.dout.flush();
                    --this.syncCounter;
                }
            }
        }
    }

    private void saveResult(int slot, Object value, String clazz) {
        int resSlot = slot;
        this.heap.put(resSlot, new RemoteObject(clazz, value));
    }

    private void runVoidMethod() throws Throwable {
        RemoteObject target = (RemoteObject)this.connector.readObject(this.din, false);
        String methodName = (String)this.connector.readObject(this.din, false);
        Object[] params = this.connector.readList(this.din);
        if (this.currentState == State.Error) {
            return;
        }
        Method m = this.getMethod(target, methodName, params);
        try {
            m.invoke(target.value, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void createDesignerView(Object ... args) {
        try {
            this.dout.write(3);
            this.connector.writeList(this.dout, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollbackAfterMsgbox() {
        try {
            this.dout.write(4);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendLayoutViews(HashMap<String, Object> views, Object classTarget, String className) {
        try {
            if (classTarget != null) {
                for (Map.Entry<String, Object> view : views.entrySet()) {
                    try {
                        Field field = classTarget.getClass().getField("_" + view.getKey());
                        if (field == null) continue;
                        try {
                            ObjectWrapper ow = (ObjectWrapper)field.get(classTarget);
                            ow.setObject(((ObjectWrapper)view.getValue()).getObject());
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                            throw new RuntimeException("Field " + view.getKey() + " was declared with the wrong type.");
                        }
                    }
                    catch (NoSuchFieldException field) {
                        // empty catch block
                    }
                }
            } else {
                Object[] o = new Object[views.size() * 2];
                int i = 0;
                for (Map.Entry<String, Object> view : views.entrySet()) {
                    o[i++] = view.getKey();
                    o[i++] = view.getValue();
                }
                this.dout.write(2);
                this.connector.writeObject(this.dout, className);
                this.connector.writeList(this.dout, o);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void getDebuggerVariable(DataInputStream controlStream) {
        try {
            String name = (String)this.connector.readObject(controlStream, false);
            byte local = controlStream.readByte();
            Object target = this.connector.readObject(controlStream, true);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeByte(5);
            dout.writeInt(0);
            this.connector.writeObject(dout, name, true);
            dout.writeByte(local);
            Object unwrapped = null;
            if (target instanceof ObjectWrapper && (unwrapped = ((ObjectWrapper)target).getObjectOrNull()) == null) {
                target = "Not initialized.";
            }
            if (target == null) {
                target = "null";
            }
            if (target instanceof String) {
                dout.write(1);
                this.connector.writeObject(dout, "value", true);
                this.connector.writeObject(dout, target, true);
            } else {
                boolean shouldAddReflectedFields = true;
                if (target instanceof BA.B4aDebuggable) {
                    boolean[] b = new boolean[]{true};
                    Object[] oo = ((BA.B4aDebuggable)target).debug(100, b);
                    shouldAddReflectedFields = b[0];
                    int i = 0;
                    while (i < oo.length) {
                        dout.write(1);
                        this.connector.writeObject(dout, (String)oo[i], true);
                        this.connector.writeObject(dout, oo[i + 1], true);
                        i += 2;
                    }
                }
                if (shouldAddReflectedFields) {
                    Class<?> cls;
                    if (unwrapped != null) {
                        target = unwrapped;
                    }
                    if ((cls = target.getClass()).equals(ArraysUtils.SubArray.class) || cls.isArray()) {
                        ArraysUtils.writeArrayForDebugger(dout, target, this.connector);
                    } else {
                        boolean userClass = cls.getName().startsWith(BA.packageName);
                        while (!cls.equals(Object.class)) {
                            Field[] fields;
                            Field[] fieldArray = fields = cls.getDeclaredFields();
                            int n = fields.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Field f = fieldArray[n2];
                                if (!Modifier.isStatic(f.getModifiers())) {
                                    String fname = f.getName();
                                    f.setAccessible(true);
                                    if (!userClass || fname.charAt(0) != '_' || (fname = fname.substring(1)).charAt(0) != '_') {
                                        dout.write(1);
                                        this.connector.writeObject(dout, fname, true);
                                        this.connector.writeObject(dout, f.get(target), true);
                                    }
                                }
                                ++n2;
                            }
                            if (userClass) break;
                            cls = cls.getSuperclass();
                        }
                    }
                }
            }
            dout.write(0);
            byte[] buffer = bout.toByteArray();
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            bb.putInt(1, buffer.length - 5);
            this.connector.sendControlMessage(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class EventsThreshold {
        private long lastEventComplete;
        private int eventsInARow;
        private String lastEvent;
        private int goodIntervalAfterLastEvent = 10;

        EventsThreshold() {
        }

        public boolean codeChainStart(String event) {
            long now = System.currentTimeMillis();
            if (now - this.lastEventComplete > (long)this.goodIntervalAfterLastEvent) {
                this.eventsInARow = 0;
                this.lastEvent = null;
                this.goodIntervalAfterLastEvent = 10;
            } else {
                ++this.eventsInARow;
                if (this.eventsInARow > 25 && event.equals(this.lastEvent)) {
                    this.goodIntervalAfterLastEvent = 50;
                    return true;
                }
                this.lastEvent = event;
            }
            return false;
        }

        public void codeChainComplete() {
            this.lastEventComplete = System.currentTimeMillis();
        }
    }

    static class FieldCache {
        private HashMap<String, HashMap<String, Field>> cache = new HashMap();

        FieldCache() {
        }

        public Field getField(String className, String fieldName) throws Exception {
            Field m;
            HashMap<String, Field> classFields = this.cache.get(className);
            if (classFields == null) {
                classFields = new HashMap();
                this.cache.put(className, classFields);
                Field[] fieldArray = Class.forName(className).getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    m = fieldArray[n2];
                    classFields.put(m.getName(), m);
                    ++n2;
                }
            }
            if ((m = classFields.get(fieldName)) == null) {
                throw new RuntimeException("Field: " + fieldName + " not found in: " + className);
            }
            return m;
        }
    }

    public static class GoodChainData {
        public Object[] assigned;
        public long time;
        public Method method;
        public Object target;
        public Object pseudoTarget;
        public HashSet<String> breakpointsSubs;

        public GoodChainData() {
        }

        public GoodChainData(GoodChainData copy) {
            this.assigned = copy.assigned;
            this.method = copy.method;
            this.target = copy.target;
            this.pseudoTarget = copy.pseudoTarget;
            this.time = System.currentTimeMillis();
            this.breakpointsSubs = copy.breakpointsSubs;
        }
    }

    static class MethodCache {
        private HashMap<String, HashMap<String, ArrayList<Method>>> cache = new HashMap();
        private static final HashMap<String, ArrayList<Method>> cantGetAllMethods = new HashMap();

        MethodCache() {
        }

        public List<Method> getMethod(String className, String methodName, Object[] params) throws Exception {
            ArrayList<Method> m;
            HashMap<String, ArrayList<Method>> classMethods = this.cache.get(className);
            if (classMethods == null) {
                classMethods = new HashMap();
                this.cache.put(className, classMethods);
                Method[] methods = null;
                try {
                    methods = Class.forName(className).getMethods();
                }
                catch (Throwable e) {
                    BA.LogError((String)("Cannot get methods of class: " + className + ", disabling cache."));
                    this.cache.put(className, cantGetAllMethods);
                    classMethods = cantGetAllMethods;
                }
                if (methods != null) {
                    Method[] methodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m2 = methodArray[n2];
                        ArrayList<Method> overloaded = classMethods.get(m2.getName());
                        if (overloaded == null) {
                            overloaded = new ArrayList();
                            classMethods.put(m2.getName(), overloaded);
                        }
                        overloaded.add(m2);
                        ++n2;
                    }
                }
            }
            if (classMethods == cantGetAllMethods) {
                Class<?> cls = Class.forName(className);
                Class[] paramTypes = new Class[params.length];
                int i = 0;
                while (i < params.length) {
                    paramTypes[i] = params[i] == null ? Object.class : params[i].getClass();
                    ++i;
                }
                i = 0;
                while (i < params.length) {
                    try {
                        return Arrays.asList(cls.getMethod(methodName, paramTypes));
                    }
                    catch (NoSuchMethodException nsme) {
                        Class orig = paramTypes[i];
                        Class parent = paramTypes[i].getSuperclass();
                        if (parent != null) {
                            paramTypes[i] = parent;
                            try {
                                return Arrays.asList(cls.getMethod(methodName, paramTypes));
                            }
                            catch (NoSuchMethodException nsme2) {
                                paramTypes[i] = orig;
                            }
                        }
                        ++i;
                    }
                }
            }
            if ((m = classMethods.get(methodName)) == null) {
                throw new RuntimeException("Method: " + methodName + " not found in: " + className);
            }
            return m;
        }
    }

    static class RemoteObject {
        public final String className;
        public final Object value;

        public RemoteObject(String className, Object value) {
            this.className = className;
            this.value = value;
        }

        public String toString() {
            return "RemoteObject: " + this.className;
        }
    }

    private static enum State {
        Normal,
        Paused,
        Error;

    }
}

