/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.shell;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;

public class ShellConnector
implements Runnable {
    public static final byte T_NULL = 0;
    public static final byte T_STRING = 1;
    public static final byte T_SHORT = 2;
    public static final byte T_INT = 3;
    public static final byte T_LONG = 4;
    public static final byte T_FLOAT = 5;
    public static final byte T_DOUBLE = 6;
    public static final byte T_BOOLEAN = 7;
    public static final byte T_HEAP_OBJECT = 8;
    public static final byte T_BYTE = 10;
    public static final byte T_CACHED_STRING_ADD = 11;
    public static final byte T_CACHED_STRING = 12;
    public static final byte T_ARRAY_OF_OBJECTS = 13;
    public static final byte T_CHAR = 14;
    public static final byte T_EXCEPTION = 15;
    public volatile boolean working = true;
    public static final int PING = 1;
    private final ShellHandler handler;
    private final int port;
    private final String IP;
    public static final int CONTROL = 0;
    public static final int MAIN = 1;
    private ServerSocket[] servers = new ServerSocket[2];
    private Socket[] sockets = new Socket[2];
    private static final int ALTERNATE_PORT_DELTA = 117;
    private InputStream[] ins = new InputStream[2];
    private OutputStream[] outs = new OutputStream[2];
    public int timeoutToConnect = 5000;
    private final boolean isServer;
    public boolean connectedOnce = false;
    private final HashMap<String, Short> stringsCacheMap = new HashMap();
    private final String[] stringsCache = new String[Short.MAX_VALUE];
    private static final int maxLengthForStringsCache = 200;

    public ShellConnector(ShellHandler handler, int port, String IP) {
        this.handler = handler;
        this.port = port;
        this.IP = IP;
        this.isServer = IP == null;
    }

    public synchronized void sendControlMessage(byte[] message) throws IOException {
        this.outs[0].write(message);
        this.outs[0].flush();
    }

    public InputStream getMainInputStream() {
        return this.ins[1];
    }

    public OutputStream getMainOutputStream() {
        return this.outs[1];
    }

    public synchronized void stop() {
        this.working = false;
        this.close();
        this.servers = null;
        this.sockets = null;
    }

    private synchronized void close() {
        try {
            int n;
            int n2;
            Closeable[] closeableArray;
            if (this.servers != null) {
                closeableArray = this.servers;
                n2 = this.servers.length;
                n = 0;
                while (n < n2) {
                    Closeable server = closeableArray[n];
                    if (server != null) {
                        ((ServerSocket)server).close();
                    }
                    ++n;
                }
            }
            if (this.sockets != null) {
                closeableArray = this.sockets;
                n2 = this.sockets.length;
                n = 0;
                while (n < n2) {
                    Closeable socket = closeableArray[n];
                    if (socket != null) {
                        ((Socket)socket).close();
                    }
                    ++n;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        Thread pinger = new Thread(new Runnable(){

            @Override
            public void run() {
                while (ShellConnector.this.working) {
                    try {
                        if (ShellConnector.this.outs[0] != null) {
                            ShellConnector.this.sendControlMessage(new byte[]{1});
                        }
                        Thread.sleep(30L);
                    }
                    catch (Exception e) {
                        ShellConnector.this.sleep(1000);
                        e.printStackTrace();
                    }
                }
            }
        });
        pinger.setDaemon(true);
        if (!this.isServer) {
            pinger.start();
        }
        long start = System.currentTimeMillis();
        while (true) {
            try {
                try {
                    this.connect();
                }
                catch (Exception ste) {
                    if (!this.isServer) {
                        ste.printStackTrace();
                    }
                    if (this.isServer || System.currentTimeMillis() - start > (long)this.timeoutToConnect || this.connectedOnce) {
                        this.stop();
                        break;
                    }
                    this.close();
                    this.sleep(700);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (this.isServer || System.currentTimeMillis() - start > (long)this.timeoutToConnect || this.connectedOnce) {
                    this.stop();
                    break;
                }
                this.close();
                this.sleep(700);
                throw throwable;
            }
            if (this.isServer || System.currentTimeMillis() - start > (long)this.timeoutToConnect || this.connectedOnce) {
                this.stop();
                break;
            }
            this.close();
            this.sleep(700);
        }
        this.handler.connectionStatus(false);
    }

    private void connect() throws IOException, InterruptedException {
        int i;
        if (this.isServer) {
            i = 0;
            while (i < 2) {
                InetAddress ia = InetAddress.getLoopbackAddress();
                if (System.getProperty("bridge", "false").equals("true")) {
                    ia = null;
                }
                try {
                    this.servers[i] = new ServerSocket(this.port + i, 1, ia);
                }
                catch (BindException be) {
                    System.out.println("shell switching to alternate port: " + (this.port + i + 117));
                    this.servers[i] = new ServerSocket(this.port + i + 117, 1, ia);
                }
                ++i;
            }
            i = 0;
            while (i < 2) {
                this.servers[i].setSoTimeout(10000);
                this.sockets[i] = this.servers[i].accept();
                ++i;
            }
        } else {
            i = 0;
            while (i < 2) {
                try {
                    this.sockets[i] = new Socket();
                    this.sockets[i].connect(new InetSocketAddress(this.IP, this.port + i), 10000);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.sockets[i] = new Socket();
                        this.sockets[i].connect(new InetSocketAddress(this.IP, this.port + i + 117), 10000);
                    }
                    catch (IOException io) {
                        this.sockets[i] = null;
                        throw new RuntimeException("Error connecting to device.");
                    }
                }
                ++i;
            }
        }
        this.sockets[0].setSoTimeout(10000);
        i = 0;
        while (i < 2) {
            this.sockets[i].setTcpNoDelay(true);
            this.outs[i] = new BufferedOutputStream(this.sockets[i].getOutputStream());
            this.ins[i] = new BufferedInputStream(this.sockets[i].getInputStream());
            ++i;
        }
        if (this.isServer) {
            this.sendControlMessage(new byte[]{1});
            this.handler.connectionStatus(true);
        }
        this.readControlData(this.ins[0]);
    }

    private void readControlData(InputStream in) throws IOException, InterruptedException {
        while (this.working) {
            int b = in.read();
            if (b == 1) {
                if (this.isServer) {
                    this.sendControlMessage(new byte[]{1});
                } else if (!this.connectedOnce) {
                    this.connectedOnce = true;
                    this.handler.connectionStatus(true);
                }
            }
            if (b == -1) {
                System.out.println("-1 received (controller)");
                break;
            }
            if (b <= 1) continue;
            this.handler.handleIncomingData(b, in);
        }
    }

    void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public Object[] readList(DataInputStream din) throws Exception {
        int size = din.readInt();
        Object[] l = new Object[size];
        int i = 0;
        while (i < size) {
            l[i] = this.readObject(din, true);
            ++i;
        }
        return l;
    }

    public void writeList(DataOutputStream dout, Object ... args) throws Exception {
        if (args == null) {
            args = new Object[]{};
        }
        dout.writeInt(args.length);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.writeObject(dout, o);
            ++n2;
        }
    }

    public void writeList2(DataOutputStream dout, ArrayList<Object> list) throws Exception {
        dout.writeInt(list.size());
        for (Object o : list) {
            this.writeObject(dout, o);
        }
    }

    public Object readObject(DataInputStream din, boolean unwrapRemoteObject) throws Exception {
        byte t = din.readByte();
        if (t == 0) {
            return null;
        }
        if (t == 8) {
            return this.handler.readRemoteObject(din, unwrapRemoteObject, false);
        }
        if (t == 2) {
            return din.readShort();
        }
        if (t == 3) {
            return din.readInt();
        }
        if (t == 4) {
            return din.readLong();
        }
        if (t == 5) {
            return Float.valueOf(din.readFloat());
        }
        if (t == 6) {
            return din.readDouble();
        }
        if (t == 7) {
            if (din.readByte() == 1) {
                return true;
            }
            return false;
        }
        if (t == 10) {
            return din.readByte();
        }
        if (t == 12) {
            short s = din.readShort();
            return this.stringsCache[s];
        }
        if (t == 11) {
            short len = din.readShort();
            byte[] buffer = new byte[len];
            din.readFully(buffer);
            String s = new String(buffer, "UTF8");
            short pos = (short)this.stringsCacheMap.size();
            this.stringsCacheMap.put(s, pos);
            this.stringsCache[pos] = s;
            return s;
        }
        if (t == 14) {
            return Character.valueOf(din.readChar());
        }
        if (t == 1) {
            int len = din.readInt();
            byte[] buffer = new byte[len];
            din.readFully(buffer);
            return new String(buffer, "UTF8");
        }
        if (t == 13) {
            return this.handler.readRemoteObject(din, unwrapRemoteObject, true);
        }
        if (t == 15) {
            throw new DeviceException((String)this.readObject(din, false), din.readInt(), (String)this.readObject(din, false));
        }
        throw new RuntimeException("Unknown type in readObject: " + t);
    }

    public void writeException(DataOutputStream dout, DeviceException de) throws Exception {
        dout.writeByte(15);
        this.writeObject(dout, de.getMessage());
        dout.writeInt(de.line);
        this.writeObject(dout, de.module);
    }

    public void writeObject(DataOutputStream dout, Object o) throws Exception {
        this.writeObject(dout, o, false);
    }

    public void writeObject(DataOutputStream dout, Object o, boolean stringsCacheDisabled) throws Exception {
        if (o == null) {
            dout.write(0);
        } else if (o instanceof Integer) {
            dout.write(3);
            dout.writeInt((Integer)o);
        } else if (o instanceof Long) {
            dout.write(4);
            dout.writeLong((Long)o);
        } else if (o instanceof Boolean) {
            dout.write(7);
            dout.write(o.equals(true) ? 1 : 0);
        } else if (o instanceof String) {
            Short s = null;
            if (!stringsCacheDisabled && ((String)o).length() < 200) {
                s = this.stringsCacheMap.get((String)o);
            }
            if (s != null) {
                dout.write(12);
                dout.writeShort(s.shortValue());
            } else {
                byte[] buffer = o.toString().getBytes("UTF8");
                if (!stringsCacheDisabled && this.stringsCacheMap.size() < Short.MAX_VALUE && ((String)o).length() < 200) {
                    short pos = (short)this.stringsCacheMap.size();
                    this.stringsCacheMap.put((String)o, pos);
                    this.stringsCache[pos] = (String)o;
                    dout.writeByte(11);
                    dout.writeShort(buffer.length);
                    dout.write(buffer);
                } else {
                    dout.write(1);
                    dout.writeInt(buffer.length);
                    dout.write(buffer);
                }
            }
        } else if (o instanceof Short) {
            dout.write(2);
            dout.writeShort(((Short)o).shortValue());
        } else if (o instanceof Float) {
            dout.write(5);
            dout.writeFloat(((Float)o).floatValue());
        } else if (o instanceof Double) {
            dout.write(6);
            dout.writeDouble((Double)o);
        } else if (o instanceof Byte) {
            dout.write(10);
            dout.writeByte(((Byte)o).byteValue());
        } else if (o instanceof Character) {
            dout.write(14);
            dout.writeChar(((Character)o).charValue());
        } else {
            this.handler.writeRemoteObject(dout, o, stringsCacheDisabled);
        }
    }

    public static class DeviceException
    extends Exception {
        public final int line;
        public final String module;

        public DeviceException(String msg, int line, String module) {
            super(msg);
            this.line = line;
            this.module = module;
        }
    }

    public static class PrintingOutputStream
    extends FilterOutputStream {
        public PrintingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            System.out.println(b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            StringBuilder sb = new StringBuilder();
            int i = off;
            while (i < off + len) {
                sb.append(b[i]).append(",");
                ++i;
            }
            System.out.println(sb.toString());
            this.out.write(b, off, len);
        }
    }

    public static interface ShellHandler {
        public void connectionStatus(boolean var1);

        public void handleIncomingData(int var1, InputStream var2) throws IOException;

        public void writeRemoteObject(DataOutputStream var1, Object var2, boolean var3) throws Exception;

        public Object readRemoteObject(DataInputStream var1, boolean var2, boolean var3) throws Exception;
    }
}

