/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

@BA.ShortName(value="Socket")
@BA.Version(value=1.11f)
public class SocketWrapper
implements BA.CheckForReinitialize {
    @BA.Hide
    public volatile Socket socket;
    private String eventName;

    public void Initialize(String EventName) {
        this.socket = new Socket();
        this.eventName = EventName.toLowerCase(BA.cul);
    }

    public void InitializeSSL(String EventName, InputStream KeyStoreStream, String Password) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(KeyStoreStream, Password.toCharArray());
        char[] password = null;
        if (Password.length() > 0) {
            password = Password.toCharArray();
        }
        kmf.init(ks, password);
        context.init(kmf.getKeyManagers(), null, null);
        if (KeyStoreStream != null) {
            KeyStoreStream.close();
        }
        this.eventName = EventName.toLowerCase(BA.cul);
        this.socket = context.getSocketFactory().createSocket();
    }

    public static void LIBRARY_DOC() {
    }

    public boolean IsInitialized() {
        return this.socket != null;
    }

    public String ResolveHost(String Host) throws UnknownHostException {
        return InetAddress.getByName(Host).getHostAddress();
    }

    public String getRemoteAddress() {
        InetAddress ia = this.socket.getInetAddress();
        return ia == null ? "" : ia.getHostAddress();
    }

    public int getTimeOut() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void setTimeOut(int value) throws SocketException {
        this.socket.setSoTimeout(value);
    }

    public void Connect(final BA ba, final String Host, final int Port, final int TimeOut) throws UnknownHostException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block4: {
                    Socket mySocket = SocketWrapper.this.socket;
                    try {
                        InetAddress Address = InetAddress.getByName(Host);
                        InetSocketAddress i = new InetSocketAddress(Address, Port);
                        if (mySocket != SocketWrapper.this.socket) {
                            return;
                        }
                        SocketWrapper.this.socket.connect(i, TimeOut);
                        if (SocketWrapper.this.socket instanceof SSLSocket) {
                            ((SSLSocket)SocketWrapper.this.socket).startHandshake();
                        }
                        ba.raiseEventFromDifferentThread((Object)SocketWrapper.this, (Object)SocketWrapper.this, 0, String.valueOf(SocketWrapper.this.eventName) + "_connected", true, new Object[]{true});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (mySocket != SocketWrapper.this.socket) break block4;
                        ba.setLastException(e);
                        ba.raiseEventFromDifferentThread((Object)SocketWrapper.this, (Object)SocketWrapper.this, 0, String.valueOf(SocketWrapper.this.eventName) + "_connected", true, new Object[]{false});
                    }
                }
            }
        };
        BA.submitRunnable((Runnable)r, (Object)this, (int)0);
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public boolean getConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public void Close() throws IOException {
        if (this.socket != null) {
            Socket s = this.socket;
            this.socket = null;
            try {
                if (s != null) {
                    if (!s.isInputShutdown() && !s.isClosed()) {
                        s.shutdownInput();
                    }
                    if (!s.isOutputShutdown() && !s.isClosed()) {
                        s.shutdownOutput();
                    }
                    if (!s.isClosed()) {
                        s.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @BA.ShortName(value="ServerSocket")
    public static class ServerSocketWrapper
    implements BA.CheckForReinitialize {
        @BA.Hide
        public volatile ServerSocket ssocket;
        private BA ba;
        private String eventName;

        public void Initialize(BA ba, int Port, String EventName) throws IOException {
            this.ba = ba;
            this.eventName = EventName.toLowerCase(BA.cul);
            this.ssocket = new ServerSocket(Port);
        }

        public boolean IsInitialized() {
            return this.ssocket != null;
        }

        public String GetMyIP() throws SocketException {
            String lh = "127.0.0.1";
            Inet6Address ip6 = null;
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    NetworkInterface ni = en.nextElement();
                    Enumeration<InetAddress> en2 = ni.getInetAddresses();
                    while (en2.hasMoreElements()) {
                        InetAddress ia = en2.nextElement();
                        if (ia.isLoopbackAddress()) continue;
                        if (ia instanceof Inet6Address) {
                            if (ip6 != null) continue;
                            ip6 = (Inet6Address)ia;
                            continue;
                        }
                        return ia.getHostAddress();
                    }
                }
            }
            if (ip6 != null) {
                return ip6.getHostAddress();
            }
            return lh;
        }

        public void Listen() throws IOException {
            if (BA.isTaskRunning((Object)this, (int)0)) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            Socket s = ServerSocketWrapper.this.ssocket.accept();
                            SocketWrapper sw = new SocketWrapper();
                            sw.socket = s;
                            ServerSocketWrapper.this.ba.raiseEventFromDifferentThread((Object)ServerSocketWrapper.this, (Object)ServerSocketWrapper.this, 0, String.valueOf(ServerSocketWrapper.this.eventName) + "_newconnection", true, new Object[]{true, sw});
                        }
                        catch (IOException e) {
                            if (ServerSocketWrapper.this.ssocket == null) break block2;
                            ServerSocketWrapper.this.ba.setLastException((Exception)e);
                            Object[] objectArray = new Object[2];
                            objectArray[0] = false;
                            ServerSocketWrapper.this.ba.raiseEventFromDifferentThread((Object)ServerSocketWrapper.this, (Object)ServerSocketWrapper.this, 0, String.valueOf(ServerSocketWrapper.this.eventName) + "_newconnection", true, objectArray);
                        }
                    }
                }
            };
            BA.submitRunnable((Runnable)r, (Object)this, (int)0);
        }

        public void Close() throws IOException {
            if (this.ssocket != null) {
                ServerSocket sss = this.ssocket;
                this.ssocket = null;
                sss.close();
            }
        }
    }

    @BA.ShortName(value="UDPSocket")
    public static class UDPSocket
    implements BA.CheckForReinitialize {
        private UDPReader reader;
        private DatagramSocket ds;

        public void Initialize(BA ba, String EventName, int Port, int ReceiveBufferSize) throws SocketException {
            this.Close();
            this.ds = Port == 0 ? new DatagramSocket() : new DatagramSocket(Port);
            if (ReceiveBufferSize > 0) {
                this.reader = new UDPReader();
                this.reader.working = true;
                this.reader.socket = this.ds;
                this.reader.receiveLength = ReceiveBufferSize;
                this.reader.ba = ba;
                this.reader.eventName = EventName.toLowerCase(BA.cul);
                Thread t = new Thread(this.reader);
                t.setDaemon(true);
                t.start();
            }
        }

        public boolean IsInitialized() {
            return this.ds != null && !this.ds.isClosed();
        }

        public int getPort() {
            return this.ds.getLocalPort();
        }

        public void Send(final UDPPacket Packet) throws IOException {
            BA.submitRunnable((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        ((MyDatagramPacket)Packet.getObject()).packet.setSocketAddress(new InetSocketAddress(((MyDatagramPacket)Packet.getObject()).host, ((MyDatagramPacket)Packet.getObject()).port));
                        UDPSocket.this.ds.send(((MyDatagramPacket)Packet.getObject()).packet);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Object)this, (int)1);
        }

        public void Close() {
            if (this.reader != null) {
                this.reader.working = false;
            }
            if (this.ds != null) {
                this.ds.close();
            }
            this.reader = null;
            this.ds = null;
        }

        public String toString() {
            if (this.ds == null) {
                return "Not initialized";
            }
            return "Port=" + this.getPort();
        }

        @BA.Hide
        public static class MyDatagramPacket {
            public final String host;
            public final int port;
            public final DatagramPacket packet;

            public MyDatagramPacket(String host, int port, DatagramPacket packet) {
                this.host = host;
                this.port = port;
                this.packet = packet;
            }
        }

        @BA.ShortName(value="UDPPacket")
        public static class UDPPacket
        extends AbsObjectWrapper<MyDatagramPacket> {
            public void Initialize(byte[] Data, String Host, int Port) throws SocketException {
                this.Initialize2(Data, 0, Data.length, Host, Port);
            }

            public void Initialize2(byte[] Data, int Offset, int Length, String Host, int Port) throws SocketException {
                DatagramPacket d = new DatagramPacket(Data, Offset, Length);
                MyDatagramPacket m = new MyDatagramPacket(Host, Port, d);
                this.setObject(m);
            }

            public int getLength() {
                return ((MyDatagramPacket)this.getObject()).packet.getLength();
            }

            public byte[] getData() {
                return ((MyDatagramPacket)this.getObject()).packet.getData();
            }

            public int getOffset() {
                return ((MyDatagramPacket)this.getObject()).packet.getOffset();
            }

            public int getPort() {
                return ((MyDatagramPacket)this.getObject()).packet.getPort();
            }

            public String getHost() {
                return ((MyDatagramPacket)this.getObject()).packet.getAddress().getHostName();
            }

            public String getHostAddress() {
                return ((MyDatagramPacket)this.getObject()).packet.getAddress().getHostAddress();
            }

            public String toString() {
                if (this.getObjectOrNull() == null) {
                    return super.toString();
                }
                return "Length=" + this.getLength() + ", Offset=" + this.getOffset() + ", Host=" + this.getHost() + ", Port=" + this.getPort();
            }
        }

        private static class UDPReader
        implements Runnable {
            volatile boolean working;
            DatagramSocket socket;
            int receiveLength;
            BA ba;
            String eventName;

            private UDPReader() {
            }

            @Override
            public void run() {
                while (this.working) {
                    try {
                        DatagramPacket p = new DatagramPacket(new byte[this.receiveLength], this.receiveLength);
                        this.socket.receive(p);
                        UDPPacket u = new UDPPacket();
                        u.setObject(new MyDatagramPacket("", 0, p));
                        this.ba.raiseEventFromDifferentThread(null, null, 0, String.valueOf(this.eventName) + "_packetarrived", false, new Object[]{u});
                    }
                    catch (IOException e) {
                        if (!this.working) continue;
                        try {
                            e.printStackTrace();
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

