/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TableRowBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRowSkin
extends CellSkinBase<TableRow<ObservableList<SpreadsheetCell>>, CellBehaviorBase<TableRow<ObservableList<SpreadsheetCell>>>> {
    private final SpreadsheetHandle handle;
    private final SpreadsheetView spreadsheetView;
    private Reference<HashMap<TableColumnBase, CellView>> cellsMap;
    private final List<CellView> cells = new ArrayList<CellView>();

    public GridRowSkin(SpreadsheetHandle handle, TableRow<ObservableList<SpreadsheetCell>> gridRow) {
        super(gridRow, (BehaviorBase)new TableRowBehavior(gridRow));
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        ((TableRow)this.getSkinnable()).setPickOnBounds(false);
        this.registerChangeListener((ObservableValue)gridRow.itemProperty(), "ITEM");
        this.registerChangeListener((ObservableValue)gridRow.indexProperty(), "INDEX");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("INDEX".equals(p)) {
            if (((TableRow)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        } else if ("ITEM".equals(p)) {
            this.requestCellUpdate();
        } else if ("FIXED_CELL_SIZE".equals(p)) {
            // empty if block
        }
    }

    private void requestCellUpdate() {
        ((TableRow)this.getSkinnable()).requestLayout();
        int newIndex = ((TableRow)this.getSkinnable()).getIndex();
        this.getChildren().clear();
        int max = this.cells.size();
        for (int i = 0; i < max; ++i) {
            this.cells.get(i).updateIndex(newIndex);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        ObservableList visibleLeafColumns = this.handle.getGridView().getVisibleLeafColumns();
        if (visibleLeafColumns.isEmpty()) {
            super.layoutChildren(x, y, w, h);
            return;
        }
        GridRow control = (GridRow)this.getSkinnable();
        SpreadsheetGridView gridView = this.handle.getGridView();
        Grid grid = this.spreadsheetView.getGrid();
        int index = control.getIndex();
        if (index < 0 || index >= gridView.getItems().size()) {
            this.getChildren().clear();
            this.putCellsInCache();
            return;
        }
        List row = (List)grid.getRows().get(index);
        ObservableList<SpreadsheetColumn> columns = this.spreadsheetView.getColumns();
        ObservableList tableViewColumns = gridView.getColumns();
        if (columns.size() != tableViewColumns.size()) {
            return;
        }
        ((TableRow)this.getSkinnable()).setVisible(true);
        double verticalPadding = this.snappedTopInset() + this.snappedBottomInset();
        double horizontalPadding = this.snappedLeftInset() + this.snappedRightInset();
        double controlHeight = this.getTableRowHeight(index);
        double customHeight = controlHeight == -1.0 ? GridViewSkin.DEFAULT_CELL_HEIGHT : controlHeight;
        GridViewSkin skin = this.handle.getCellsViewSkin();
        skin.hBarValue.set(index, true);
        double headerWidth = gridView.getWidth();
        double hbarValue = skin.getHBar().getValue();
        ((GridRow)this.getSkinnable()).verticalShift.setValue((Number)this.getFixedRowShift(index));
        double fixedColumnWidth = 0.0;
        ArrayList<CellView> fixedCells = new ArrayList<CellView>();
        this.putCellsInCache();
        boolean firstVisibleCell = false;
        block6: for (int indexColumn = 0; indexColumn < columns.size(); ++indexColumn) {
            SpreadsheetCell spreadsheetCell;
            boolean isVisible;
            double width = this.snapSize(((SpreadsheetColumn)columns.get(indexColumn)).getWidth()) - this.snapSize(horizontalPadding);
            boolean bl = isVisible = !this.isInvisible(x, width, hbarValue, headerWidth, (spreadsheetCell = (SpreadsheetCell)row.get(indexColumn)).getColumnSpan());
            if (((SpreadsheetColumn)columns.get(indexColumn)).isFixed()) {
                isVisible = true;
            }
            if (!isVisible) {
                if (firstVisibleCell) break;
                x += width;
                continue;
            }
            CellView tableCell = this.getCell((TableColumnBase)gridView.getColumns().get(indexColumn));
            this.cells.add(0, tableCell);
            tableCell.setManaged(true);
            double tableCellX = 0.0;
            boolean increaseFixedWidth = false;
            if (((SpreadsheetColumn)columns.get(indexColumn)).isFixed() && hbarValue + fixedColumnWidth > x && spreadsheetCell.getColumn() == indexColumn) {
                increaseFixedWidth = true;
                tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                fixedColumnWidth += width;
                fixedCells.add(tableCell);
            }
            if (isVisible) {
                SpreadsheetView.SpanType spanType = grid.getSpanType(this.spreadsheetView, index, indexColumn);
                switch (spanType) {
                    case ROW_SPAN_INVISIBLE: 
                    case BOTH_INVISIBLE: {
                        fixedCells.remove((Object)tableCell);
                        this.getChildren().remove((Object)tableCell);
                        x += width;
                        continue block6;
                    }
                    case COLUMN_SPAN_INVISIBLE: {
                        fixedCells.remove((Object)tableCell);
                        this.getChildren().remove((Object)tableCell);
                        continue block6;
                    }
                    case ROW_VISIBLE: {
                        TableViewSpanSelectionModel sm = (TableViewSpanSelectionModel)this.handle.getGridView().getSelectionModel();
                        TableColumn col = (TableColumn)tableViewColumns.get(indexColumn);
                        TablePosition<ObservableList<SpreadsheetCell>, ?> selectedPosition = sm.isSelectedRange(index, col, indexColumn);
                        if (selectedPosition != null && skin.containsRow(index) && selectedPosition.getRow() != index) {
                            sm.clearSelection(selectedPosition.getRow(), selectedPosition.getTableColumn());
                            sm.select(index, col);
                        }
                    }
                    case NORMAL_CELL: {
                        if (tableCell.getIndex() != index) {
                            tableCell.updateIndex(index);
                        } else {
                            tableCell.updateItem(spreadsheetCell, false);
                        }
                        if (tableCell.getParent() == null) {
                            this.getChildren().add(0, (Object)tableCell);
                        }
                    }
                    default: {
                        double tempHeight;
                        if (spreadsheetCell.getColumnSpan() > 1) {
                            int colSpan = spreadsheetCell.getColumnSpan();
                            int max1 = columns.size() - indexColumn;
                            for (int i = 1; i < colSpan && i < max1; ++i) {
                                double tempWidth = this.snapSize(((SpreadsheetColumn)columns.get(indexColumn + i)).getWidth());
                                width += tempWidth;
                                if (!increaseFixedWidth) continue;
                                fixedColumnWidth += tempWidth;
                            }
                        }
                        if (controlHeight == -1.0 && !tableCell.isEditing() && (tempHeight = tableCell.prefHeight(width)) > customHeight) {
                            skin.rowHeightMap.put((Object)index, (Object)tempHeight);
                            for (CellView cell : this.cells) {
                                cell.resize(cell.getWidth(), tempHeight);
                            }
                            customHeight = tempHeight;
                            skin.getFlow().layoutChildren();
                        }
                        double height = customHeight;
                        height = this.snapSize(height) - this.snapSize(verticalPadding);
                        if (spreadsheetCell.getRowSpan() > 1) {
                            height = 0.0;
                            int maxRow = spreadsheetCell.getRow() + spreadsheetCell.getRowSpan();
                            for (int i = spreadsheetCell.getRow(); i < maxRow; ++i) {
                                height += this.snapSize(skin.getRowHeight(i));
                            }
                        }
                        tableCell.resize(width, height);
                        double spaceBetweenTopAndMe = 0.0;
                        for (int p = spreadsheetCell.getRow(); p < index; ++p) {
                            spaceBetweenTopAndMe += skin.getRowHeight(p);
                        }
                        tableCell.relocate(x + tableCellX, this.snappedTopInset() - spaceBetweenTopAndMe + ((GridRow)this.getSkinnable()).verticalShift.get());
                        break;
                    }
                }
            } else {
                this.getChildren().remove((Object)tableCell);
            }
            x += width;
        }
        skin.fixedColumnWidth = fixedColumnWidth;
        this.handleFixedCell(fixedCells, index);
        this.removeUselessCell();
        if (this.handle.getCellsViewSkin().lastRowLayout.get()) {
            this.handle.getCellsViewSkin().lastRowLayout.setValue(Boolean.valueOf(false));
        }
    }

    private void removeUselessCell() {
        Collection<CellView> tempCells = this.getCellsMap().values();
        this.getChildren().removeAll(tempCells);
    }

    private void handleFixedCell(List<CellView> fixedCells, int index) {
        block5: {
            block4: {
                if (!this.handle.getCellsViewSkin().rowToLayout.get(index)) break block4;
                GridRow gridRow = this.handle.getCellsViewSkin().getFlow().getTopRow();
                if (gridRow == null) break block5;
                for (CellView cell : fixedCells) {
                    double originalLayoutY = ((TableRow)this.getSkinnable()).getLayoutY() + cell.getLayoutY();
                    gridRow.removeCell(cell);
                    gridRow.addCell(cell);
                    if (this.handle.getCellsViewSkin().deportedCells.containsKey((Object)gridRow)) {
                        this.handle.getCellsViewSkin().deportedCells.get((Object)gridRow).add(cell);
                    } else {
                        HashSet<CellView> temp = new HashSet<CellView>();
                        temp.add(cell);
                        this.handle.getCellsViewSkin().deportedCells.put(gridRow, temp);
                    }
                    cell.relocate(cell.getLayoutX(), originalLayoutY - gridRow.getLayoutY());
                }
                break block5;
            }
            for (CellView cell : fixedCells) {
                cell.toFront();
            }
        }
    }

    private HashMap<TableColumnBase, CellView> getCellsMap() {
        if (this.cellsMap == null || this.cellsMap.get() == null) {
            HashMap<TableColumnBase, CellView> map = new HashMap<TableColumnBase, CellView>();
            this.cellsMap = new WeakReference(map);
            return map;
        }
        return this.cellsMap.get();
    }

    private void putCellsInCache() {
        for (CellView cell : this.cells) {
            this.getCellsMap().put((TableColumnBase)cell.getTableColumn(), cell);
        }
        this.cells.clear();
    }

    private CellView getCell(TableColumnBase tcb) {
        TableColumn tableColumn = (TableColumn)tcb;
        if (this.getCellsMap().containsKey(tableColumn)) {
            return this.getCellsMap().remove(tableColumn);
        }
        CellView cell = (CellView)((Object)tableColumn.getCellFactory().call((Object)tableColumn));
        cell.updateTableColumn(tableColumn);
        cell.updateTableView(tableColumn.getTableView());
        cell.updateTableRow((TableRow)this.getSkinnable());
        return cell;
    }

    private double getFixedRowShift(int index) {
        double tableCellY = 0.0;
        int positionY = this.spreadsheetView.getFixedRows().indexOf((Object)index);
        double space = 0.0;
        for (int o = 0; o < positionY; ++o) {
            space += this.handle.getCellsViewSkin().getRowHeight((Integer)this.spreadsheetView.getFixedRows().get(o));
        }
        if (positionY != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= space) {
            tableCellY = space - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().add((Object)index);
        } else {
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().remove((Object)index);
        }
        return tableCellY;
    }

    private double getTableRowHeight(int row) {
        Double rowHeightCache = (Double)this.handle.getCellsViewSkin().rowHeightMap.get((Object)row);
        return rowHeightCache == null ? this.handle.getView().getGrid().getRowHeight(row) : rowHeightCache.doubleValue();
    }

    private boolean isInvisible(double x, double width, double hbarValue, double headerWidth, int columnSpan) {
        return x + width < hbarValue && columnSpan == 1 || x > hbarValue + headerWidth;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = 0.0;
        ObservableList visibleLeafColumns = this.handle.getGridView().getVisibleLeafColumns();
        int max = visibleLeafColumns.size();
        for (int i = 0; i < max; ++i) {
            prefWidth += ((TableColumnBase)visibleLeafColumns.get(i)).getWidth();
        }
        return prefWidth;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

