/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SelectedCellsMapTemp;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class TableViewSpanSelectionModel
extends TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> {
    private boolean shift = false;
    private boolean key = false;
    private boolean drag = false;
    private MouseEvent mouseEvent;
    private boolean makeAtomic;
    private SpreadsheetGridView cellsView;
    private SpreadsheetView spreadsheetView;
    private final SelectedCellsMapTemp<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCellsMap;
    private final ReadOnlyUnbackedObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCellsSeq;
    private final Timeline timer;
    private final EventHandler<ActionEvent> timerEventHandler = event -> {
        GridViewSkin skin = this.getCellsViewSkin();
        if (this.mouseEvent != null && !this.cellsView.contains(this.mouseEvent.getX(), this.mouseEvent.getY())) {
            double sceneX = this.mouseEvent.getSceneX();
            double sceneY = this.mouseEvent.getSceneY();
            double layoutX = this.cellsView.getLayoutX();
            double layoutY = this.cellsView.getLayoutY();
            double layoutXMax = layoutX + this.cellsView.getWidth();
            double layoutYMax = layoutY + this.cellsView.getHeight();
            if (sceneX > layoutXMax) {
                skin.getHBar().increment();
            } else if (sceneX < layoutX) {
                skin.getHBar().decrement();
            }
            if (sceneY > layoutYMax) {
                skin.getVBar().increment();
            } else if (sceneY < layoutY) {
                skin.getVBar().decrement();
            }
        }
    };
    private final EventHandler<MouseEvent> dragDoneHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TableViewSpanSelectionModel.this.drag = false;
            TableViewSpanSelectionModel.this.timer.stop();
            TableViewSpanSelectionModel.this.spreadsheetView.removeEventHandler(MouseEvent.MOUSE_RELEASED, this);
        }
    };
    private final EventHandler<KeyEvent> keyPressedEventHandler = keyEvent -> {
        this.key = true;
        this.shift = keyEvent.isShiftDown();
    };
    private final EventHandler<MouseEvent> mousePressedEventHandler = mouseEvent1 -> {
        this.key = false;
        this.shift = mouseEvent1.isShiftDown();
    };
    private final EventHandler<MouseEvent> onDragDetectedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TableViewSpanSelectionModel.this.cellsView.addEventHandler(MouseEvent.MOUSE_RELEASED, TableViewSpanSelectionModel.this.dragDoneHandler);
            TableViewSpanSelectionModel.this.drag = true;
            TableViewSpanSelectionModel.this.timer.setCycleCount(-1);
            TableViewSpanSelectionModel.this.timer.play();
        }
    };
    private final EventHandler<MouseEvent> onMouseDragEventHandler = e -> {
        this.mouseEvent = e;
    };
    private final ListChangeListener<TablePosition<ObservableList<SpreadsheetCell>, ?>> listChangeListener = this::handleSelectedCellsListChangeEvent;
    private TablePosition<ObservableList<SpreadsheetCell>, ?> old = null;

    public TableViewSpanSelectionModel(@NamedArg(value="spreadsheetView") SpreadsheetView spreadsheetView, @NamedArg(value="cellsView") SpreadsheetGridView cellsView) {
        super((TableView)cellsView);
        this.cellsView = cellsView;
        this.spreadsheetView = spreadsheetView;
        this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new WeakEventHandler(this.timerEventHandler), new KeyValue[0])});
        cellsView.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new WeakEventHandler(this.keyPressedEventHandler));
        cellsView.setOnMousePressed((EventHandler)new WeakEventHandler(this.mousePressedEventHandler));
        cellsView.setOnDragDetected((EventHandler)new WeakEventHandler(this.onDragDetectedEventHandler));
        cellsView.setOnMouseDragged((EventHandler)new WeakEventHandler(this.onMouseDragEventHandler));
        this.selectedCellsMap = new SelectedCellsMapTemp(new WeakListChangeListener(this.listChangeListener));
        this.selectedCellsSeq = new ReadOnlyUnbackedObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>(){

            public TablePosition<ObservableList<SpreadsheetCell>, ?> get(int i) {
                return (TablePosition)TableViewSpanSelectionModel.this.selectedCellsMap.get(i);
            }

            public int size() {
                return TableViewSpanSelectionModel.this.selectedCellsMap.size();
            }
        };
    }

    private void handleSelectedCellsListChangeEvent(ListChangeListener.Change<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>> c) {
        if (this.makeAtomic) {
            return;
        }
        this.selectedCellsSeq.callObservers((ListChangeListener.Change)new MappingChange(c, MappingChange.NOOP_MAP, this.selectedCellsSeq));
        c.reset();
    }

    public void select(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        if (row < 0 || row >= this.getItemCount()) {
            return;
        }
        if (this.isCellSelectionEnabled() && column == null) {
            return;
        }
        TablePosition posFinal = new TablePosition(this.getTableView(), row, column);
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(row, posFinal.getColumn());
        switch (spanType) {
            case ROW_SPAN_INVISIBLE: {
                int visibleRow;
                if (this.old != null && !this.shift && this.old.getColumn() == posFinal.getColumn() && this.old.getRow() == posFinal.getRow() - 1 && (visibleRow = FocusModelListener.getNextRowNumber(this.old, this.cellsView)) < this.getItemCount()) {
                    posFinal = this.getVisibleCell(visibleRow, this.old.getTableColumn(), this.old.getColumn());
                    break;
                }
                posFinal = this.getVisibleCell(row, column, posFinal.getColumn());
                break;
            }
            case BOTH_INVISIBLE: {
                posFinal = this.getVisibleCell(row, column, posFinal.getColumn());
                break;
            }
            case COLUMN_SPAN_INVISIBLE: {
                posFinal = this.old != null && !this.shift && this.old.getColumn() == posFinal.getColumn() - 1 && this.old.getRow() == posFinal.getRow() ? this.getVisibleCell(this.old.getRow(), FocusModelListener.getTableColumnSpan(this.old, this.cellsView), this.getTableColumnSpanInt(this.old)) : this.getVisibleCell(row, column, posFinal.getColumn());
            }
        }
        this.old = posFinal;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(this.old.getRow())).get(this.old.getColumn());
        for (int i = cell.getRow(); i < cell.getRowSpan() + cell.getRow(); ++i) {
            for (int j = cell.getColumn(); j < cell.getColumnSpan() + cell.getColumn(); ++j) {
                posFinal = new TablePosition(this.getTableView(), i, this.getTableView().getVisibleLeafColumn(j));
                this.selectedCellsMap.add(posFinal);
            }
        }
        this.updateScroll(this.old);
        this.addSelectedRowsAndColumns(this.old);
        this.setSelectedIndex(this.old.getRow());
        this.setSelectedItem(this.getModelItem(this.old.getRow()));
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(this.old.getRow(), this.old.getTableColumn());
    }

    private void updateScroll(TablePosition<ObservableList<SpreadsheetCell>, ?> posFinal) {
        if (!this.drag && this.key && this.getCellsViewSkin().getCellsSize() != 0 && this.spreadsheetView.getFixedRows().size() != 0) {
            int start = this.getCellsViewSkin().getRow(0).getIndex();
            double posFinalOffset = 0.0;
            for (int j = start; j < posFinal.getRow(); ++j) {
                posFinalOffset += this.getSpreadsheetViewSkin().getRowHeight(j);
            }
            if (this.getCellsViewSkin().getFixedRowHeight() > posFinalOffset) {
                this.cellsView.scrollTo(posFinal.getRow());
            }
        }
    }

    public void clearSelection(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        TablePosition tp = new TablePosition(this.getTableView(), row, column);
        if (tp.getRow() < 0 || tp.getColumn() < 0) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> position = this.isSelectedRange(row, column, tp.getColumn());
        if (position != null) {
            this.selectedCellsMap.remove(position);
            this.removeSelectedRowsAndColumns(position);
            this.focus(position.getRow());
        } else {
            for (TablePosition pos : this.getSelectedCells()) {
                if (!pos.equals((Object)tp)) continue;
                this.selectedCellsMap.remove(pos);
                this.removeSelectedRowsAndColumns(pos);
                this.focus(row);
                return;
            }
        }
    }

    public void verifySelectedCells(List<Pair<Integer, Integer>> selectedCells) {
        ArrayList<TablePosition> newList = new ArrayList<TablePosition>();
        this.clearSelection();
        int itemCount = this.getItemCount();
        int columnSize = this.getTableView().getColumns().size();
        HashSet<Integer> selectedRows = new HashSet<Integer>();
        HashSet<Integer> selectedColumns = new HashSet<Integer>();
        TablePosition pos = null;
        for (Pair<Integer, Integer> position : selectedCells) {
            if ((Integer)position.getKey() < 0 || (Integer)position.getKey() >= itemCount || (Integer)position.getValue() < 0 || (Integer)position.getValue() > columnSize) continue;
            TableColumn column = this.getTableView().getVisibleLeafColumn(((Integer)position.getValue()).intValue());
            pos = this.getVisibleCell((Integer)position.getKey(), column, (Integer)position.getValue());
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(pos.getRow())).get(pos.getColumn());
            for (int i = cell.getRow(); i < cell.getRowSpan() + cell.getRow(); ++i) {
                selectedColumns.add(i);
                for (int j = cell.getColumn(); j < cell.getColumnSpan() + cell.getColumn(); ++j) {
                    selectedRows.add(j);
                    pos = new TablePosition(this.getTableView(), i, this.getTableView().getVisibleLeafColumn(j));
                    newList.add(pos);
                }
            }
        }
        this.selectedCellsMap.setAll(newList);
        GridViewSkin skin = this.getSpreadsheetViewSkin();
        if (skin != null) {
            skin.getSelectedRows().addAll(selectedColumns);
            skin.getSelectedColumns().addAll(selectedRows);
        }
        if (pos != null && this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().lastRowLayout.set(true);
            this.getCellsViewSkin().lastRowLayout.addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    TableViewSpanSelectionModel.this.handleSelectedCellsListChangeEvent((ListChangeListener.Change)new NonIterableChange.SimpleAddChange(0, TableViewSpanSelectionModel.this.selectedCellsMap.size(), (ObservableList)TableViewSpanSelectionModel.this.selectedCellsSeq));
                    TableViewSpanSelectionModel.this.getCellsViewSkin().lastRowLayout.removeListener((InvalidationListener)this);
                }
            });
        }
    }

    public void selectRange(int minRow, TableColumnBase<ObservableList<SpreadsheetCell>, ?> minColumn, int maxRow, TableColumnBase<ObservableList<SpreadsheetCell>, ?> maxColumn) {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            this.select(maxRow, maxColumn);
            return;
        }
        this.makeAtomic = true;
        int itemCount = this.getItemCount();
        int minColumnIndex = this.getTableView().getVisibleLeafIndex((TableColumn)minColumn);
        int maxColumnIndex = this.getTableView().getVisibleLeafIndex((TableColumn)maxColumn);
        int _minColumnIndex = Math.min(minColumnIndex, maxColumnIndex);
        int _maxColumnIndex = Math.max(minColumnIndex, maxColumnIndex);
        int _minRow = Math.min(minRow, maxRow);
        int _maxRow = Math.max(minRow, maxRow);
        HashSet<Integer> selectedRows = new HashSet<Integer>();
        HashSet<Integer> selectedColumns = new HashSet<Integer>();
        for (int _row = _minRow; _row <= _maxRow; ++_row) {
            for (int _col = _minColumnIndex; _col <= _maxColumnIndex; ++_col) {
                TableColumn column;
                if (_row < 0 || _row >= itemCount || (column = this.getTableView().getVisibleLeafColumn(_col)) == null) continue;
                TablePosition pos = this.getVisibleCell(_row, column, _col);
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(pos.getRow())).get(pos.getColumn());
                for (int i = cell.getRow(); i < cell.getRowSpan() + cell.getRow(); ++i) {
                    selectedColumns.add(i);
                    for (int j = cell.getColumn(); j < cell.getColumnSpan() + cell.getColumn(); ++j) {
                        selectedRows.add(j);
                        pos = new TablePosition(this.getTableView(), i, this.getTableView().getVisibleLeafColumn(j));
                        this.selectedCellsMap.add(pos);
                    }
                }
            }
        }
        this.makeAtomic = false;
        this.getSpreadsheetViewSkin().getSelectedRows().addAll(selectedColumns);
        this.getSpreadsheetViewSkin().getSelectedColumns().addAll(selectedRows);
        this.setSelectedIndex(maxRow);
        this.setSelectedItem(this.getModelItem(maxRow));
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(maxRow, (TableColumn)maxColumn);
        int startChangeIndex = this.selectedCellsMap.indexOf(new TablePosition(this.getTableView(), minRow, (TableColumn)minColumn));
        int endChangeIndex = this.selectedCellsMap.getSelectedCells().size() - 1;
        if (startChangeIndex > -1 && endChangeIndex > -1) {
            int startIndex = Math.min(startChangeIndex, endChangeIndex);
            int endIndex = Math.max(startChangeIndex, endChangeIndex);
            this.handleSelectedCellsListChangeEvent((ListChangeListener.Change<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>>)new NonIterableChange.SimpleAddChange(startIndex, endIndex + 1, this.selectedCellsSeq));
        }
    }

    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        this.quietClearSelection();
        ArrayList<TablePosition> indices = new ArrayList<TablePosition>();
        TablePosition tp = null;
        for (int col = 0; col < this.getTableView().getVisibleLeafColumns().size(); ++col) {
            TableColumn column = (TableColumn)this.getTableView().getVisibleLeafColumns().get(col);
            for (int row = 0; row < this.getItemCount(); ++row) {
                tp = new TablePosition(this.getTableView(), row, column);
                indices.add(tp);
            }
        }
        this.selectedCellsMap.setAll(indices);
        ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
        for (int col = 0; col < this.spreadsheetView.getGrid().getColumnCount(); ++col) {
            selectedColumns.add(col);
        }
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        for (int row = 0; row < this.spreadsheetView.getGrid().getRowCount(); ++row) {
            selectedRows.add(row);
        }
        this.getSpreadsheetViewSkin().getSelectedRows().addAll(selectedRows);
        this.getSpreadsheetViewSkin().getSelectedColumns().addAll(selectedColumns);
        if (tp != null) {
            this.select(tp.getRow(), tp.getTableColumn());
            this.getTableView().getFocusModel().focus(tp.getRow(), tp.getTableColumn());
        }
    }

    public boolean isSelected(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        if (column == null || row < 0) {
            return false;
        }
        int columnIndex = this.getTableView().getVisibleLeafIndex(column);
        if (this.getCellsViewSkin().getCellsSize() != 0) {
            TablePosition<ObservableList<SpreadsheetCell>, ?> posFinal = this.getVisibleCell(row, column, columnIndex);
            return this.selectedCellsMap.isSelected(posFinal.getRow(), posFinal.getColumn());
        }
        return this.selectedCellsMap.isSelected(row, columnIndex);
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> isSelectedRange(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
        if (col < 0 || row < 0) {
            return null;
        }
        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(row)).get(col);
        int infRow = cellSpan.getRow();
        int supRow = infRow + cellSpan.getRowSpan();
        int infCol = cellSpan.getColumn();
        int supCol = infCol + cellSpan.getColumnSpan();
        for (TablePosition tp : this.getSelectedCells()) {
            if (tp.getRow() < infRow || tp.getRow() >= supRow || tp.getColumn() < infCol || tp.getColumn() >= supCol) continue;
            return tp;
        }
        return null;
    }

    private void addSelectedRowsAndColumns(TablePosition<?, ?> position) {
        GridViewSkin skin = this.getSpreadsheetViewSkin();
        if (skin == null) {
            return;
        }
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(position.getRow())).get(position.getColumn());
        for (int i = cell.getRow(); i < cell.getRowSpan() + cell.getRow(); ++i) {
            skin.getSelectedRows().add((Object)i);
            for (int j = cell.getColumn(); j < cell.getColumnSpan() + cell.getColumn(); ++j) {
                skin.getSelectedColumns().add((Object)j);
            }
        }
    }

    private void removeSelectedRowsAndColumns(TablePosition<?, ?> position) {
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(position.getRow())).get(position.getColumn());
        for (int i = cell.getRow(); i < cell.getRowSpan() + cell.getRow(); ++i) {
            this.getSpreadsheetViewSkin().getSelectedRows().remove((Object)i);
            for (int j = cell.getColumn(); j < cell.getColumnSpan() + cell.getColumn(); ++j) {
                this.getSpreadsheetViewSkin().getSelectedColumns().remove((Object)j);
            }
        }
    }

    public void clearAndSelect(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
        this.makeAtomic = true;
        ArrayList previousSelection = new ArrayList((Collection<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsMap.getSelectedCells());
        this.clearSelection();
        this.select(row, column);
        this.makeAtomic = false;
        if (this.old != null && this.old.getColumn() >= 0) {
            TableColumn columnFinal = (TableColumn)this.getTableView().getColumns().get(this.old.getColumn());
            int changeIndex = this.selectedCellsSeq.indexOf((Object)new TablePosition(this.getTableView(), this.old.getRow(), columnFinal));
            NonIterableChange.GenericAddRemoveChange change = new NonIterableChange.GenericAddRemoveChange(changeIndex, changeIndex + 1, previousSelection, this.selectedCellsSeq);
            this.handleSelectedCellsListChangeEvent((ListChangeListener.Change<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>>)change);
        }
    }

    public ObservableList<TablePosition> getSelectedCells() {
        return (ObservableList)this.selectedCellsSeq;
    }

    public void selectAboveCell() {
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getRow() == -1) {
            this.select(this.getItemCount() - 1);
        } else if (pos.getRow() > 0) {
            this.select(pos.getRow() - 1, pos.getTableColumn());
        }
    }

    public void selectBelowCell() {
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getRow() == -1) {
            this.select(0);
        } else if (pos.getRow() < this.getItemCount() - 1) {
            this.select(pos.getRow() + 1, pos.getTableColumn());
        }
    }

    public void selectLeftCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getColumn() - 1 >= 0) {
            this.select(pos.getRow(), this.getTableColumn(pos.getTableColumn(), -1));
        }
    }

    public void selectRightCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
        if (pos.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
            this.select(pos.getRow(), this.getTableColumn(pos.getTableColumn(), 1));
        }
    }

    public void clearSelection() {
        if (!this.makeAtomic) {
            this.setSelectedIndex(-1);
            this.setSelectedItem(this.getModelItem(-1));
            this.focus(-1);
        }
        this.quietClearSelection();
    }

    private void quietClearSelection() {
        this.selectedCellsMap.clear();
        GridViewSkin skin = this.getSpreadsheetViewSkin();
        if (skin != null) {
            skin.getSelectedRows().clear();
            skin.getSelectedColumns().clear();
        }
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getFocusedCell() {
        if (this.getTableView().getFocusModel() == null) {
            return new TablePosition(this.getTableView(), -1, null);
        }
        return this.cellsView.getFocusModel().getFocusedCell();
    }

    private TableColumn<ObservableList<SpreadsheetCell>, ?> getTableColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> column, int offset) {
        int columnIndex = this.getTableView().getVisibleLeafIndex(column);
        int newColumnIndex = columnIndex + offset;
        return this.getTableView().getVisibleLeafColumn(newColumnIndex);
    }

    private GridViewSkin getSpreadsheetViewSkin() {
        return this.getCellsViewSkin();
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getVisibleCell(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(row, col);
        switch (spanType) {
            case NORMAL_CELL: 
            case ROW_VISIBLE: {
                return new TablePosition((TableView)this.cellsView, row, column);
            }
        }
        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(row)).get(col);
        if (this.getCellsViewSkin().getCellsSize() != 0 && this.getNonFixedRow(0).getIndex() <= cellSpan.getRow()) {
            return new TablePosition((TableView)this.cellsView, cellSpan.getRow(), (TableColumn)this.cellsView.getColumns().get(cellSpan.getColumn()));
        }
        return new TablePosition((TableView)this.cellsView, this.getNonFixedRow(0).getIndex(), (TableColumn)this.cellsView.getColumns().get(cellSpan.getColumn()));
    }

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    private GridRow getNonFixedRow(int index) {
        return this.getCellsViewSkin().getRow(index);
    }

    private int getTableColumnSpanInt(TablePosition<?, ?> t) {
        return t.getColumn() + ((SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(t.getRow())).get(t.getColumn())).getColumnSpan();
    }
}

