/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.skin.ListSelectionViewSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;

public class ListSelectionView<T>
extends ControlsFXControl {
    private static final String DEFAULT_STYLECLASS = "list-selection-view";
    private final ObjectProperty<Node> sourceHeader = new SimpleObjectProperty((Object)this, "sourceHeader");
    private final ObjectProperty<Node> sourceFooter = new SimpleObjectProperty((Object)this, "sourceFooter");
    private final ObjectProperty<Node> targetHeader = new SimpleObjectProperty((Object)this, "targetHeader");
    private final ObjectProperty<Node> targetFooter = new SimpleObjectProperty((Object)this, "targetFooter");
    private ObjectProperty<ObservableList<T>> sourceItems;
    private ObjectProperty<ObservableList<T>> targetItems;
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)Orientation.HORIZONTAL);
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory;

    public ListSelectionView() {
        this.getStyleClass().add((Object)DEFAULT_STYLECLASS);
        Label sourceHeader = new Label(Localization.localize(Localization.asKey("listSelectionView.header.source")));
        sourceHeader.getStyleClass().add((Object)"list-header-label");
        sourceHeader.setId("source-header-label");
        this.setSourceHeader((Node)sourceHeader);
        Label targetHeader = new Label(Localization.localize(Localization.asKey("listSelectionView.header.target")));
        targetHeader.getStyleClass().add((Object)"list-header-label");
        targetHeader.setId("target-header-label");
        this.setTargetHeader((Node)targetHeader);
    }

    protected Skin<ListSelectionView<T>> createDefaultSkin() {
        return new ListSelectionViewSkin(this);
    }

    public final ObjectProperty<Node> sourceHeaderProperty() {
        return this.sourceHeader;
    }

    public final Node getSourceHeader() {
        return (Node)this.sourceHeader.get();
    }

    public final void setSourceHeader(Node node) {
        this.sourceHeader.set((Object)node);
    }

    public final ObjectProperty<Node> sourceFooterProperty() {
        return this.sourceFooter;
    }

    public final Node getSourceFooter() {
        return (Node)this.sourceFooter.get();
    }

    public final void setSourceFooter(Node node) {
        this.sourceFooter.set((Object)node);
    }

    public final ObjectProperty<Node> targetHeaderProperty() {
        return this.targetHeader;
    }

    public final Node getTargetHeader() {
        return (Node)this.targetHeader.get();
    }

    public final void setTargetHeader(Node node) {
        this.targetHeader.set((Object)node);
    }

    public final ObjectProperty<Node> targetFooterProperty() {
        return this.targetFooter;
    }

    public final Node getTargetFooter() {
        return (Node)this.targetFooter.get();
    }

    public final void setTargetFooter(Node node) {
        this.targetFooter.set((Object)node);
    }

    public final void setSourceItems(ObservableList<T> value) {
        this.sourceItemsProperty().set(value);
    }

    public final ObservableList<T> getSourceItems() {
        return (ObservableList)this.sourceItemsProperty().get();
    }

    public final ObjectProperty<ObservableList<T>> sourceItemsProperty() {
        if (this.sourceItems == null) {
            this.sourceItems = new SimpleObjectProperty((Object)this, "sourceItems", (Object)FXCollections.observableArrayList());
        }
        return this.sourceItems;
    }

    public final void setTargetItems(ObservableList<T> value) {
        this.targetItemsProperty().set(value);
    }

    public final ObservableList<T> getTargetItems() {
        return (ObservableList)this.targetItemsProperty().get();
    }

    public final ObjectProperty<ObservableList<T>> targetItemsProperty() {
        if (this.targetItems == null) {
            this.targetItems = new SimpleObjectProperty((Object)this, "targetItems", (Object)FXCollections.observableArrayList());
        }
        return this.targetItems;
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set((Object)value);
    }

    public final Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
        }
        return this.cellFactory;
    }
}

