/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

@BA.Version(value=1.2f)
@BA.ShortName(value="Shell")
public class Shell {
    private DefaultExecutor exec;
    private CommandLine cl;
    private String encoding = "UTF8";
    private String eventName;

    public void Initialize(String EventName, String Executable, List Args) {
        this.init(EventName, Executable, Args, true);
    }

    public void InitializeDoNotHandleQuotes(String EventName, String Executable, List Args) {
        this.init(EventName, Executable, Args, false);
    }

    private void init(String EventName, String Executable, List Args, boolean handle) {
        this.exec = new DefaultExecutor();
        this.exec.setExitValues(null);
        this.eventName = EventName.toLowerCase(BA.cul);
        this.cl = new CommandLine(Executable);
        if (Args.IsInitialized()) {
            for (Object o : (java.util.List)Args.getObject()) {
                this.cl.addArgument((String)o, handle);
            }
        }
    }

    public boolean IsInitialized() {
        return this.exec != null;
    }

    public String getExecutable() {
        return this.cl.getExecutable();
    }

    public String[] getArguments() {
        return this.cl.getArguments();
    }

    public String getWorkingDirectory() {
        return this.exec.getWorkingDirectory().toString();
    }

    public void setWorkingDirectory(String s) {
        this.exec.setWorkingDirectory(new File(s));
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void KillProcess() {
        this.exec.getWatchdog().destroyProcess();
    }

    public void Run(BA ba, long TimeoutMs) throws ExecuteException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        this.run(ba, TimeoutMs, out, err);
    }

    public void RunWithOutputEvents(BA ba, long TimeoutMs) throws ExecuteException, IOException {
        this.run(ba, TimeoutMs, new EventOutput(ba, "_stdout"), new EventOutput(ba, "_stderr"));
    }

    public ShellSyncResult RunSynchronous(long TimeoutMs) throws IOException {
        ShellSyncResult sr = new ShellSyncResult();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        ExecuteWatchdog wd = new ExecuteWatchdog(TimeoutMs);
        this.exec.setWatchdog(wd);
        PumpStreamHandler p = new PumpStreamHandler(out, err);
        this.exec.setStreamHandler(p);
        try {
            sr.ExitCode = this.exec.execute(this.cl);
            sr.Success = true;
            sr.StdOut = new String(out.toByteArray(), this.encoding);
            sr.StdErr = new String(err.toByteArray(), this.encoding);
        }
        catch (ExecuteException e) {
            sr.Success = false;
            sr.StdErr = e.toString();
            sr.ExitCode = e.getExitValue();
        }
        return sr;
    }

    private void run(final BA ba, long TimeoutMs, final OutputStream out, final OutputStream err) throws ExecuteException, IOException {
        final ExecuteWatchdog wd = new ExecuteWatchdog(TimeoutMs);
        this.exec.setWatchdog(wd);
        PumpStreamHandler p = new PumpStreamHandler(out, err);
        this.exec.setStreamHandler(p);
        this.exec.execute(this.cl, new ExecuteResultHandler(){

            @Override
            public void onProcessFailed(ExecuteException e) {
                ba.raiseEventFromDifferentThread((Object)Shell.this, null, 0, String.valueOf(Shell.this.eventName) + "_processcompleted", false, new Object[]{false, e.getExitValue(), "", e.toString()});
            }

            @Override
            public void onProcessComplete(int exitValue) {
                String eo;
                String so;
                try {
                    if (out instanceof ByteArrayOutputStream) {
                        so = new String(((ByteArrayOutputStream)out).toByteArray(), Shell.this.encoding);
                        eo = new String(((ByteArrayOutputStream)err).toByteArray(), Shell.this.encoding);
                    } else {
                        so = "";
                        eo = "";
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                boolean success = true;
                if (wd.killedProcess()) {
                    eo = "timeout";
                    success = false;
                }
                ba.raiseEventFromDifferentThread((Object)Shell.this, null, 0, String.valueOf(Shell.this.eventName) + "_processcompleted", false, new Object[]{success, exitValue, so, eo});
                Shell.this.exec = null;
            }
        });
    }

    class EventOutput
    extends OutputStream {
        private final BA ba;
        private final String event;

        public EventOutput(BA ba, String event) {
            this.ba = ba;
            this.event = event;
        }

        @Override
        public void write(int b) throws IOException {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ba.raiseEvent2((Object)Shell.this, false, String.valueOf(Shell.this.eventName) + this.event, false, new Object[]{b, len});
        }
    }

    @BA.ShortName(value="ShellSyncResult")
    public static class ShellSyncResult {
        public boolean Success;
        public int ExitCode;
        public String StdOut;
        public String StdErr;
    }
}

