/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.exec.util.DebugUtils;

public class InputStreamPumper
implements Runnable {
    public static final int SLEEPING_TIME = 100;
    private final InputStream is;
    private final OutputStream os;
    private volatile boolean stop;

    public InputStreamPumper(InputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
        this.stop = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block2: while (true) {
                if (this.stop) {
                    return;
                }
                while (true) {
                    if (this.is.available() <= 0 || this.stop) {
                        this.os.flush();
                        Thread.sleep(100L);
                        continue block2;
                    }
                    this.os.write(this.is.read());
                }
                break;
            }
        }
        catch (Exception e) {
            String msg = "Got exception while reading/writing the stream";
            DebugUtils.handleException(msg, e);
        }
    }

    public void stopProcessing() {
        this.stop = true;
    }
}

