/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.InputStreamPumper;
import org.apache.commons.exec.StreamPumper;
import org.apache.commons.exec.util.DebugUtils;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private final OutputStream out;
    private final OutputStream err;
    private final InputStream input;
    private InputStreamPumper inputStreamPumper;

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, null);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err, InputStream input) {
        this.out = out;
        this.err = err;
        this.input = input;
    }

    @Override
    public void setProcessOutputStream(InputStream is) {
        if (this.out != null) {
            this.createProcessOutputPump(is, this.out);
        }
    }

    @Override
    public void setProcessErrorStream(InputStream is) {
        if (this.err != null) {
            this.createProcessErrorPump(is, this.err);
        }
    }

    @Override
    public void setProcessInputStream(OutputStream os) {
        if (this.input != null) {
            this.inputThread = this.input == System.in ? this.createSystemInPump(this.input, os) : this.createPump(this.input, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException e) {
                String msg = "Got exception while closing output stream";
                DebugUtils.handleException(msg, e);
            }
        }
    }

    @Override
    public void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
        if (this.inputThread != null) {
            this.inputThread.start();
        }
    }

    @Override
    public void stop() {
        String msg;
        if (this.inputStreamPumper != null) {
            this.inputStreamPumper.stopProcessing();
        }
        if (this.outputThread != null) {
            try {
                this.outputThread.join();
                this.outputThread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.errorThread != null) {
            try {
                this.errorThread.join();
                this.errorThread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.inputThread != null) {
            try {
                this.inputThread.join();
                this.inputThread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.err != null && this.err != this.out) {
            try {
                this.err.flush();
            }
            catch (IOException e) {
                msg = "Got exception while flushing the error stream : " + e.getMessage();
                DebugUtils.handleException(msg, e);
            }
        }
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                msg = "Got exception while flushing the output stream";
                DebugUtils.handleException(msg, e);
            }
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, false);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        Thread result = new Thread(new StreamPumper(is, os, closeWhenExhausted));
        result.setDaemon(true);
        return result;
    }

    private Thread createSystemInPump(InputStream is, OutputStream os) {
        this.inputStreamPumper = new InputStreamPumper(is, os);
        Thread result = new Thread(this.inputStreamPumper);
        result.setDaemon(true);
        return result;
    }
}

