/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.exec.TimeoutObserver;

public class Watchdog
implements Runnable {
    private Vector observers = new Vector(1);
    private final long timeout;
    private boolean stopped = false;

    public Watchdog(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout must not be less than 1.");
        }
        this.timeout = timeout;
    }

    public void addTimeoutObserver(TimeoutObserver to) {
        this.observers.addElement(to);
    }

    public void removeTimeoutObserver(TimeoutObserver to) {
        this.observers.removeElement(to);
    }

    protected final void fireTimeoutOccured() {
        Enumeration e = this.observers.elements();
        while (e.hasMoreElements()) {
            ((TimeoutObserver)e.nextElement()).timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        long now;
        long until = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && until > (now = System.currentTimeMillis())) {
            try {
                this.wait(until - now);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.stopped) {
            this.fireTimeoutOccured();
        }
    }
}

