/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.http;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

@BA.ShortName(value="HttpClient")
@BA.Version(value=1.11f)
public class HttpClientWrapper
implements BA.CheckForReinitialize {
    private static final int maxConnectionToRoute = 5;
    @BA.Hide
    public DefaultHttpClient client;
    private String eventName;

    public static void LIBRARY_DOC() {
    }

    public void Initialize(String EventName) throws ClientProtocolException, IOException {
        this.initializeShared(EventName, SSLSocketFactory.getSocketFactory());
    }

    private void initializeShared(String EventName, SSLSocketFactory ssl) {
        this.eventName = EventName.toLowerCase(BA.cul);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", ssl, 443));
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, new ConnPerRoute(){

            @Override
            public int getMaxForRoute(HttpRoute route) {
                return 5;
            }
        });
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.client = new DefaultHttpClient(cm, (HttpParams)params);
    }

    public void InitializeAcceptAll(String EventName) throws KeyManagementException, NoSuchAlgorithmException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        TrustManager[] tm = new TrustManager[]{new NaiveTrustManager()};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(new KeyManager[0], tm, new SecureRandom());
        SSLSocketFactory socketFactory = new SSLSocketFactory(context);
        socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        this.initializeShared(EventName, socketFactory);
    }

    public boolean IsInitialized() {
        return this.client != null;
    }

    public void SetHttpParameter(String Name, Object Value) {
        this.client.getParams().setParameter(Name, Value);
    }

    public void SetProxy(String Host, int Port, String Scheme2) {
        HttpHost hh = new HttpHost(Host, Port, Scheme2);
        this.client.getParams().setParameter("http.route.default-proxy", (Object)hh);
    }

    public void SetProxy2(String Host, int Port, String Scheme2, String Username, String Password) {
        HttpHost hh = new HttpHost(Host, Port, Scheme2);
        this.client.getCredentialsProvider().setCredentials(new AuthScope(Host, Port), new UsernamePasswordCredentials(Username, Password));
        this.client.getParams().setParameter("http.route.default-proxy", (Object)hh);
    }

    public boolean Execute(BA ba, HttpUriRequestWrapper HttpRequest2, int TaskId) throws ClientProtocolException, IOException {
        return this.ExecuteCredentials(ba, HttpRequest2, TaskId, null, null);
    }

    public boolean ExecuteCredentials(BA ba, HttpUriRequestWrapper HttpRequest2, int TaskId, String UserName, String Password) throws ClientProtocolException, IOException {
        ExecuteHelper runnable = new ExecuteHelper(ba, HttpRequest2, TaskId, UserName, Password);
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)TaskId);
        return true;
    }

    private HttpResponse executeWithTimeout(final Runnable handler, HttpUriRequest req, BA ba, final int TaskId) throws ClientProtocolException, IOException {
        try {
            HttpResponse response = this.client.execute(req);
            return response;
        }
        catch (ConnectionPoolTimeoutException cpte) {
            ba.postRunnable(new Runnable(){

                @Override
                public void run() {
                    BA.submitRunnable((Runnable)handler, (Object)HttpClientWrapper.this, (int)TaskId);
                }
            });
            return null;
        }
    }

    class ExecuteHelper
    implements Runnable {
        private BA ba;
        private HttpUriRequestWrapper HttpRequest;
        private int TaskId;
        private String UserName;
        private String Password;

        public ExecuteHelper(BA ba, HttpUriRequestWrapper HttpRequest, int TaskId, String UserName, String Password) {
            this.ba = ba;
            this.HttpRequest = HttpRequest;
            this.TaskId = TaskId;
            this.UserName = UserName;
            this.Password = Password;
        }

        @Override
        public void run() {
            block26: {
                HttpResponse response = null;
                try {
                    HttpEntityEnclosingRequestBase base;
                    if (this.HttpRequest.req instanceof HttpEntityEnclosingRequestBase && this.UserName != null && this.UserName.length() > 0 && (base = (HttpEntityEnclosingRequestBase)this.HttpRequest.req).getEntity() != null && !base.getEntity().isRepeatable()) {
                        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.UserName, this.Password);
                        BasicScheme scheme = new BasicScheme();
                        Header authorizationHeader = scheme.authenticate(credentials, this.HttpRequest.req);
                        this.HttpRequest.req.addHeader(authorizationHeader);
                    }
                    if ((response = HttpClientWrapper.this.executeWithTimeout(this, this.HttpRequest.req, this.ba, this.TaskId)) == null) {
                        return;
                    }
                    if (response.getStatusLine().getStatusCode() == 401 && this.UserName != null && this.UserName.length() > 0) {
                        boolean basic = false;
                        boolean digest = false;
                        Header challenge = null;
                        Header[] headerArray = response.getHeaders("WWW-Authenticate");
                        int n = headerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Header h = headerArray[n2];
                            String v = h.getValue().toLowerCase(BA.cul);
                            if (v.contains("basic")) {
                                basic = true;
                            } else if (v.contains("digest")) {
                                digest = true;
                                challenge = h;
                            }
                            ++n2;
                        }
                        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.UserName, this.Password);
                        if (response.getEntity() != null) {
                            response.getEntity().consumeContent();
                        }
                        if (digest) {
                            DigestScheme ds = new DigestScheme();
                            ds.processChallenge(challenge);
                            this.HttpRequest.req.addHeader(ds.authenticate(credentials, this.HttpRequest.req));
                            response = HttpClientWrapper.this.executeWithTimeout(this, this.HttpRequest.req, this.ba, this.TaskId);
                            if (response == null) {
                                return;
                            }
                        } else if (basic) {
                            BasicScheme scheme = new BasicScheme();
                            Header authorizationHeader = scheme.authenticate(credentials, this.HttpRequest.req);
                            this.HttpRequest.req.addHeader(authorizationHeader);
                            response = HttpClientWrapper.this.executeWithTimeout(this, this.HttpRequest.req, this.ba, this.TaskId);
                            if (response == null) {
                                return;
                            }
                        }
                    }
                    if (response.getStatusLine().getStatusCode() / 100 != 2) {
                        throw new Exception();
                    }
                    HttpResponeWrapper res = new HttpResponeWrapper();
                    res.innerInitialize(HttpClientWrapper.this);
                    res.response = response;
                    this.ba.raiseEventFromDifferentThread((Object)HttpClientWrapper.this.client, (Object)HttpClientWrapper.this, this.TaskId, String.valueOf(HttpClientWrapper.this.eventName) + "_responsesuccess", true, new Object[]{res, this.TaskId});
                }
                catch (Exception e) {
                    int statusCode;
                    String reason;
                    if (response != null) {
                        reason = response.getStatusLine().getReasonPhrase();
                        statusCode = response.getStatusLine().getStatusCode();
                    } else {
                        e.printStackTrace();
                        reason = e.toString();
                        statusCode = -1;
                    }
                    Method m = (Method)this.ba.htSubs.get(String.valueOf(HttpClientWrapper.this.eventName) + "_responseerror");
                    boolean shouldClose = true;
                    if (m != null) {
                        Object[] args;
                        if (m.getParameterTypes().length == 4 || BA.shellMode) {
                            HttpResponeWrapper res = null;
                            if (response != null) {
                                res = new HttpResponeWrapper();
                                res.innerInitialize(HttpClientWrapper.this);
                                res.response = response;
                                try {
                                    response.setEntity((HttpEntity)new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)response.getEntity())));
                                }
                                catch (Exception ee) {
                                    ee.printStackTrace();
                                }
                            }
                            args = new Object[]{res, reason, statusCode, this.TaskId};
                        } else {
                            args = new Object[]{reason, statusCode, this.TaskId};
                        }
                        shouldClose = false;
                        this.ba.raiseEventFromDifferentThread((Object)HttpClientWrapper.this.client, (Object)HttpClientWrapper.this, this.TaskId, String.valueOf(HttpClientWrapper.this.eventName) + "_responseerror", false, args);
                    }
                    if (!shouldClose || response == null || response.getEntity() == null) break block26;
                    try {
                        response.getEntity().consumeContent();
                    }
                    catch (IOException e1) {
                        BA.LogError((String)e1.toString());
                    }
                }
            }
        }
    }

    @BA.ShortName(value="HttpResponse")
    public static class HttpResponeWrapper {
        private HttpClientWrapper parent;
        private HttpResponse response;

        private void innerInitialize(HttpClientWrapper parent) {
            this.parent = parent;
        }

        public File.InputStreamWrapper GetInputStream() throws IllegalStateException, IOException {
            File.InputStreamWrapper isw = new File.InputStreamWrapper();
            isw.setObject((Object)this.response.getEntity().getContent());
            return isw;
        }

        public String GetString(String DefaultCharset) throws ParseException, IOException {
            if (this.response.getEntity() == null) {
                return "";
            }
            return EntityUtils.toString((HttpEntity)this.response.getEntity(), (String)DefaultCharset);
        }

        public Map GetHeaders() {
            return HttpResponeWrapper.convertHeaders(this.response.getAllHeaders());
        }

        static Map convertHeaders(Header[] headers) {
            Map m = new Map();
            m.Initialize();
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                List l = (List)m.Get((Object)h.getName());
                if (l == null) {
                    anywheresoftware.b4a.objects.collections.List ll = new anywheresoftware.b4a.objects.collections.List();
                    ll.Initialize();
                    l = (List)ll.getObject();
                    m.Put((Object)h.getName(), (Object)l);
                }
                l.add(h.getValue());
                ++n2;
            }
            return m;
        }

        public String getContentType() {
            return this.response.getEntity().getContentType().getValue();
        }

        public void Release() throws IOException {
            if (this.response != null && this.response.getEntity() != null) {
                this.response.getEntity().consumeContent();
            }
        }

        public String getContentEncoding() {
            return this.response.getEntity().getContentEncoding().getValue();
        }

        public long getContentLength() {
            return this.response.getEntity().getContentLength();
        }

        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public boolean GetAsynchronously(final BA ba, final String EventName, final OutputStream Output, final boolean CloseOutput, final int TaskId) throws IOException {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean abortConnection = false;
                    try {
                        HttpResponeWrapper.this.response.getEntity().writeTo(Output);
                        if (CloseOutput) {
                            Output.close();
                        }
                        ba.raiseEventFromDifferentThread((Object)HttpResponeWrapper.this.response, (Object)HttpResponeWrapper.this.parent, TaskId, String.valueOf(EventName.toLowerCase(BA.cul)) + "_streamfinish", true, new Object[]{true, TaskId});
                    }
                    catch (IOException e) {
                        abortConnection = true;
                        ba.setLastException((Exception)e);
                        if (CloseOutput) {
                            try {
                                Output.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        ba.raiseEventFromDifferentThread((Object)HttpResponeWrapper.this.response, (Object)HttpResponeWrapper.this.parent, TaskId, String.valueOf(EventName.toLowerCase(BA.cul)) + "_streamfinish", true, new Object[]{false, TaskId});
                    }
                    try {
                        if (abortConnection && HttpResponeWrapper.this.response.getEntity() instanceof ConnectionReleaseTrigger) {
                            ((ConnectionReleaseTrigger)HttpResponeWrapper.this.response.getEntity()).abortConnection();
                        } else {
                            HttpResponeWrapper.this.response.getEntity().consumeContent();
                        }
                    }
                    catch (IOException e) {
                        BA.LogError((String)e.toString());
                    }
                }
            };
            BA.submitRunnable((Runnable)runnable, (Object)this.parent, (int)TaskId);
            return true;
        }
    }

    @BA.ShortName(value="HttpRequest")
    public static class HttpUriRequestWrapper {
        private boolean POST;
        private AbstractHttpEntity entity;
        @BA.Hide
        public HttpRequestBase req;

        public void InitializeGet(String URL2) {
            this.req = new HttpGet(URL2);
            this.POST = false;
            this.sharedInit();
        }

        public void InitializeHead(String URL2) {
            this.req = new HttpHead(URL2);
            this.POST = false;
            this.sharedInit();
        }

        public void InitializeDelete(String URL2) {
            this.req = new HttpDelete(URL2);
            this.POST = false;
            this.sharedInit();
        }

        public void InitializePost(String URL2, InputStream InputStream2, int Length) {
            HttpPost post = new HttpPost(URL2);
            this.req = post;
            this.entity = new InputStreamEntity(InputStream2, (long)Length);
            post.setEntity((HttpEntity)this.entity);
            this.entity.setContentType("application/x-www-form-urlencoded");
            this.POST = true;
            this.sharedInit();
        }

        public void InitializePut(String URL2, InputStream InputStream2, int Length) {
            HttpPut post = new HttpPut(URL2);
            this.req = post;
            this.entity = new InputStreamEntity(InputStream2, (long)Length);
            post.setEntity((HttpEntity)this.entity);
            this.entity.setContentType("application/x-www-form-urlencoded");
            this.POST = true;
            this.sharedInit();
        }

        public void InitializePost2(String URL2, byte[] Data) {
            HttpPost post = new HttpPost(URL2);
            this.req = post;
            this.entity = new ByteArrayEntity(Data);
            post.setEntity((HttpEntity)this.entity);
            this.entity.setContentType("application/x-www-form-urlencoded");
            this.POST = true;
            this.sharedInit();
        }

        public void InitializePut2(String URL2, byte[] Data) {
            HttpPut post = new HttpPut(URL2);
            this.req = post;
            this.entity = new ByteArrayEntity(Data);
            post.setEntity((HttpEntity)this.entity);
            this.entity.setContentType("application/x-www-form-urlencoded");
            this.POST = true;
            this.sharedInit();
        }

        private void sharedInit() {
            this.setTimeout(30000);
        }

        public void SetContentType(String ContentType) {
            if (!this.POST) {
                throw new RuntimeException("Only Post / Put requests support this method.");
            }
            this.entity.setContentType(ContentType);
        }

        public void SetContentEncoding(String Encoding) {
            if (!this.POST) {
                throw new RuntimeException("Only Post / Put requests support this method.");
            }
            this.entity.setContentEncoding(Encoding);
        }

        public void setTimeout(int Timeout) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.req.getParams(), (int)Timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)this.req.getParams(), (int)Timeout);
        }

        public void SetHeader(String Name, String Value) {
            this.req.setHeader(Name, Value);
        }

        public void RemoveHeaders(String Name) {
            this.req.removeHeaders(Name);
        }
    }

    private static class NaiveTrustManager
    implements X509TrustManager {
        private NaiveTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

