/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.object;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.B4AClass;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.object.CookieWrapper;
import anywheresoftware.b4j.object.HttpSessionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.MultiPartInputStreamParser;

@BA.Hide
public class JServlet
extends HttpServlet
implements Filter {
    private final Class<?> handlerClass;
    private final Method initializeMethod;
    private final boolean singleThread;

    public JServlet(Class<?> handlerClass, boolean singleThread) throws SecurityException, NoSuchMethodException {
        this.handlerClass = handlerClass;
        this.initializeMethod = JServlet.getInitializeMethod(handlerClass);
        this.singleThread = singleThread;
    }

    public static Method getInitializeMethod(Class<?> c) throws NoSuchMethodException, SecurityException {
        Method m = null;
        try {
            m = c.getDeclaredMethod("_initialize", BA.class);
        }
        catch (NoSuchMethodException e) {
            m = c.getDeclaredMethod("innerInitializeHelper", BA.class);
        }
        return m;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.Handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.Handle(request, response, null);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.Handle(request, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        Handle h = new Handle(request, response, chain);
        if (this.singleThread && BA.firstInstance.getOwnerThread() != Thread.currentThread()) {
            h.cdl = new CountDownLatch(1);
            BA bA = BA.firstInstance;
            synchronized (bA) {
                BA.firstInstance.postRunnable((Runnable)h);
                try {
                    h.cdl.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        h.run();
    }

    class Handle
    implements Runnable {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final FilterChain chain;
        public CountDownLatch cdl;

        public Handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
            this.request = request;
            this.response = response;
            this.chain = chain;
        }

        @Override
        public void run() {
            try {
                B4AClass handler = (B4AClass)JServlet.this.handlerClass.newInstance();
                try {
                    JServlet.this.initializeMethod.invoke((Object)handler, new Object[]{null});
                    BA ba = handler.getBA();
                    if (BA.isShellModeRuntimeCheck((BA)ba)) {
                        ba.raiseEvent(null, "initialize", new Object[]{null});
                    }
                    Object o = ba.raiseEvent(null, this.chain == null ? "handle" : "filter", new Object[]{AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new ServletRequestWrapper(), (Object)this.request), AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new ServletResponseWrapper(), (Object)this.response)});
                    if (this.chain != null && Boolean.TRUE.equals(o)) {
                        this.chain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
                    }
                }
                finally {
                    if (this.cdl != null) {
                        this.cdl.countDown();
                    }
                }
            }
            catch (Exception e) {
                try {
                    this.response.sendError(500, e.toString());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    @BA.ShortName(value="Part")
    public static class PartWrapper
    extends AbsObjectWrapper<MultiPartInputStreamParser.MultiPart> {
        public boolean getIsFile() {
            return ((MultiPartInputStreamParser.MultiPart)this.getObject()).getFile() != null;
        }

        public String getSubmittedFilename() {
            return BA.ReturnString((String)((MultiPartInputStreamParser.MultiPart)this.getObject()).getSubmittedFileName());
        }

        public String getTempFile() throws IOException {
            return ((MultiPartInputStreamParser.MultiPart)this.getObject()).getFile().getCanonicalPath();
        }

        public String GetValue(String CharacterEncoding) throws UnsupportedEncodingException {
            return new String(((MultiPartInputStreamParser.MultiPart)this.getObject()).getBytes(), CharacterEncoding == null || CharacterEncoding == "" ? "UTF8" : CharacterEncoding);
        }
    }

    @BA.ShortName(value="ServletRequest")
    public static class ServletRequestWrapper
    extends AbsObjectWrapper<HttpServletRequest> {
        public boolean getSecure() {
            return ((HttpServletRequest)this.getObject()).isSecure();
        }

        public HttpSessionWrapper GetSession() {
            return (HttpSessionWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new HttpSessionWrapper(), (Object)((HttpServletRequest)this.getObject()).getSession());
        }

        public String getContentType() {
            return BA.ReturnString((String)((HttpServletRequest)this.getObject()).getContentType());
        }

        public String getCharacterEncoding() {
            return BA.ReturnString((String)((HttpServletRequest)this.getObject()).getCharacterEncoding());
        }

        public int getContentLength() {
            return ((HttpServletRequest)this.getObject()).getContentLength();
        }

        public List GetHeaders(String Name) {
            List l1 = new List();
            l1.Initialize();
            Enumeration e = ((HttpServletRequest)this.getObject()).getHeaders(Name);
            while (e.hasMoreElements()) {
                l1.Add(e.nextElement());
            }
            return l1;
        }

        public String GetHeader(String Name) {
            String s = ((HttpServletRequest)this.getObject()).getHeader(Name);
            return s == null ? "" : s;
        }

        public String getMethod() {
            return ((HttpServletRequest)this.getObject()).getMethod();
        }

        public String getRequestURI() {
            return ((HttpServletRequest)this.getObject()).getRequestURI();
        }

        public String getFullRequestURI() {
            return String.valueOf(((HttpServletRequest)this.getObject()).getRequestURL().toString()) + (((HttpServletRequest)this.getObject()).getQueryString() != null ? "?" + ((HttpServletRequest)this.getObject()).getQueryString() : "");
        }

        public String getRemoteAddress() {
            return ((HttpServletRequest)this.getObject()).getRemoteAddr();
        }

        public String GetParameter(String Name) {
            String h = ((HttpServletRequest)this.getObject()).getParameter(Name);
            return h == null ? "" : h;
        }

        public String[] GetParameterValues(String Name) {
            String[] s = ((HttpServletRequest)this.getObject()).getParameterValues(Name);
            if (s == null) {
                s = new String[]{};
            }
            return s;
        }

        public Map getParameterMap() {
            Map m = new Map();
            m.Initialize();
            for (Map.Entry e : ((HttpServletRequest)this.getObject()).getParameterMap().entrySet()) {
                m.Put(e.getKey(), e.getValue());
            }
            return m;
        }

        public File.InputStreamWrapper getInputStream() throws IOException {
            return (File.InputStreamWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new File.InputStreamWrapper(), (Object)((HttpServletRequest)this.getObject()).getInputStream());
        }

        public Map GetMultipartData(String Folder, long MaxSize) throws IOException, ServletException {
            MultipartConfigElement config = new MultipartConfigElement(Folder, MaxSize, MaxSize, 81920);
            MultiPartInputStreamParser in = new MultiPartInputStreamParser((InputStream)((HttpServletRequest)this.getObject()).getInputStream(), ((HttpServletRequest)this.getObject()).getContentType(), config, new File(Folder));
            Collection parts = in.getParts();
            Map m = new Map();
            m.Initialize();
            for (Part p : parts) {
                MultiPartInputStreamParser.MultiPart mp = (MultiPartInputStreamParser.MultiPart)p;
                m.Put((Object)mp.getName(), (Object)mp);
            }
            return m;
        }

        public CookieWrapper[] GetCookies() {
            Cookie[] c = ((HttpServletRequest)this.getObject()).getCookies();
            if (c == null) {
                return new CookieWrapper[0];
            }
            CookieWrapper[] cw = new CookieWrapper[c.length];
            int i = 0;
            while (i < c.length) {
                cw[i] = (CookieWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new CookieWrapper(), (Object)c[i]);
                ++i;
            }
            return cw;
        }
    }

    @BA.ShortName(value="ServletResponse")
    public static class ServletResponseWrapper
    extends AbsObjectWrapper<HttpServletResponse> {
        public String getErrorReason() {
            return BA.ReturnString((String)(this.getObject() instanceof Response ? ((Response)this.getObject()).getReason() : ""));
        }

        public ServletResponseWrapper Write(String Text) throws IOException {
            ((HttpServletResponse)this.getObject()).getWriter().write(Text);
            return this;
        }

        public File.OutputStreamWrapper getOutputStream() throws IOException {
            return (File.OutputStreamWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new File.OutputStreamWrapper(), (Object)((HttpServletResponse)this.getObject()).getOutputStream());
        }

        public void setStatus(int s) {
            ((HttpServletResponse)this.getObject()).setStatus(s);
        }

        public int getStatus() {
            return ((HttpServletResponse)this.getObject()).getStatus();
        }

        public String getCharacterEncoding() {
            return BA.ReturnString((String)((HttpServletResponse)this.getObject()).getCharacterEncoding());
        }

        public void setCharacterEncoding(String s) {
            ((HttpServletResponse)this.getObject()).setCharacterEncoding(s);
        }

        public void setContentType(String s) {
            ((HttpServletResponse)this.getObject()).setContentType(s);
        }

        public String getContentType() {
            return BA.ReturnString((String)((HttpServletResponse)this.getObject()).getContentType());
        }

        public void SetHeader(String Name, String Value) {
            ((HttpServletResponse)this.getObject()).setHeader(Name, Value);
        }

        public void SendRedirect(String Location2) throws IOException {
            ((HttpServletResponse)this.getObject()).sendRedirect(Location2);
        }

        public void setContentLength(int i) {
            ((HttpServletResponse)this.getObject()).setContentLength(i);
        }

        @BA.RaisesSynchronousEvents
        public void SendError(int StatusCode, String Message) throws IOException {
            try {
                ((HttpServletResponse)this.getObject()).sendError(StatusCode, Message);
            }
            catch (Exception e) {
                BA.LogError((String)"Failed to send error.");
                e.printStackTrace();
            }
        }

        public void AddCookie(CookieWrapper Cookie2) {
            ((HttpServletResponse)this.getObject()).addCookie((Cookie)Cookie2.getObject());
        }
    }
}

