/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.object;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.B4AClass;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4j.object.HttpSessionWrapper;
import anywheresoftware.b4j.object.JServlet;
import anywheresoftware.b4j.object.ServerWrapper;
import anywheresoftware.b4j.object.WebSocketModule;
import anywheresoftware.b4j.objects.collections.JSONParser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

@BA.ShortName(value="WebSocket")
public class WebSocket {
    @BA.Hide
    public Session session;
    WebSocketModule.Adapter adapter;
    boolean singleThread;
    final LinkedList<SimpleFuture> futures = new LinkedList();
    private boolean shouldFlushOutput;

    public boolean getSecure() {
        return this.session.isSecure();
    }

    public boolean getOpen() {
        return this.session.isOpen();
    }

    public void Flush() throws IOException {
        if (this.shouldFlushOutput) {
            this.session.getRemote().flush();
            this.shouldFlushOutput = false;
        }
    }

    private void sendText(String s) throws IOException {
        this.session.getRemote().sendString(s, null);
        this.shouldFlushOutput = true;
    }

    private SimpleFuture get(String etype, Map m) {
        JSONParser.JSONGenerator jg = new JSONParser.JSONGenerator();
        m.Put((Object)"etype", (Object)etype);
        try {
            jg.Initialize(m);
            SimpleFuture sf = new SimpleFuture(this);
            this.futures.add(sf);
            this.sendText(jg.ToString());
            return sf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void set(String etype, String id, Object value, String property) {
        Map m = new Map();
        m.Initialize();
        if (property != null) {
            m.Put((Object)"prop", (Object)property);
        }
        if (id != null) {
            m.Put((Object)"id", (Object)id.toLowerCase(BA.cul));
        }
        if (value != null) {
            m.Put((Object)"value", value);
        }
        this.set(etype, m);
    }

    private void set(String etype, Map m) {
        JSONParser.JSONGenerator jg = new JSONParser.JSONGenerator();
        m.Put((Object)"etype", (Object)etype);
        try {
            jg.Initialize(m);
            if (this.session.isOpen()) {
                this.sendText(jg.ToString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JQueryElement GetElementById(String Id) {
        return this.GetElementBySelector("#" + Id.toLowerCase(BA.cul));
    }

    public JQueryElement GetElementBySelector(String Selector) {
        JQueryElement j = new JQueryElement();
        j.ws = this;
        j.id = Selector;
        return j;
    }

    public void RunFunction(String Function2, List Args) {
        this.set("runFunction", null, Args != null && !Args.IsInitialized() ? null : Args, Function2);
    }

    public SimpleFuture RunFunctionWithResult(String Function2, List Args) {
        Map m = new Map();
        m.Initialize();
        m.Put((Object)"prop", (Object)Function2);
        if (Args != null && Args.IsInitialized()) {
            m.Put((Object)"value", (Object)Args);
        }
        return this.get("runFunctionWithResult", m);
    }

    public void Eval(String Script, List Args) {
        this.set("eval", null, Args != null && !Args.IsInitialized() ? null : Args, Script);
    }

    public void Alert(String Message) {
        this.set("alert", null, null, Message);
    }

    public SimpleFuture EvalWithResult(String Script, List Args) {
        Map m = new Map();
        m.Initialize();
        m.Put((Object)"prop", (Object)Script);
        if (Args != null && Args.IsInitialized()) {
            m.Put((Object)"value", (Object)Args);
        }
        return this.get("evalWithResult", m);
    }

    public JServlet.ServletRequestWrapper getUpgradeRequest() {
        return (JServlet.ServletRequestWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new JServlet.ServletRequestWrapper(), (Object)((ServletUpgradeRequest)((WebSocketSession)this.session).getUpgradeRequest()).getHttpServletRequest());
    }

    public HttpSessionWrapper getSession() {
        return (HttpSessionWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new HttpSessionWrapper(), (Object)((ServletUpgradeRequest)((WebSocketSession)this.session).getUpgradeRequest()).getHttpServletRequest().getSession());
    }

    public void Close() {
        if (this.session.isOpen()) {
            this.session.close();
        }
    }

    void setEvents(BA ba) {
        Map m = new Map();
        m.Initialize();
        m.Put((Object)"etype", (Object)"setAutomaticEvents");
        List events = new List();
        events.Initialize();
        m.Put((Object)"data", (Object)events);
        for (String sub : ba.htSubs.keySet()) {
            String event;
            int i = sub.lastIndexOf("_");
            if (i <= -1 || !JQueryElement.knownEvents.contains(event = sub.substring(i + 1))) continue;
            Map e = new Map();
            e.Initialize();
            e.Put((Object)"id", (Object)sub.substring(0, i));
            e.Put((Object)"event", (Object)event);
            events.Add((Object)e);
        }
        JSONParser.JSONGenerator jg = new JSONParser.JSONGenerator();
        try {
            jg.Initialize(m);
            this.sendText(jg.ToString());
            this.Flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setJQElements(B4AClass handler) {
        Field[] fieldArray = handler.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getType().equals(JQueryElement.class)) {
                try {
                    JQueryElement j = this.GetElementById(f.getName().substring(1));
                    f.set(handler, j);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    @BA.ShortName(value="JQueryElement")
    public static class JQueryElement {
        static final HashSet<String> knownEvents = new HashSet<String>(Arrays.asList("change", "click", "dblclick", "focus", "focusin", "focusout", "keyup", "mousedown", "mouseenter", "mouseleave", "mousemove", "mouseup"));
        private WebSocket ws;
        private String id;

        public String getId() {
            return this.id;
        }

        public void RunMethod(String Method2, List Params) {
            Map m = new Map();
            m.Initialize();
            m.Put((Object)"id", (Object)this.id);
            m.Put((Object)"method", (Object)Method2);
            if (Params != null && Params.IsInitialized()) {
                m.Put((Object)"params", (Object)Params);
            }
            this.ws.set("runmethod", m);
        }

        public SimpleFuture RunMethodWithResult(String Method2, List params) {
            Map m = new Map();
            m.Initialize();
            m.Put((Object)"id", (Object)this.id);
            m.Put((Object)"method", (Object)Method2);
            if (params != null && params.IsInitialized()) {
                m.Put((Object)"params", (Object)params);
            }
            return this.ws.get("runmethodWithResult", m);
        }

        private List createList(Object ... args) {
            return Common.ArrayToList((Object[])args);
        }

        public SimpleFuture GetProp(String Property) {
            return this.RunMethodWithResult("prop", this.createList(Property));
        }

        public void SetProp(String Property, Object Value) {
            this.RunMethod("prop", this.createList(Property, Value));
        }

        public SimpleFuture GetVal() {
            return this.RunMethodWithResult("val", null);
        }

        public void SetVal(Object Value) {
            this.RunMethod("val", this.createList(Value));
        }

        public SimpleFuture GetText() {
            return this.RunMethodWithResult("text", null);
        }

        public void SetText(String Value) {
            this.RunMethod("text", this.createList(Value));
        }

        public SimpleFuture GetHtml() {
            return this.RunMethodWithResult("html", null);
        }

        public void SetHtml(String Value) {
            this.RunMethod("html", this.createList(Value));
        }

        public SimpleFuture GetWidth() {
            return this.RunMethodWithResult("width", null);
        }

        public void SetWidth(String Value) {
            this.RunMethod("width", this.createList(Value));
        }

        public SimpleFuture GetHeight() {
            return this.RunMethodWithResult("height", null);
        }

        public void SetHeight(String Value) {
            this.RunMethod("height", this.createList(Value));
        }

        public SimpleFuture GetCSS(String Property) {
            return this.RunMethodWithResult("css", this.createList(Property));
        }

        public void SetCSS(String Property, String Value) {
            this.RunMethod("css", this.createList(Property, Value));
        }
    }

    @BA.ShortName(value="Future")
    public static class SimpleFuture {
        final WebSocket ws;
        final CountDownLatch latch;
        Object value;
        long startTime;

        public SimpleFuture() {
            this.ws = null;
            this.latch = null;
        }

        @BA.Hide
        public SimpleFuture(WebSocket ws) {
            this.latch = new CountDownLatch(1);
            this.ws = ws;
            if (ServerWrapper.debugNetworkLatency > 0) {
                this.startTime = System.currentTimeMillis();
            }
        }

        public Object getValue() throws InterruptedException, TimeoutException, ExecutionException, IOException {
            long timeToWait;
            this.ws.Flush();
            long n = 0L;
            if (ServerWrapper.LogWaitingMessages && this.latch.getCount() > 0L) {
                n = System.currentTimeMillis();
            }
            if (!this.latch.await(WebSocketModule.Servlet.DATA_TIMEOUT, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
            if (ServerWrapper.debugNetworkLatency > 0 && (timeToWait = (long)ServerWrapper.debugNetworkLatency - (System.currentTimeMillis() - n)) > 0L) {
                Thread.sleep(timeToWait);
            }
            if (ServerWrapper.LogWaitingMessages && n > 0L) {
                System.out.println("Waiting for value (" + (System.currentTimeMillis() - n) + " ms)");
            }
            return this.value;
        }
    }
}

