/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import anywheresoftware.b4j.objects.JFX;
import anywheresoftware.b4j.objects.NodeWrapper;
import anywheresoftware.b4j.objects.PaneWrapper;
import anywheresoftware.b4j.objects.ScrollPaneWrapper;
import anywheresoftware.b4j.xui.CSSUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import org.imgscalr.Scalr;

@BA.Version(value=1.9f)
@BA.ShortName(value="B4XView")
public class B4XViewWrapper
extends AbsObjectWrapper<Object> {
    public static final int TOUCH_ACTION_DOWN = 0;
    public static final int TOUCH_ACTION_UP = 1;
    public static final int TOUCH_ACTION_MOVE = 2;
    public static final int TOUCH_ACTION_MOVE_NOTOUCH = 100;
    private NodeWrapper.ConcreteNodeWrapper nodeWrapper = new NodeWrapper.ConcreteNodeWrapper();

    private NodeWrapper.ConcreteNodeWrapper asViewWrapper() {
        this.nodeWrapper.setObject(this.getNodeObject());
        return this.nodeWrapper;
    }

    private Node getNodeObject() {
        return (Node)this.getObject();
    }

    @Override
    public void setObject(Object o) {
        if (o instanceof ObjectWrapper) {
            o = ((ObjectWrapper)o).getObjectOrNull();
        }
        super.setObject(o);
    }

    private NodeWrapper.ControlWrapper.ConcreteControlWrapper asControlWrapper() {
        return (NodeWrapper.ControlWrapper.ConcreteControlWrapper)AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.ControlWrapper.ConcreteControlWrapper(), this.getObject());
    }

    private PaneWrapper.ConcretePaneWrapper asPaneWrapper() {
        return (PaneWrapper.ConcretePaneWrapper)AbsObjectWrapper.ConvertToWrapper(new PaneWrapper.ConcretePaneWrapper(), this.getObject());
    }

    private ImageViewWrapper asImageViewWrapper() {
        return (ImageViewWrapper)AbsObjectWrapper.ConvertToWrapper(new ImageViewWrapper(), this.getObject());
    }

    public boolean getVisible() {
        return this.asViewWrapper().getVisible();
    }

    public void setVisible(boolean b) {
        this.asViewWrapper().setVisible(b);
    }

    public boolean getEnabled() {
        return this.asViewWrapper().getEnabled();
    }

    public void setEnabled(boolean b) {
        this.asViewWrapper().setEnabled(b);
    }

    public void setLeft(double d) {
        this.asViewWrapper().setLeft(Math.round(d));
    }

    public void setTop(double d) {
        this.asViewWrapper().setTop(Math.round(d));
    }

    public void setWidth(double d) {
        NodeWrapper.ConcreteNodeWrapper c = this.asViewWrapper();
        c.SetSize(Math.round(d), c.getPrefHeight());
    }

    public void setHeight(double d) {
        NodeWrapper.ConcreteNodeWrapper c = this.asViewWrapper();
        c.SetSize(c.getPrefWidth(), Math.round(d));
    }

    public double getLeft() {
        return this.asViewWrapper().getLeft();
    }

    public double getTop() {
        return this.asViewWrapper().getTop();
    }

    public double getWidth() {
        double w = this.asViewWrapper().getPrefWidth();
        if (w < 0.0 && this.getObject() instanceof Pane) {
            return ((Pane)this.getObject()).getWidth();
        }
        return w;
    }

    public double getHeight() {
        double h = this.asViewWrapper().getPrefHeight();
        if (h < 0.0 && this.getObject() instanceof Pane) {
            return ((Pane)this.getObject()).getHeight();
        }
        return h;
    }

    public void SetLayoutAnimated(int Duration2, double Left, double Top, double Width, double Height) {
        Left = Math.round(Left);
        Top = Math.round(Top);
        Width = Math.round(Width);
        Height = Math.round(Height);
        Node n = this.getNodeObject();
        if (n instanceof Control) {
            this.asControlWrapper().SetLayoutAnimated(Duration2, Left, Top, Width, Height);
        } else if (n instanceof Pane) {
            this.asPaneWrapper().SetLayoutAnimated(Duration2, Left, Top, Width, Height);
        } else if (n instanceof ImageView) {
            this.asImageViewWrapper().SetLayoutAnimated(Duration2, Left, Top, Width, Height);
        } else {
            NodeWrapper.SetLayout(n, new double[]{Left, Top, Width, Height});
        }
    }

    public void SetVisibleAnimated(BA ba, int Duration2, boolean Visible) {
        NodeWrapper.ConcreteNodeWrapper nw = this.asViewWrapper();
        if (Visible) {
            nw.setAlpha(0.0);
            nw.setVisible(true);
            nw.SetAlphaAnimated(Duration2, 1.0);
        } else {
            nw.setAlpha(1.0);
            nw.SetAlphaAnimated(Duration2, 0.0);
            EventHandler<ActionEvent> e = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    B4XViewWrapper.this.getNodeObject().setVisible(false);
                }
            };
            if (Duration2 > 0) {
                Animation anim = (Animation)((WeakReference)AbsObjectWrapper.extraTagsGetValueIfAvailable(this.getObject(), "animation_SetAlphaAnimated")).get();
                anim.setOnFinished((EventHandler)e);
            } else {
                e.handle(null);
            }
        }
    }

    public B4XViewWrapper getParent() {
        return (B4XViewWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XViewWrapper(), this.asViewWrapper().getParent().getObjectOrNull());
    }

    public void RemoveViewFromParent() {
        this.asViewWrapper().RemoveNodeFromParent();
    }

    public boolean RequestFocus() {
        this.asViewWrapper().RequestFocus();
        return true;
    }

    public void setProgress(int i) {
        ProgressIndicator pb = (ProgressIndicator)this.getObject();
        pb.setProgress((double)i / 100.0);
    }

    public int getProgress() {
        return (int)Math.round(((ProgressIndicator)this.getObject()).getProgress() * 100.0);
    }

    public String getEditTextHint() {
        return ((TextInputControl)this.getObject()).getPromptText();
    }

    public void setEditTextHint(String s) {
        ((TextInputControl)this.getObject()).setPromptText(s);
    }

    public void setText(String s) {
        Node n = this.getNodeObject();
        if (n instanceof Labeled) {
            ((Labeled)n).setText(s);
        } else if (n instanceof TextInputControl) {
            ((TextInputControl)n).setText(s);
        } else {
            throw this.typeDoesNotMatch();
        }
    }

    public String getText() {
        Node n = this.getNodeObject();
        if (n instanceof Labeled) {
            return ((Labeled)n).getText();
        }
        if (n instanceof TextInputControl) {
            return ((TextInputControl)n).getText();
        }
        throw this.typeDoesNotMatch();
    }

    public void setTextColor(int c) {
        Node n = this.getNodeObject();
        if (n instanceof Labeled) {
            ((Labeled)n).setTextFill((Paint)JFX.Colors.From32Bit(c));
        } else {
            XUI.css.SetStyleProperty(n, "-fx-text-fill", XUI.css.ColorToHex((Paint)JFX.Colors.From32Bit(c)));
        }
    }

    public int getTextColor() {
        Node n = this.getNodeObject();
        if (n instanceof Labeled) {
            return JFX.Colors.To32Bit(((Labeled)n).getTextFill());
        }
        return XUI.css.GetColorFromProperty(this.getNodeObject(), "-fx-text-fill", 0);
    }

    public void SetTextSizeAnimated(int Duration2, double TextSize) {
        if (Duration2 == 0) {
            this.asViewWrapper().raiseAnimationCompletedEvent(null, "SetTextSizeAnimated");
            this.setTextSize(TextSize);
            return;
        }
        final Node n = this.getNodeObject();
        final boolean isLabeled = n instanceof Labeled;
        final String fontName = isLabeled ? ((Labeled)n).getFont().getName() : null;
        SimpleObjectProperty prop = new SimpleObjectProperty((Object)this.getTextSize());
        prop.addListener((ChangeListener)new ChangeListener<Double>(){

            public void changed(ObservableValue<? extends Double> observable, Double oldValue, Double newValue) {
                if (isLabeled) {
                    ((Labeled)n).setFont(new Font(fontName, newValue.doubleValue()));
                } else {
                    XUI.css.SetStyleProperty(n, "-fx-font-size", String.format(BA.cul, "%.2f", newValue));
                }
            }
        });
        KeyValue a = new KeyValue((WritableValue)prop, (Object)TextSize);
        KeyFrame frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{a});
        Timeline timeline = new Timeline(new KeyFrame[]{frame});
        this.asViewWrapper().raiseAnimationCompletedEvent((Animation)timeline, "SetTextSizeAnimated");
        timeline.play();
    }

    public double getTextSize() {
        if (this.getNodeObject() instanceof Labeled) {
            return ((Labeled)this.getObject()).getFont().getSize();
        }
        String size = XUI.css.GetStyleProperty(this.getNodeObject(), "-fx-font-size");
        if (size.length() != 0) {
            return Double.parseDouble(size);
        }
        return 0.0;
    }

    public void setTextSize(double d) {
        if (this.getNodeObject() instanceof Labeled) {
            ((Labeled)this.getObject()).setFont(new Font(((Labeled)this.getObject()).getFont().getName(), d));
        } else {
            XUI.css.SetStyleProperty(this.getNodeObject(), "-fx-font-size", String.format(BA.cul, "%.2f", d));
        }
    }

    public B4XFont getFont() {
        Font f = null;
        if (this.getNodeObject() instanceof Labeled) {
            f = ((Labeled)this.getObject()).getFont();
        } else {
            String FontName = XUI.css.GetStyleProperty(this.getNodeObject(), "-fx-font-family");
            if (FontName.length() != 0) {
                f = new Font(FontName, this.getTextSize());
            }
        }
        return (B4XFont)AbsObjectWrapper.ConvertToWrapper(new B4XFont(), f);
    }

    public void setFont(B4XFont f) {
        if (this.getNodeObject() instanceof Labeled) {
            ((Labeled)this.getObject()).setFont((Font)f.getObject());
        } else {
            XUI.css.SetStyleProperty(this.getNodeObject(), "-fx-font-size", String.format(BA.cul, "%.2f", ((Font)f.getObject()).getSize()));
            XUI.css.SetStyleProperty(this.getNodeObject(), "-fx-font-family", ((Font)f.getObject()).getName());
        }
    }

    public void SetTextAlignment(String Vertical, String Horizontal) {
        Node n;
        String s = String.valueOf(Vertical) + "_" + Horizontal;
        if (s.equals("CENTER_CENTER")) {
            s = "CENTER";
        }
        if (!((n = this.getNodeObject()) instanceof Labeled)) {
            throw this.typeDoesNotMatch();
        }
        ((Labeled)n).setAlignment(Enum.valueOf(Pos.class, s));
    }

    public void setChecked(boolean b) {
        Node n = this.getNodeObject();
        if (n instanceof CheckBox) {
            ((CheckBox)n).setSelected(b);
        } else if (n instanceof RadioButton) {
            ((RadioButton)n).setSelected(b);
        } else if (n instanceof ToggleButton) {
            ((ToggleButton)n).setSelected(b);
        } else {
            throw this.typeDoesNotMatch();
        }
    }

    public boolean getChecked() {
        Node n = this.getNodeObject();
        if (n instanceof CheckBox) {
            return ((CheckBox)n).isSelected();
        }
        if (n instanceof RadioButton) {
            return ((RadioButton)n).isSelected();
        }
        if (n instanceof ToggleButton) {
            return ((ToggleButton)n).isSelected();
        }
        throw this.typeDoesNotMatch();
    }

    public BA.IterableList GetAllViewsRecursive() {
        return this.asPaneWrapper().GetAllViewsRecursive();
    }

    @BA.RaisesSynchronousEvents
    public void LoadLayout(String LayoutFile, BA ba) throws Exception {
        this.asPaneWrapper().LoadLayout(ba, LayoutFile);
    }

    public B4XViewWrapper GetView(int Index) {
        return (B4XViewWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XViewWrapper(), this.asPaneWrapper().GetNode(Index).getObject());
    }

    public void AddView(Node View, double Left, double Top, double Width, double Height) {
        this.asPaneWrapper().AddNode(View, Left, Top, Width, Height);
    }

    public void RemoveAllViews() {
        this.asPaneWrapper().RemoveAllNodes();
    }

    public int getNumberOfViews() {
        return this.asPaneWrapper().getNumberOfNodes();
    }

    public B4XBitmapWrapper Snapshot() {
        return (B4XBitmapWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XBitmapWrapper(), this.asViewWrapper().Snapshot2(JFX.Colors.Transparent).getObjectOrNull());
    }

    public void SetBitmap(javafx.scene.image.Image Bitmap) {
        ImageViewWrapper i = this.asImageViewWrapper();
        i.SetImage(Bitmap);
        i.setPreserveRatio(true);
    }

    private RuntimeException typeDoesNotMatch() {
        return new RuntimeException("Type does not match (" + this.getObject().getClass() + ")");
    }

    public void setColor(int Color2) {
        XUI.css.SetBackgroundColor(this.getNodeObject(), (Paint)JFX.Colors.From32Bit(Color2));
    }

    public int getColor() {
        return XUI.css.GetColorFromProperty(this.getNodeObject(), "-fx-background-color", 0);
    }

    public void SetColorAnimated(int Duration2, int FromColor, int ToColor) {
        if (Duration2 == 0) {
            this.asViewWrapper().raiseAnimationCompletedEvent(null, "SetColorAnimated");
            this.setColor(ToColor);
            return;
        }
        final Node n = this.getNodeObject();
        SimpleObjectProperty prop = new SimpleObjectProperty((Object)JFX.Colors.From32Bit(FromColor));
        prop.addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                XUI.css.SetBackgroundColor(n, (Paint)newValue);
            }
        });
        KeyValue a = new KeyValue((WritableValue)prop, (Object)JFX.Colors.From32Bit(ToColor));
        KeyFrame frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{a});
        Timeline timeline = new Timeline(new KeyFrame[]{frame});
        this.asViewWrapper().raiseAnimationCompletedEvent((Animation)timeline, "SetColorAnimated");
        timeline.play();
    }

    public void SetColorAndBorder(int BackgroundColor, double BorderWidth, int BorderColor, double BorderCornerRadius) {
        XUI.css.SetBackgroundColor(this.getNodeObject(), (Paint)JFX.Colors.From32Bit(BackgroundColor));
        XUI.css.SetBorder(this.getNodeObject(), BorderWidth, (Paint)JFX.Colors.From32Bit(BorderColor), BorderCornerRadius);
    }

    private ScrollPaneWrapper asScrollPaneWrapper() {
        return (ScrollPaneWrapper)AbsObjectWrapper.ConvertToWrapper(new ScrollPaneWrapper(), this.getObject());
    }

    public double getScrollViewOffsetY() {
        ScrollPaneWrapper s = this.asScrollPaneWrapper();
        return s.getVPosition() * (((Pane)((ScrollPane)s.getObject()).getContent()).getPrefHeight() - s.getHeight());
    }

    public void setScrollViewOffsetY(double d) {
        ScrollPaneWrapper s = this.asScrollPaneWrapper();
        s.setVPosition(d / (((Pane)((ScrollPane)s.getObject()).getContent()).getPrefHeight() - s.getHeight()));
    }

    public double getScrollViewOffsetX() {
        ScrollPaneWrapper s = this.asScrollPaneWrapper();
        return s.getHPosition() * (((Pane)((ScrollPane)s.getObject()).getContent()).getPrefWidth() - s.getWidth());
    }

    public void setScrollViewOffsetX(double d) {
        ScrollPaneWrapper s = this.asScrollPaneWrapper();
        s.setHPosition(d / (((Pane)((ScrollPane)s.getObject()).getContent()).getPrefWidth() - s.getWidth()));
    }

    public B4XViewWrapper getScrollViewInnerPanel() {
        return (B4XViewWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XViewWrapper(), this.asScrollPaneWrapper().getInnerNode().getObjectOrNull());
    }

    public double getScrollViewContentHeight() {
        return this.asScrollPaneWrapper().getInnerNode().getPrefHeight();
    }

    public void setScrollViewContentHeight(double d) {
        this.asScrollPaneWrapper().getInnerNode().setPrefHeight(d);
    }

    public double getScrollViewContentWidth() {
        return this.asScrollPaneWrapper().getInnerNode().getPrefWidth();
    }

    public void setScrollViewContentWidth(double d) {
        this.asScrollPaneWrapper().getInnerNode().setPrefWidth(d);
    }

    public Object getTag() {
        return this.asViewWrapper().getTag();
    }

    public void setTag(Object o) {
        this.asViewWrapper().setTag(o);
    }

    public void SendToBack() {
        this.getNodeObject().toBack();
    }

    public void BringToFront() {
        this.getNodeObject().toFront();
    }

    public void SetRotationAnimated(int Duration2, double Degree) {
        if (Duration2 == 0) {
            this.setRotation(Degree);
            this.asViewWrapper().raiseAnimationCompletedEvent(null, "SetRotationAnimated");
        }
        Node v = this.getNodeObject();
        KeyValue a = new KeyValue((WritableValue)v.rotateProperty(), (Object)Degree);
        KeyFrame frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{a});
        Timeline timeline = new Timeline(new KeyFrame[]{frame});
        timeline.play();
        this.asViewWrapper().raiseAnimationCompletedEvent((Animation)timeline, "SetRotationAnimated");
    }

    public double getRotation() {
        return this.getNodeObject().getRotate();
    }

    public void setRotation(double f) {
        this.getNodeObject().setRotate(f);
    }

    @BA.ShortName(value="B4XBitmap")
    public static class B4XBitmapWrapper
    extends AbsObjectWrapper<javafx.scene.image.Image> {
        public double getWidth() {
            return ((javafx.scene.image.Image)this.getObject()).getWidth();
        }

        public double getHeight() {
            return ((javafx.scene.image.Image)this.getObject()).getHeight();
        }

        public void WriteToStream(OutputStream Out, int Quality, String Format2) throws IOException {
            if (Format2.equals("PNG")) {
                ((ImageViewWrapper.ImageWrapper)AbsObjectWrapper.ConvertToWrapper(new ImageViewWrapper.ImageWrapper(), this.getObject())).WriteToStream(Out);
            } else if (Format2.equals("JPEG")) {
                BufferedImage imageRGB = new BufferedImage((int)((javafx.scene.image.Image)this.getObject()).getWidth(), (int)((javafx.scene.image.Image)this.getObject()).getHeight(), 1);
                Graphics2D graphics = imageRGB.createGraphics();
                graphics.drawImage((Image)SwingFXUtils.fromFXImage((javafx.scene.image.Image)((javafx.scene.image.Image)this.getObject()), null), 0, 0, null);
                JPEGImageWriteParam param = new JPEGImageWriteParam(null);
                param.setCompressionMode(2);
                param.setCompressionQuality((float)Quality / 100.0f);
                ImageWriter iw = ImageIO.getImageWritersByFormatName("jpg").next();
                iw.setOutput(ImageIO.createImageOutputStream(Out));
                iw.write(null, new IIOImage(imageRGB, null, null), param);
            } else {
                throw new RuntimeException("Unknown format: " + Format2);
            }
        }

        public B4XBitmapWrapper Resize(int Width, int Height, boolean KeepAspectRatio) {
            BufferedImage bi = SwingFXUtils.fromFXImage((javafx.scene.image.Image)((javafx.scene.image.Image)this.getObject()), null);
            BufferedImage res = Scalr.resize(bi, KeepAspectRatio ? Scalr.Mode.BEST_FIT_BOTH : Scalr.Mode.FIT_EXACT, Width, Height, new BufferedImageOp[0]);
            bi.flush();
            WritableImage i = SwingFXUtils.toFXImage((BufferedImage)res, null);
            res.flush();
            return (B4XBitmapWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XBitmapWrapper(), i);
        }

        public B4XBitmapWrapper Rotate(int Degrees) {
            Degrees = (Degrees + 360) % 360;
            if ((Degrees = Degrees / 90 * 90) == 0) {
                return this;
            }
            Scalr.Rotation r = Scalr.Rotation.valueOf("CW_" + Degrees);
            BufferedImage bi = SwingFXUtils.fromFXImage((javafx.scene.image.Image)((javafx.scene.image.Image)this.getObject()), null);
            BufferedImage res = Scalr.rotate(bi, r, new BufferedImageOp[0]);
            bi.flush();
            WritableImage i = SwingFXUtils.toFXImage((BufferedImage)res, null);
            res.flush();
            return (B4XBitmapWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XBitmapWrapper(), i);
        }

        public B4XBitmapWrapper Crop(int Left, int Top, int Width, int Height) {
            BufferedImage bi = SwingFXUtils.fromFXImage((javafx.scene.image.Image)((javafx.scene.image.Image)this.getObject()), null);
            BufferedImage res = Scalr.crop(bi, Left, Top, (int)Math.min((double)Width, ((javafx.scene.image.Image)this.getObject()).getWidth() - (double)Left), (int)Math.min((double)Height, ((javafx.scene.image.Image)this.getObject()).getHeight() - (double)Top), new BufferedImageOp[0]);
            bi.flush();
            WritableImage i = SwingFXUtils.toFXImage((BufferedImage)res, null);
            res.flush();
            return (B4XBitmapWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XBitmapWrapper(), i);
        }

        public float getScale() {
            return 1.0f;
        }
    }

    @BA.ShortName(value="B4XFont")
    public static class B4XFont
    extends AbsObjectWrapper<Font> {
        public double getSize() {
            return ((Font)this.getObject()).getSize();
        }

        public JFX.FontWrapper ToNativeFont() {
            return (JFX.FontWrapper)AbsObjectWrapper.ConvertToWrapper(new JFX.FontWrapper(), this.getObject());
        }
    }

    @BA.ShortName(value="XUI")
    public static class XUI {
        @BA.Hide
        public static CSSUtils css = new CSSUtils();
        public static final int Color_Black = -16777216;
        public static final int Color_DarkGray = -12303292;
        public static final int Color_Gray = -7829368;
        public static final int Color_LightGray = -3355444;
        public static final int Color_White = -1;
        public static final int Color_Red = -65536;
        public static final int Color_Green = -16711936;
        public static final int Color_Blue = -16776961;
        public static final int Color_Yellow = -256;
        public static final int Color_Cyan = -16711681;
        public static final int Color_Magenta = -65281;
        public static final int Color_Transparent = 0;
        private static String DataFolderName;
        public static final int DialogResponse_Positive = -1;
        public static final int DialogResponse_Cancel = -3;
        public static final int DialogResponse_Negative = -2;

        public static B4XBitmapWrapper LoadBitmap(String Dir, String FileName) throws IOException {
            ImageViewWrapper.ImageWrapper iw = new ImageViewWrapper.ImageWrapper();
            iw.Initialize(Dir, FileName);
            return (B4XBitmapWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XBitmapWrapper(), iw.getObject());
        }

        public static B4XBitmapWrapper LoadBitmapResize(String Dir, String FileName, int Width, int Height, boolean KeepAspectRatio) throws IOException {
            return XUI.LoadBitmap(Dir, FileName).Resize(Width, Height, KeepAspectRatio);
        }

        public static void SetDataFolder(String AppName) {
            DataFolderName = AppName;
        }

        public static String getDefaultFolder() {
            if (DataFolderName == null) {
                throw new RuntimeException("SetDataFolder must be called before using this method.");
            }
            return File.DirData(DataFolderName);
        }

        public static int PaintOrColorToColor(Object Color2) {
            if (Color2 instanceof Paint) {
                return JFX.Colors.To32Bit((Paint)Color2);
            }
            return (Integer)Color2;
        }

        public static boolean SubExists(BA ba, Object Component2, String Sub, int NotUsed) throws IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
            return Common.SubExists(ba, Component2, Sub);
        }

        public static B4XFont CreateFont(Font Font2, float Size) {
            return (B4XFont)AbsObjectWrapper.ConvertToWrapper(new B4XFont(), new Font(Font2.getName(), (double)Size));
        }

        public static B4XFont CreateFont2(B4XFont B4XFont2, float Size) {
            return XUI.CreateFont((Font)B4XFont2.getObject(), Size);
        }

        public static B4XFont CreateFontAwesome(float Size) throws IOException {
            return XUI.CreateFont((Font)JFX.CreateFontAwesome(Size).getObject(), Size);
        }

        public static B4XFont CreateMaterialIcons(float Size) throws IOException {
            return XUI.CreateFont((Font)JFX.CreateMaterialIcons(Size).getObject(), Size);
        }

        public static B4XFont CreateDefaultFont(float Size) {
            return (B4XFont)AbsObjectWrapper.ConvertToWrapper(new B4XFont(), new Font((double)Size));
        }

        public static B4XFont CreateDefaultBoldFont(float Size) {
            return (B4XFont)AbsObjectWrapper.ConvertToWrapper(new B4XFont(), Font.font(null, (FontWeight)FontWeight.BOLD, (double)Size));
        }

        public static boolean getIsB4A() {
            return false;
        }

        public static boolean getIsB4i() {
            return false;
        }

        public static boolean getIsB4J() {
            return true;
        }

        public static float getScale() {
            return 1.0f;
        }

        public static B4XViewWrapper CreatePanel(BA ba, String EventName) {
            PaneWrapper.ConcretePaneWrapper p = new PaneWrapper.ConcretePaneWrapper();
            p.Initialize(ba, EventName);
            final Rectangle clipRectangle = new Rectangle();
            ((Pane)p.getObject()).setClip((Node)clipRectangle);
            ((Pane)p.getObject()).layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> arg0, Bounds arg1, Bounds arg2) {
                    clipRectangle.setWidth(arg2.getWidth());
                    clipRectangle.setHeight(arg2.getHeight());
                }
            });
            return (B4XViewWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XViewWrapper(), p.getObject());
        }

        public static int Color_RGB(int R, int G, int B) {
            return XUI.Color_ARGB(255, R, G, B);
        }

        public static int Color_ARGB(int Alpha, int R, int G, int B) {
            return Alpha << 24 | R << 16 | G << 8 | B;
        }

        public static Object MsgboxAsync(BA ba, String Message, String Title) throws Exception {
            return XUI.Msgbox2AsyncImpl(ba, Message, Title, "OK", "", "", null, Alert.AlertType.INFORMATION);
        }

        public static Object Msgbox2Async(BA ba, String Message, String Title, String Positive, String Cancel, String Negative, javafx.scene.image.Image Icon2) throws Exception {
            return XUI.Msgbox2AsyncImpl(ba, Message, Title, Positive, Cancel, Negative, Icon2, Alert.AlertType.NONE);
        }

        @BA.Hide
        public static Object Msgbox2AsyncImpl(final BA ba, String Message, String Title, String Positive, String Cancel, String Negative, javafx.scene.image.Image Icon2, Alert.AlertType at) throws Exception {
            Stage owner = XUI.findActiveStage();
            final Alert alrt = new Alert(at);
            XUI.setOwnerAndIcon(alrt, owner);
            String[] texts = new String[]{Positive, Cancel, Negative};
            ButtonBar.ButtonData[] datas = new ButtonBar.ButtonData[]{ButtonBar.ButtonData.YES, ButtonBar.ButtonData.CANCEL_CLOSE, ButtonBar.ButtonData.NO};
            final HashMap<ButtonBar.ButtonData, Integer> res = new HashMap<ButtonBar.ButtonData, Integer>();
            res.put(ButtonBar.ButtonData.YES, -1);
            res.put(ButtonBar.ButtonData.CANCEL_CLOSE, -3);
            res.put(ButtonBar.ButtonData.NO, -2);
            alrt.getButtonTypes().clear();
            int i = 0;
            while (i < texts.length) {
                if (texts[i].length() > 0) {
                    alrt.getButtonTypes().add((Object)new ButtonType(texts[i], datas[i]));
                }
                ++i;
            }
            alrt.setTitle(Title);
            alrt.setContentText(Message);
            alrt.setHeaderText("");
            if (Icon2 != null) {
                ImageView iv = new ImageView();
                iv.setImage(Icon2);
                alrt.setGraphic((Node)iv);
            }
            alrt.resultProperty().addListener((ChangeListener)new ChangeListener<ButtonType>(){

                public void changed(ObservableValue<? extends ButtonType> observable, ButtonType oldValue, ButtonType newValue) {
                    ba.raiseEventFromUI(alrt, "msgbox_result", res.get(newValue.getButtonData()));
                }
            });
            alrt.show();
            return alrt;
        }

        @BA.Hide
        public static Stage findActiveStage() throws Exception {
            Stage owner = null;
            Iterable windows = System.getProperty("java.version").startsWith("1.8") ? (Iterable)Class.forName("com.sun.javafx.stage.StageHelper").getMethod("getStages", new Class[0]).invoke(null, new Object[0]) : (Iterable)Class.forName("javafx.stage.Window").getMethod("getWindows", new Class[0]).invoke(null, new Object[0]);
            for (Object win : windows) {
                Stage stg;
                if (!(win instanceof Stage) || (stg = (Stage)win).isIconified()) continue;
                if (stg.isShowing()) {
                    owner = stg;
                }
                if (!stg.isFocused()) continue;
                owner = stg;
                break;
            }
            return owner;
        }

        private static void setOwnerAndIcon(Dialog<?> d, Stage owner) {
            if (owner != null) {
                d.initOwner((Window)owner);
                if (owner.getIcons().size() > 0) {
                    ((Stage)d.getDialogPane().getScene().getWindow()).getIcons().add((Object)((javafx.scene.image.Image)owner.getIcons().get(0)));
                }
            }
        }

        public static String FileUri(String Dir, String FileName) {
            return File.GetUri(Dir, FileName);
        }
    }
}

