/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects.collections;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@BA.ShortName(value="Map")
public class Map
extends AbsObjectWrapper<java.util.Map>
implements BA.B4aDebuggable {
    public void Initialize() {
        this.setObject(new MyMap());
    }

    public Object Put(Object Key, Object Value) {
        return ((java.util.Map)this.getObject()).put(Key, Value);
    }

    public Object Remove(Object Key) {
        return ((java.util.Map)this.getObject()).remove(Key);
    }

    public Object Get(Object Key) {
        return ((java.util.Map)this.getObject()).get(Key);
    }

    public Object GetDefault(Object Key, Object Default) {
        Object res = ((java.util.Map)this.getObject()).get(Key);
        if (res == null) {
            return Default;
        }
        return res;
    }

    public void Clear() {
        ((java.util.Map)this.getObject()).clear();
    }

    public Object GetKeyAt(int Index) {
        java.util.Map m = (java.util.Map)this.getObject();
        if (m instanceof MyMap) {
            return ((MyMap)m).getKey(Index);
        }
        throw new RuntimeException("method not supported. Use For Each instead.");
    }

    public Object GetValueAt(int Index) {
        java.util.Map m = (java.util.Map)this.getObject();
        if (m instanceof MyMap) {
            return ((MyMap)m).getValue(Index);
        }
        throw new RuntimeException("method not supported. Use For Each instead.");
    }

    public int getSize() {
        return ((java.util.Map)this.getObject()).size();
    }

    public boolean ContainsKey(Object Key) {
        return ((java.util.Map)this.getObject()).containsKey(Key);
    }

    public BA.IterableList Keys() {
        return new IterableMap(true);
    }

    public BA.IterableList Values() {
        return new IterableMap(false);
    }

    @Override
    @BA.Hide
    public Object[] debug(int limit, boolean[] outShouldAddReflectionFields) {
        Object[] res = new Object[2 * (1 + Math.min(this.getSize(), limit))];
        res[0] = "Size";
        res[1] = this.getSize();
        int i = 2;
        for (Map.Entry e : ((java.util.Map)this.getObject()).entrySet()) {
            if (i >= res.length - 1) break;
            res[i] = String.valueOf(e.getKey());
            if (res[i].toString().length() == 0) {
                res[i] = "(empty string)";
            }
            res[i + 1] = e.getValue();
            i += 2;
        }
        outShouldAddReflectionFields[0] = false;
        return res;
    }

    @BA.Hide
    public class IterableMap
    implements BA.IterableList {
        private final Iterator iterator;

        public IterableMap(boolean keys) {
            this.iterator = keys ? ((java.util.Map)Map.this.getObject()).keySet().iterator() : ((java.util.Map)Map.this.getObject()).values().iterator();
        }

        @Override
        public int getSize() {
            return Map.this.getSize();
        }

        @Override
        public Object Get(int index) {
            return this.iterator.next();
        }
    }

    @BA.Hide
    public static class MyMap
    implements java.util.Map<Object, Object> {
        protected java.util.Map<Object, Object> innerMap = this.createInnerMap();
        private int iteratorPosition;
        private Iterator<Map.Entry<Object, Object>> iterator;
        private Map.Entry<Object, Object> currentEntry;

        public Object getKey(int index) {
            return this.getEntry(index).getKey();
        }

        public Object getValue(int index) {
            return this.getEntry(index).getValue();
        }

        protected java.util.Map<Object, Object> createInnerMap() {
            return new LinkedHashMap<Object, Object>();
        }

        private Map.Entry<Object, Object> getEntry(int index) {
            if (this.iterator != null && this.iteratorPosition != index) {
                if (this.iteratorPosition == index - 1) {
                    this.currentEntry = this.iterator.next();
                    ++this.iteratorPosition;
                } else {
                    this.iterator = null;
                }
            }
            if (this.iterator == null) {
                this.iterator = this.innerMap.entrySet().iterator();
                int i = 0;
                while (i <= index) {
                    this.currentEntry = this.iterator.next();
                    ++i;
                }
                this.iteratorPosition = index;
            }
            return this.currentEntry;
        }

        @Override
        public void clear() {
            this.iterator = null;
            this.innerMap.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.innerMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.innerMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.innerMap.entrySet();
        }

        @Override
        public Object get(Object key) {
            return this.innerMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.innerMap.isEmpty();
        }

        @Override
        public Set<Object> keySet() {
            return this.innerMap.keySet();
        }

        @Override
        public Object put(Object key, Object value) {
            this.iterator = null;
            return this.innerMap.put(key, value);
        }

        @Override
        public void putAll(java.util.Map<? extends Object, ? extends Object> m) {
            this.iterator = null;
            this.innerMap.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            this.iterator = null;
            return this.innerMap.remove(key);
        }

        @Override
        public int size() {
            return this.innerMap.size();
        }

        @Override
        public Collection<Object> values() {
            return this.innerMap.values();
        }

        public String toString() {
            return this.innerMap.toString();
        }
    }
}

