/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.randomaccessfile;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.streams.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;

@BA.Hide
public class CountingStreams {

    @BA.ShortName(value="CountingInputStream")
    public static class CountingInput
    extends File.InputStreamWrapper {
        public void Initialize(InputStream InputStream2) {
            this.setObject(new MyInputStream(InputStream2));
        }

        @Override
        @BA.Hide
        public void InitializeFromBytesArray(byte[] Buffer2, int StartOffset, int MaxCount) {
        }

        public long getCount() {
            return ((MyInputStream)this.getObject()).counter.get();
        }

        public void setCount(long v) {
            ((MyInputStream)this.getObject()).counter.set(v);
        }
    }

    @BA.ShortName(value="CountingOutputStream")
    public static class CountingOutput
    extends File.OutputStreamWrapper {
        public void Initialize(OutputStream OutputStream2) {
            this.setObject(new MyOutputStream(OutputStream2));
        }

        @Override
        @BA.Hide
        public void InitializeToBytesArray(int StartSize) {
        }

        public long getCount() {
            return ((MyOutputStream)this.getObject()).counter.get();
        }

        public void setCount(long v) {
            ((MyOutputStream)this.getObject()).counter.set(v);
        }
    }

    private static class MyInputStream
    extends FilterInputStream {
        AtomicLong counter = new AtomicLong(0L);

        protected MyInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int r = this.in.read();
            if (r >= 0) {
                this.counter.addAndGet(1L);
            }
            return r;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int count) throws IOException {
            int r = this.in.read(buffer, offset, count);
            if (r > 0) {
                this.counter.addAndGet(r);
            }
            return r;
        }
    }

    private static class MyOutputStream
    extends FilterOutputStream {
        AtomicLong counter = new AtomicLong(0L);

        public MyOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            this.out.write(buffer, offset, count);
            this.counter.addAndGet(count);
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.out.write(oneByte);
            this.counter.addAndGet(1L);
        }
    }
}

