/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.GridBase;
import org.controlsfx.control.spreadsheet.GridChange;
import org.controlsfx.control.spreadsheet.Picker;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetViewSelectionModel;
import org.controlsfx.tools.Utils;

public class SpreadsheetView
extends Control {
    private static final double DEFAULT_ROW_HEADER_WIDTH = 30.0;
    private final SpreadsheetGridView cellsView;
    private SimpleObjectProperty<Grid> gridProperty = new SimpleObjectProperty();
    private DataFormat fmt;
    private final ObservableList<Integer> fixedRows = FXCollections.observableArrayList();
    private final ObservableList<SpreadsheetColumn> fixedColumns = FXCollections.observableArrayList();
    private final BooleanProperty fixingRowsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty fixingColumnsAllowedProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty showColumnHeader = new SimpleBooleanProperty((Object)true, "showColumnHeader", true);
    private final BooleanProperty showRowHeader = new SimpleBooleanProperty((Object)true, "showRowHeader", true);
    private BitSet rowFix;
    private final ObservableMap<Integer, Picker> rowPickers = FXCollections.observableHashMap();
    private final ObservableMap<Integer, Picker> columnPickers = FXCollections.observableHashMap();
    private ObservableList<SpreadsheetColumn> columns = FXCollections.observableArrayList();
    private Map<SpreadsheetCellType<?>, SpreadsheetCellEditor> editors = new IdentityHashMap();
    private final SpreadsheetViewSelectionModel selectionModel;
    private final DoubleProperty rowHeaderWidth = new SimpleDoubleProperty(30.0);
    private final BitSet columnWidthSet = new BitSet();
    final SpreadsheetHandle handle = new SpreadsheetHandle(){

        @Override
        protected SpreadsheetView getView() {
            return SpreadsheetView.this;
        }

        @Override
        protected GridViewSkin getCellsViewSkin() {
            return SpreadsheetView.this.getCellsViewSkin();
        }

        @Override
        protected SpreadsheetGridView getGridView() {
            return SpreadsheetView.this.getCellsView();
        }

        @Override
        protected boolean isColumnWidthSet(int indexColumn) {
            return SpreadsheetView.this.columnWidthSet.get(indexColumn);
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            while (c.next()) {
                if (c.wasAdded()) {
                    List newRows = c.getAddedSubList();
                    if (!SpreadsheetView.this.areRowsFixable(newRows)) {
                        throw new IllegalArgumentException(SpreadsheetView.this.computeReason(newRows));
                    }
                    FXCollections.sort((ObservableList)SpreadsheetView.this.fixedRows);
                }
                if (!c.wasRemoved()) continue;
            }
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> c) {
            while (c.next()) {
                List newColumns;
                if (!c.wasAdded() || SpreadsheetView.this.areSpreadsheetColumnsFixable(newColumns = c.getAddedSubList())) continue;
                ArrayList<Integer> newList = new ArrayList<Integer>();
                for (SpreadsheetColumn column : newColumns) {
                    if (column == null) continue;
                    newList.add(SpreadsheetView.this.columns.indexOf((Object)column));
                }
                throw new IllegalArgumentException(this.computeReason(newList));
            }
        }

        private String computeReason(List<Integer> list) {
            String reason = "\n This column cannot be fixed.";
            ObservableList<ObservableList<SpreadsheetCell>> rows = SpreadsheetView.this.getGrid().getRows();
            for (Integer columnIndex : list) {
                if (SpreadsheetView.this.isColumnFixable(columnIndex)) continue;
                int maxSpan = 1;
                for (List row : rows) {
                    SpreadsheetCell cell = (SpreadsheetCell)row.get(columnIndex);
                    if (!list.contains(cell.getColumn())) {
                        reason = reason + "The column " + columnIndex + " is inside a column span and the starting column " + cell.getColumn() + " is not fixed.\n";
                    }
                    if (cell.getColumnSpan() <= maxSpan || cell.getColumn() != columnIndex.intValue()) continue;
                    maxSpan = cell.getColumnSpan();
                }
                int count = columnIndex + maxSpan - 1;
                for (int index = columnIndex + 1; index < count; ++index) {
                    if (list.contains(index)) continue;
                    reason = reason + "One cell on the column " + columnIndex + " has a column span of " + maxSpan + ". " + "But the column " + index + " contained within that span is not fixed.\n";
                }
            }
            return reason;
        }
    };
    private final ChangeListener<ContextMenu> contextMenuChangeListener = new ChangeListener<ContextMenu>(){

        public void changed(ObservableValue<? extends ContextMenu> arg0, ContextMenu oldContextMenu, ContextMenu newContextMenu) {
            if (oldContextMenu != null) {
                oldContextMenu.setOnShowing(null);
            }
            if (newContextMenu != null) {
                newContextMenu.setOnShowing((EventHandler)new WeakEventHandler(SpreadsheetView.this.hideContextMenuEventHandler));
            }
        }
    };
    private final EventHandler<WindowEvent> hideContextMenuEventHandler = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent arg0) {
            if (SpreadsheetView.this.getEditingCell() != null) {
                Platform.runLater(() -> SpreadsheetView.this.getContextMenu().hide());
            }
        }
    };
    private final EventHandler<KeyEvent> keyPressedHandler = keyEvent -> {
        TablePosition position = this.getSelectionModel().getFocusedCell();
        if (this.getEditingCell() == null && KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
            if (position != null) {
                if (keyEvent.isShiftDown()) {
                    this.getSelectionModel().clearAndSelectPreviousCell();
                } else {
                    this.getSelectionModel().clearAndSelectNextCell();
                }
                keyEvent.consume();
            }
            this.getCellsViewSkin().scrollHorizontally();
        } else if (this.getEditingCell() == null && KeyCode.TAB.equals((Object)keyEvent.getCode())) {
            if (position != null) {
                if (keyEvent.isShiftDown()) {
                    this.getSelectionModel().clearAndSelectLeftCell();
                } else {
                    this.getSelectionModel().clearAndSelectRightCell();
                }
            }
            keyEvent.consume();
            this.getCellsViewSkin().scrollHorizontally();
        } else if (KeyCode.DELETE.equals((Object)keyEvent.getCode())) {
            this.deleteSelectedCells();
        } else if (keyEvent.getCode() != KeyCode.SHIFT && !keyEvent.isShortcutDown() && !keyEvent.getCode().isNavigationKey() && keyEvent.getCode() != KeyCode.ESCAPE) {
            this.getCellsView().edit(position.getRow(), position.getTableColumn());
        }
    };

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    final SpreadsheetGridView getCellsView() {
        return this.cellsView;
    }

    void columnWidthSet(int indexColumn) {
        this.columnWidthSet.set(indexColumn);
    }

    public SpreadsheetView() {
        this(SpreadsheetView.getSampleGrid());
        for (SpreadsheetColumn column : this.getColumns()) {
            column.setPrefWidth(100.0);
        }
    }

    public SpreadsheetView(Grid grid) {
        this.addEventHandler(RowHeightEvent.ROW_HEIGHT_CHANGE, event -> {
            if (this.getFixedRows().contains((Object)event.getRow()) && this.getCellsViewSkin() != null) {
                this.getCellsViewSkin().computeFixedRowHeight();
            }
        });
        this.getStyleClass().add((Object)"SpreadsheetView");
        this.setSkin((Skin)new Skin<SpreadsheetView>(){

            public Node getNode() {
                return SpreadsheetView.this.getCellsView();
            }

            public SpreadsheetView getSkinnable() {
                return SpreadsheetView.this;
            }

            public void dispose() {
            }
        });
        this.cellsView = new SpreadsheetGridView(this.handle);
        this.getChildren().add((Object)this.cellsView);
        TableViewSpanSelectionModel tableViewSpanSelectionModel = new TableViewSpanSelectionModel(this, this.cellsView);
        this.cellsView.setSelectionModel(tableViewSpanSelectionModel);
        tableViewSpanSelectionModel.setCellSelectionEnabled(true);
        tableViewSpanSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.selectionModel = new SpreadsheetViewSelectionModel(this, tableViewSpanSelectionModel);
        this.cellsView.getFocusModel().focusedCellProperty().addListener((ChangeListener)new FocusModelListener(this, this.cellsView));
        this.cellsView.setOnKeyPressed(this.keyPressedHandler);
        this.contextMenuProperty().addListener((ChangeListener)new WeakChangeListener(this.contextMenuChangeListener));
        CellView.getValue(() -> this.setContextMenu(this.getSpreadsheetViewContextMenu()));
        this.setGrid(grid);
        this.setEditable(true);
        this.fixedRows.addListener(this.fixedRowsListener);
        this.fixedColumns.addListener(this.fixedColumnsListener);
    }

    public final void setGrid(Grid grid) {
        if (grid == null) {
            return;
        }
        this.gridProperty.set((Object)grid);
        this.initRowFix(grid);
        ArrayList<Integer> newFixedRows = new ArrayList<Integer>();
        for (Object rowFixed : this.getFixedRows()) {
            if (!this.isRowFixable((Integer)rowFixed)) continue;
            newFixedRows.add((Integer)rowFixed);
        }
        this.getFixedRows().setAll(newFixedRows);
        ArrayList<Integer> columnsFixed = new ArrayList<Integer>();
        for (Object column : this.getFixedColumns()) {
            columnsFixed.add(this.getColumns().indexOf(column));
        }
        this.getFixedColumns().clear();
        ArrayList<Double> widthColumns = new ArrayList<Double>();
        for (SpreadsheetColumn column : this.columns) {
            widthColumns.add(column.getWidth());
        }
        Pair focusedPair = null;
        TablePosition focusedCell = this.cellsView.getFocusModel().getFocusedCell();
        if (focusedCell != null && focusedCell.getRow() != -1 && focusedCell.getColumn() != -1) {
            focusedPair = new Pair((Object)focusedCell.getRow(), (Object)focusedCell.getColumn());
        }
        Pair finalPair = focusedPair;
        if (grid.getRows() != null) {
            ObservableList observableRows = FXCollections.observableArrayList(grid.getRows());
            this.cellsView.getItems().clear();
            this.cellsView.setItems(observableRows);
            int columnCount = grid.getColumnCount();
            this.columns.clear();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                SpreadsheetColumn spreadsheetColumn = new SpreadsheetColumn(this.getTableColumn(grid, columnIndex), this, columnIndex, grid);
                if (widthColumns.size() > columnIndex) {
                    spreadsheetColumn.setPrefWidth((Double)widthColumns.get(columnIndex));
                }
                this.columns.add((Object)spreadsheetColumn);
                if (!columnsFixed.contains(columnIndex) || !spreadsheetColumn.isColumnFixable()) continue;
                spreadsheetColumn.setFixed(true);
            }
        }
        ArrayList<Pair> selectedCells = new ArrayList<Pair>();
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            selectedCells.add(new Pair((Object)position.getRow(), (Object)position.getColumn()));
        }
        Runnable runnable = () -> {
            if (this.cellsView.getColumns().size() > grid.getColumnCount()) {
                this.cellsView.getColumns().remove(grid.getColumnCount(), this.cellsView.getColumns().size());
            } else if (this.cellsView.getColumns().size() < grid.getColumnCount()) {
                for (int i = this.cellsView.getColumns().size(); i < grid.getColumnCount(); ++i) {
                    this.cellsView.getColumns().add(((SpreadsheetColumn)this.columns.get((int)i)).column);
                }
            }
            ((TableViewSpanSelectionModel)this.cellsView.getSelectionModel()).verifySelectedCells(selectedCells);
            if (finalPair != null && (Integer)finalPair.getKey() < this.getGrid().getRowCount() && (Integer)finalPair.getValue() < this.getGrid().getColumnCount()) {
                this.cellsView.getFocusModel().focus(((Integer)finalPair.getKey()).intValue(), (TableColumn)this.cellsView.getColumns().get(((Integer)finalPair.getValue()).intValue()));
            }
        };
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            try {
                FutureTask<Object> future = new FutureTask<Object>(runnable, null);
                Platform.runLater(future);
                future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(SpreadsheetView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> getEditingCell() {
        return this.cellsView.getEditingCell();
    }

    public ReadOnlyObjectProperty<TablePosition<ObservableList<SpreadsheetCell>, ?>> editingCellProperty() {
        return this.cellsView.editingCellProperty();
    }

    public final ObservableList<SpreadsheetColumn> getColumns() {
        return this.columns;
    }

    public final Grid getGrid() {
        return (Grid)this.gridProperty.get();
    }

    public final ReadOnlyObjectProperty<Grid> gridProperty() {
        return this.gridProperty;
    }

    public ObservableList<Integer> getFixedRows() {
        return this.fixedRows;
    }

    public boolean isRowFixable(int row) {
        return row >= 0 && row < this.rowFix.size() && this.isFixingRowsAllowed() ? this.rowFix.get(row) : false;
    }

    public boolean areRowsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isFixingRowsAllowed()) {
            return false;
        }
        Grid grid = this.getGrid();
        int rowCount = grid.getRowCount();
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        for (Integer n : list) {
            if (n == null || n < 0 || n >= rowCount) {
                return false;
            }
            if (this.isRowFixable(n)) continue;
            int maxSpan = 1;
            List gridRow = (List)rows.get(n.intValue());
            for (SpreadsheetCell cell : gridRow) {
                if (!list.contains(cell.getRow())) {
                    return false;
                }
                if (cell.getRowSpan() <= maxSpan || cell.getRow() != n.intValue()) continue;
                maxSpan = cell.getRowSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index <= count; ++index) {
                if (list.contains(index)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFixingRowsAllowed() {
        return this.fixingRowsAllowedProperty.get();
    }

    public void setFixingRowsAllowed(boolean b) {
        this.fixingRowsAllowedProperty.set(b);
    }

    public ReadOnlyBooleanProperty fixingRowsAllowedProperty() {
        return this.fixingRowsAllowedProperty;
    }

    public ObservableList<SpreadsheetColumn> getFixedColumns() {
        return this.fixedColumns;
    }

    public boolean isColumnFixable(int columnIndex) {
        return columnIndex >= 0 && columnIndex < this.getColumns().size() && this.isFixingColumnsAllowed() ? ((SpreadsheetColumn)this.getColumns().get(columnIndex)).isColumnFixable() : false;
    }

    public boolean areSpreadsheetColumnsFixable(List<? extends SpreadsheetColumn> list) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (SpreadsheetColumn spreadsheetColumn : list) {
            if (spreadsheetColumn == null) continue;
            newList.add(this.columns.indexOf((Object)spreadsheetColumn));
        }
        return this.areColumnsFixable(newList);
    }

    public boolean areColumnsFixable(List<? extends Integer> list) {
        if (list == null || list.isEmpty() || !this.isFixingRowsAllowed()) {
            return false;
        }
        Grid grid = this.getGrid();
        int columnCount = grid.getColumnCount();
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        for (Integer n : list) {
            if (n == null || n < 0 || n >= columnCount) {
                return false;
            }
            if (this.isColumnFixable(n)) continue;
            int maxSpan = 1;
            for (List row : rows) {
                SpreadsheetCell cell = (SpreadsheetCell)row.get(n);
                if (!list.contains(cell.getColumn())) {
                    return false;
                }
                if (cell.getColumnSpan() <= maxSpan || cell.getColumn() != n.intValue()) continue;
                maxSpan = cell.getColumnSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index <= count; ++index) {
                if (list.contains(index)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFixingColumnsAllowed() {
        return this.fixingColumnsAllowedProperty.get();
    }

    public void setFixingColumnsAllowed(boolean b) {
        this.fixingColumnsAllowedProperty.set(b);
    }

    public ReadOnlyBooleanProperty fixingColumnsAllowedProperty() {
        return this.fixingColumnsAllowedProperty;
    }

    public final void setShowColumnHeader(boolean b) {
        this.showColumnHeader.setValue(Boolean.valueOf(b));
    }

    public final boolean isShowColumnHeader() {
        return this.showColumnHeader.get();
    }

    public final BooleanProperty showColumnHeaderProperty() {
        return this.showColumnHeader;
    }

    public final void setShowRowHeader(boolean b) {
        this.showRowHeader.setValue(Boolean.valueOf(b));
    }

    public final boolean isShowRowHeader() {
        return this.showRowHeader.get();
    }

    public final BooleanProperty showRowHeaderProperty() {
        return this.showRowHeader;
    }

    public final DoubleProperty rowHeaderWidthProperty() {
        return this.rowHeaderWidth;
    }

    public final void setRowHeaderWidth(double value) {
        this.rowHeaderWidth.setValue((Number)value);
    }

    public final double getRowHeaderWidth() {
        return this.rowHeaderWidth.get();
    }

    public ObservableMap<Integer, Picker> getRowPickers() {
        return this.rowPickers;
    }

    public ObservableMap<Integer, Picker> getColumnPickers() {
        return this.columnPickers;
    }

    public void resizeRowsToFitContent() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToFitContent();
        }
    }

    public void resizeRowsToMaximum() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToMaximum();
        }
    }

    public void resizeRowsToDefault() {
        if (this.getCellsViewSkin() != null) {
            this.getCellsViewSkin().resizeRowsToDefault();
        }
    }

    public double getRowHeight(int row) {
        if (this.getCellsViewSkin() == null) {
            return this.getGrid().getRowHeight(row);
        }
        return this.getCellsViewSkin().getRowHeight(row);
    }

    public SpreadsheetViewSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void scrollToRow(int row) {
        this.cellsView.scrollTo(row);
    }

    public void setVBarValue(double value) {
        if (this.getCellsViewSkin() == null) {
            Platform.runLater(() -> this.setVBarValue(value));
            return;
        }
        this.getCellsViewSkin().getVBar().setValue(value);
    }

    public void setHBarValue(double value) {
        this.setHBarValue(value, 0);
    }

    private void setHBarValue(double value, int attempt) {
        if (attempt > 10) {
            return;
        }
        if (this.getCellsViewSkin() == null) {
            int newAttempt = ++attempt;
            Platform.runLater(() -> this.setHBarValue(value, newAttempt));
            return;
        }
        this.getCellsViewSkin().setHbarValue(value);
    }

    public double getVBarValue() {
        if (this.getCellsViewSkin() != null && this.getCellsViewSkin().getVBar() != null) {
            return this.getCellsViewSkin().getVBar().getValue();
        }
        return 0.0;
    }

    public double getHBarValue() {
        if (this.getCellsViewSkin() != null && this.getCellsViewSkin().getHBar() != null) {
            return this.getCellsViewSkin().getHBar().getValue();
        }
        return 0.0;
    }

    public void scrollToColumn(SpreadsheetColumn column) {
        this.cellsView.scrollToColumn(column.column);
    }

    public void scrollToColumnIndex(int columnIndex) {
        this.cellsView.scrollToColumnIndex(columnIndex);
    }

    public final Optional<SpreadsheetCellEditor> getEditor(SpreadsheetCellType<?> cellType) {
        if (cellType == null) {
            return Optional.empty();
        }
        SpreadsheetCellEditor cellEditor = this.editors.get(cellType);
        if (cellEditor == null) {
            cellEditor = cellType.createEditor(this);
            if (cellEditor == null) {
                return Optional.empty();
            }
            this.editors.put(cellType, cellEditor);
        }
        return Optional.of(cellEditor);
    }

    public final void setEditable(boolean b) {
        this.cellsView.setEditable(b);
    }

    public final boolean isEditable() {
        return this.cellsView.isEditable();
    }

    public final BooleanProperty editableProperty() {
        return this.cellsView.editableProperty();
    }

    public void copyClipboard() {
        this.checkFormat();
        ArrayList<GridChange> list = new ArrayList<GridChange>();
        ObservableList<TablePosition> posList = this.getSelectionModel().getSelectedCells();
        for (TablePosition p : posList) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(p.getRow())).get(p.getColumn());
            for (int row = 0; row < cell.getRowSpan(); ++row) {
                for (int col = 0; col < cell.getColumnSpan(); ++col) {
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(cell.getItem());
                        list.add(new GridChange(cell.getRow() + row, cell.getColumn() + col, null, cell.getItem() == null ? null : cell.getItem()));
                        continue;
                    }
                    catch (IOException exception) {
                        list.add(new GridChange(cell.getRow() + row, cell.getColumn() + col, null, cell.getItem() == null ? null : cell.getItem().toString()));
                    }
                }
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.put((Object)this.fmt, list);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void pasteOneValue(GridChange change) {
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            this.tryPasteCell(position.getRow(), position.getColumn(), change.getNewValue());
        }
    }

    private void tryPasteCell(int row, int column, Object value) {
        SpreadsheetCell cell;
        boolean succeed;
        SpanType type = this.getSpanType(row, column);
        if ((type == SpanType.NORMAL_CELL || type == SpanType.ROW_VISIBLE) && (succeed = (cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(row)).get(column)).getCellType().match(value))) {
            this.getGrid().setCellValue(cell.getRow(), cell.getColumn(), cell.getCellType().convertValue(value));
        }
    }

    private void pasteMixedValues(ArrayList<GridChange> list) {
        block8: {
            RectangleSelection.SelectionRange sourceSelectionRange = new RectangleSelection.SelectionRange();
            sourceSelectionRange.fillGridRange(list);
            if (sourceSelectionRange.getRange() == null) break block8;
            RectangleSelection.SelectionRange targetSelectionRange = new RectangleSelection.SelectionRange();
            targetSelectionRange.fill((List<TablePosition>)this.cellsView.getSelectionModel().getSelectedCells());
            if (targetSelectionRange.getRange() != null) {
                RectangleSelection.GridRange sourceRange = sourceSelectionRange.getRange();
                RectangleSelection.GridRange targetRange = targetSelectionRange.getRange();
                int sourceRowGap = sourceRange.getBottom() - sourceRange.getTop() + 1;
                int targetRowGap = targetRange.getBottom() - targetRange.getTop() + 1;
                int sourceColumnGap = sourceRange.getRight() - sourceRange.getLeft() + 1;
                int targetColumnGap = targetRange.getRight() - targetRange.getLeft() + 1;
                int offsetRow = targetRange.getTop() - sourceRange.getTop();
                int offsetCol = targetRange.getLeft() - sourceRange.getLeft();
                if ((sourceRowGap == targetRowGap || targetRowGap == 1) && targetColumnGap % sourceColumnGap == 0) {
                    for (GridChange change : list) {
                        int row = change.getRow() + offsetRow;
                        int column = change.getColumn() + offsetCol;
                        do {
                            if (row >= this.getGrid().getRowCount() || column >= this.getGrid().getColumnCount() || row < 0 || column < 0) continue;
                            this.tryPasteCell(row, column, change.getNewValue());
                        } while ((column += sourceColumnGap) <= targetRange.getRight());
                    }
                } else if ((sourceColumnGap == targetColumnGap || targetColumnGap == 1) && targetRowGap % sourceRowGap == 0) {
                    for (GridChange change : list) {
                        int row = change.getRow() + offsetRow;
                        int column = change.getColumn() + offsetCol;
                        do {
                            if (row >= this.getGrid().getRowCount() || column >= this.getGrid().getColumnCount() || row < 0 || column < 0) continue;
                            this.tryPasteCell(row, column, change.getNewValue());
                        } while ((row += sourceRowGap) <= targetRange.getBottom());
                    }
                }
            }
        }
    }

    private void pasteSeveralValues(ArrayList<GridChange> list) {
        int minRow = this.getGrid().getRowCount();
        int minCol = this.getGrid().getColumnCount();
        int maxRow = 0;
        int maxCol = 0;
        for (GridChange p : list) {
            int tempcol = p.getColumn();
            int temprow = p.getRow();
            if (tempcol < minCol) {
                minCol = tempcol;
            }
            if (tempcol > maxCol) {
                maxCol = tempcol;
            }
            if (temprow < minRow) {
                minRow = temprow;
            }
            if (temprow <= maxRow) continue;
            maxRow = temprow;
        }
        TablePosition p = this.cellsView.getFocusModel().getFocusedCell();
        int offsetRow = p.getRow() - minRow;
        int offsetCol = p.getColumn() - minCol;
        int rowCount = this.getGrid().getRowCount();
        int columnCount = this.getGrid().getColumnCount();
        for (GridChange change : list) {
            int row = change.getRow() + offsetRow;
            int column = change.getColumn() + offsetCol;
            if (row >= rowCount || column >= columnCount || row < 0 || column < 0) continue;
            this.tryPasteCell(row, column, change.getNewValue());
        }
    }

    public void pasteClipboard() {
        ObservableList selectedCells = this.cellsView.getSelectionModel().getSelectedCells();
        if (!this.isEditable() || selectedCells.isEmpty()) {
            return;
        }
        this.checkFormat();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.getContent(this.fmt) != null) {
            ArrayList list = (ArrayList)clipboard.getContent(this.fmt);
            if (list.size() == 1) {
                this.pasteOneValue((GridChange)list.get(0));
            } else if (selectedCells.size() > 1) {
                this.pasteMixedValues(list);
            } else {
                this.pasteSeveralValues(list);
            }
        } else if (clipboard.hasString()) {
            // empty if block
        }
    }

    public ContextMenu getSpreadsheetViewContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copyItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.copy")));
        copyItem.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("copySpreadsheetView.png"))));
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copyItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SpreadsheetView.this.copyClipboard();
            }
        });
        MenuItem pasteItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.paste")));
        pasteItem.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("pasteSpreadsheetView.png"))));
        pasteItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        pasteItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SpreadsheetView.this.pasteClipboard();
            }
        });
        Menu cornerMenu = new Menu(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment")));
        cornerMenu.setGraphic((Node)new ImageView(new Image(SpreadsheetView.class.getResourceAsStream("comment.png"))));
        MenuItem topLeftItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-left")));
        topLeftItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.TOP_LEFT);
            }
        });
        MenuItem topRightItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.top-right")));
        topRightItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.TOP_RIGHT);
            }
        });
        MenuItem bottomRightItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-right")));
        bottomRightItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_RIGHT);
            }
        });
        MenuItem bottomLeftItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.view.menu.comment.bottom-left")));
        bottomLeftItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TablePosition pos = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.getGrid().getRows().get(pos.getRow())).get(pos.getColumn());
                cell.activateCorner(SpreadsheetCell.CornerPosition.BOTTOM_LEFT);
            }
        });
        cornerMenu.getItems().addAll((Object[])new MenuItem[]{topLeftItem, topRightItem, bottomRightItem, bottomLeftItem});
        contextMenu.getItems().addAll((Object[])new MenuItem[]{copyItem, pasteItem, cornerMenu});
        return contextMenu;
    }

    public void deleteSelectedCells() {
        for (TablePosition position : this.getSelectionModel().getSelectedCells()) {
            this.getGrid().setCellValue(position.getRow(), position.getColumn(), null);
        }
    }

    public SpanType getSpanType(int row, int column) {
        if (this.getGrid() == null) {
            return SpanType.NORMAL_CELL;
        }
        return this.getGrid().getSpanType(this, row, column);
    }

    private TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> getTableColumn(Grid grid, int columnIndex) {
        TableColumn column;
        String columnHeader;
        String string = columnHeader = grid.getColumnHeaders().size() > columnIndex ? (String)grid.getColumnHeaders().get(columnIndex) : Utils.getExcelLetterFromNumber(columnIndex);
        if (columnIndex < this.cellsView.getColumns().size()) {
            column = (TableColumn)this.cellsView.getColumns().get(columnIndex);
            column.setText(columnHeader);
        } else {
            column = new TableColumn(columnHeader);
            column.setEditable(true);
            column.setSortable(false);
            column.impl_setReorderable(false);
            column.setCellValueFactory(p -> {
                if (columnIndex >= ((ObservableList)p.getValue()).size()) {
                    return null;
                }
                return new ReadOnlyObjectWrapper(((ObservableList)p.getValue()).get(columnIndex));
            });
            column.setCellFactory(p -> new CellView(this.handle));
        }
        return column;
    }

    private static Grid getSampleGrid() {
        GridBase gridBase = new GridBase(100, 15);
        ObservableList rows = FXCollections.observableArrayList();
        for (int row = 0; row < gridBase.getRowCount(); ++row) {
            ObservableList currentRow = FXCollections.observableArrayList();
            for (int column = 0; column < gridBase.getColumnCount(); ++column) {
                currentRow.add((Object)SpreadsheetCellType.STRING.createCell(row, column, 1, 1, "toto"));
            }
            rows.add(currentRow);
        }
        gridBase.setRows((Collection<ObservableList<SpreadsheetCell>>)rows);
        return gridBase;
    }

    private void initRowFix(Grid grid) {
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        this.rowFix = new BitSet(rows.size());
        block0: for (int r = 0; r < rows.size(); ++r) {
            ObservableList row = (ObservableList)rows.get(r);
            for (SpreadsheetCell cell : row) {
                if (cell.getRowSpan() <= 1) continue;
                continue block0;
            }
            this.rowFix.set(r);
        }
    }

    private void verifyGrid(Grid grid) {
        this.verifyColumnSpan(grid);
    }

    private void verifyColumnSpan(Grid grid) {
        for (int i = 0; i < grid.getRows().size(); ++i) {
            ObservableList row = (ObservableList)grid.getRows().get(i);
            int count = 0;
            for (int j = 0; j < row.size(); ++j) {
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() == 1) {
                    ++count;
                    continue;
                }
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() > 1) {
                    ++count;
                    SpreadsheetCell currentCell = (SpreadsheetCell)row.get(j);
                    for (int k = j + 1; k < currentCell.getColumn() + currentCell.getColumnSpan(); ++k) {
                        if (!((SpreadsheetCell)row.get(k)).equals(currentCell)) {
                            throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell is in the range of a columnSpan but is different. \n" + "Every cell in a range of a ColumnSpan must be of the same instance.");
                        }
                        ++count;
                        ++j;
                    }
                    continue;
                }
                throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell has a negative columnSpan");
            }
            if (count == grid.getColumnCount()) continue;
            throw new IllegalStateException("The row" + i + " has a number of cells different of the columnCount declared in the grid.");
        }
    }

    private void checkFormat() {
        this.fmt = DataFormat.lookupMimeType((String)"SpreadsheetView");
        if (this.fmt == null) {
            this.fmt = new DataFormat(new String[]{"SpreadsheetView"});
        }
    }

    private String computeReason(List<? extends Integer> list) {
        String reason = "\n A row cannot be fixed. \n";
        for (Integer n : list) {
            if (this.isRowFixable(n)) continue;
            int maxSpan = 1;
            List gridRow = (List)this.getGrid().getRows().get(n.intValue());
            for (SpreadsheetCell cell : gridRow) {
                if (!list.contains(cell.getRow())) {
                    reason = reason + "The row " + n + " is inside a row span and the starting row " + cell.getRow() + " is not fixed.\n";
                }
                if (cell.getRowSpan() <= maxSpan || cell.getRow() != n.intValue()) continue;
                maxSpan = cell.getRowSpan();
            }
            int count = n + maxSpan - 1;
            for (int index = n + 1; index < count; ++index) {
                if (list.contains(index)) continue;
                reason = reason + "One cell on the row " + n + " has a row span of " + maxSpan + ". " + "But the row " + index + " contained within that span is not fixed.\n";
            }
        }
        return reason;
    }

    public static class ColumnWidthEvent
    extends Event {
        public static final EventType<ColumnWidthEvent> COLUMN_WIDTH_CHANGE = new EventType(Event.ANY, "ColumnWidthChange");
        private final int column;
        private final double width;

        public ColumnWidthEvent(int column, double width) {
            super(COLUMN_WIDTH_CHANGE);
            this.column = column;
            this.width = width;
        }

        public int getColumn() {
            return this.column;
        }

        public double getWidth() {
            return this.width;
        }
    }

    public static class RowHeightEvent
    extends Event {
        public static final EventType<RowHeightEvent> ROW_HEIGHT_CHANGE = new EventType(Event.ANY, "RowHeightChange");
        private final int row;
        private final double height;

        public RowHeightEvent(int row, double height) {
            super(ROW_HEIGHT_CHANGE);
            this.row = row;
            this.height = height;
        }

        public int getRow() {
            return this.row;
        }

        public double getHeight() {
            return this.height;
        }
    }

    public static enum SpanType {
        NORMAL_CELL,
        COLUMN_SPAN_INVISIBLE,
        ROW_SPAN_INVISIBLE,
        ROW_VISIBLE,
        BOTH_INVISIBLE;

    }
}

