/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.object;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.CanvasWrapper;
import anywheresoftware.b4j.objects.Form;
import java.util.HashMap;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.media.AudioClip;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

@BA.ShortName(value="GameViewHelper")
@BA.Version(value=1.0f)
public class GameViewHelper {
    public static final int FLIP_NONE = 0;
    public static final int FLIP_VERTICALLY = 1;
    public static final int FLIP_HORIZONTALLY = 2;
    public static final int FLIP_BOTH = 3;
    private HashMap<Integer, AudioClip> sounds = new HashMap();

    public void SetBoxBlur(CanvasWrapper Canvas2) {
        GraphicsContext gc = ((Canvas)Canvas2.getObject()).getGraphicsContext2D();
        BoxBlur blur = new BoxBlur();
        blur.setWidth(1.0);
        blur.setHeight(1.0);
        blur.setIterations(1);
        gc.setEffect((Effect)blur);
    }

    public int LoadAudioClip(String Uri) {
        AudioClip ac = new AudioClip(Uri);
        this.sounds.put(this.sounds.size() + 1, ac);
        return this.sounds.size();
    }

    public void PlayAudioClip(int Id, double Volume) {
        AudioClip ac = this.sounds.get(Id);
        ac.play(Volume);
    }

    public void DrawImageRotateAndFlipped(CanvasWrapper Canvas2, Image Image2, Rect SrcRect, Rect DestRect, double Degree, int Flip) {
        GraphicsContext gc = ((Canvas)Canvas2.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            Object r = null;
            if (Degree != 0.0) {
                r = new Rotate(Degree, DestRect.getCenterX(), DestRect.getCenterY());
            }
            if (Flip != 0) {
                Scale s = new Scale((double)((Flip & 2) == 2 ? -1 : 1), (double)((Flip & 1) == 1 ? -1 : 1), DestRect.getCenterX(), DestRect.getCenterY());
                r = r == null ? s : r.createConcatenation((Transform)s);
            }
            if (r != null) {
                gc.setTransform(r.getMxx(), r.getMyx(), r.getMxy(), r.getMyy(), r.getTx(), r.getTy());
            }
            gc.drawImage(Image2, SrcRect.Left, SrcRect.Top, SrcRect.Width, SrcRect.Height, DestRect.Left, DestRect.Top, DestRect.Width, DestRect.Height);
        }
        finally {
            gc.restore();
        }
    }

    public void AddKeyListener(final BA ba, String EventName, Form Form2) {
        final String eventName = EventName.toLowerCase(BA.cul);
        Form2.scene.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                Boolean b = null;
                if (ke.getEventType() == KeyEvent.KEY_PRESSED) {
                    b = (Boolean)ba.raiseEvent(GameViewHelper.this, String.valueOf(eventName) + "_keypressed", ke.getCode().getName());
                } else if (ke.getEventType() == KeyEvent.KEY_RELEASED) {
                    b = (Boolean)ba.raiseEvent(GameViewHelper.this, String.valueOf(eventName) + "_keyreleased", ke.getCode().getName());
                }
                if (b != null && b.booleanValue()) {
                    ke.consume();
                }
            }
        });
    }

    @BA.ShortName(value="Rect")
    public static class Rect {
        public double Left;
        public double Top;
        public double Width;
        public double Height;

        public void Initialize(double Left, double Top, double Width, double Height) {
            this.Left = Left;
            this.Top = Top;
            this.Width = Width;
            this.Height = Height;
        }

        public double getCenterX() {
            return this.Left + this.Width / 2.0;
        }

        public double getCenterY() {
            return this.Top + this.Height / 2.0;
        }

        public double getRight() {
            return this.Left + this.Width;
        }

        public double getBottom() {
            return this.Top + this.Height;
        }
    }
}

