/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.B4XViewWrapper;
import anywheresoftware.b4j.objects.CanvasWrapper;
import anywheresoftware.b4j.objects.JFX;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.reflect.Field;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;

@BA.ShortName(value="B4XCanvas")
public class B4XCanvas {
    @BA.Hide
    public CanvasWrapper cvs;
    private B4XRect targetRect;

    public void Initialize(BA ba, B4XViewWrapper Pane2) {
        this.cvs = new CanvasWrapper();
        this.cvs.Initialize(ba, "");
        Pane2.AddView((Node)this.cvs.getObject(), 0.0, 0.0, Pane2.getWidth(), Pane2.getHeight());
        ((Canvas)this.cvs.getObject()).toBack();
        this.targetRect = new B4XRect();
        this.targetRect.Initialize(0.0f, 0.0f, (float)this.cvs.getWidth(), (float)this.cvs.getHeight());
    }

    public void Resize(double Width, double Height) {
        this.cvs.SetSize(Width, Height);
        this.targetRect.right = (float)Width;
        this.targetRect.bottom = (float)Height;
    }

    public B4XRect getTargetRect() {
        return this.targetRect;
    }

    public B4XViewWrapper getTargetView() {
        return (B4XViewWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XViewWrapper(), ((Canvas)this.cvs.getObject()).getParent());
    }

    public void Invalidate() {
    }

    public void DrawLine(float x1, float y1, float x2, float y2, int Color2, float StrokeWidth) {
        this.cvs.DrawLine(x1, y1, x2, y2, (Paint)JFX.Colors.From32Bit(Color2), StrokeWidth);
    }

    public B4XViewWrapper.B4XBitmapWrapper CreateBitmap() {
        return (B4XViewWrapper.B4XBitmapWrapper)AbsObjectWrapper.ConvertToWrapper(new B4XViewWrapper.B4XBitmapWrapper(), this.cvs.Snapshot2(JFX.Colors.Transparent).getObject());
    }

    public void DrawRect(B4XRect Rect2, int Color2, boolean Filled, float StrokeWidth) {
        this.cvs.DrawRect(Rect2.left, Rect2.top, Rect2.getWidth(), Rect2.getHeight(), (Paint)JFX.Colors.From32Bit(Color2), Filled, StrokeWidth);
    }

    public void DrawCircle(float x, float y, float Radius, int Color2, boolean Filled, float StrokeWidth) {
        this.cvs.DrawCircle(x, y, Radius, (Paint)JFX.Colors.From32Bit(Color2), Filled, StrokeWidth);
    }

    public void DrawBitmap(Image Bitmap, B4XRect Destination) {
        this.cvs.DrawImage(Bitmap, Destination.left, Destination.top, Destination.getWidth(), Destination.getHeight());
    }

    public void DrawBitmapRotated(Image Bitmap, B4XRect Destination, float Degrees) {
        this.cvs.DrawImageRotated(Bitmap, Destination.left, Destination.top, Destination.getWidth(), Destination.getHeight(), Degrees);
    }

    public void ClipPath(B4XPath Path2) throws Exception {
        GraphicsContext gc = ((Canvas)this.cvs.getObject()).getGraphicsContext2D();
        gc.save();
        gc.beginPath();
        Field pf = GraphicsContext.class.getDeclaredField("path");
        pf.setAccessible(true);
        Path2D p = (Path2D)pf.get(gc);
        p.setTo((Path2D)Path2.getObject());
        gc.closePath();
        gc.clip();
    }

    public void RemoveClip() {
        this.cvs.RemoveClip();
    }

    public void DrawPath(B4XPath Path2, int Color2, boolean Filled, float StrokeWidth) throws Exception {
        this.ClipPath(Path2);
        GraphicsContext gc = ((Canvas)this.cvs.getObject()).getGraphicsContext2D();
        Color clr = JFX.Colors.From32Bit(Color2);
        if (Filled) {
            gc.setFill((Paint)clr);
            gc.fill();
        } else {
            gc.setStroke((Paint)clr);
            gc.setLineWidth((double)(StrokeWidth * 2.0f));
            gc.stroke();
        }
        this.cvs.RemoveClip();
    }

    public void DrawPathRotated(B4XPath Path2, int Color2, boolean Filled, float StrokeWidth, float Degrees, float CenterX, float CenterY) throws Exception {
        ((Path2D)Path2.getObject()).transform(BaseTransform.getRotateInstance((double)((double)(Degrees / 180.0f) * Math.PI), (double)CenterX, (double)CenterY));
        this.DrawPath(Path2, Color2, Filled, StrokeWidth);
        ((Path2D)Path2.getObject()).transform(BaseTransform.getRotateInstance((double)((double)(-Degrees / 180.0f) * Math.PI), (double)CenterX, (double)CenterY));
    }

    public void ClearRect(B4XRect Rect2) {
        this.cvs.ClearRect(Rect2.left, Rect2.top, Rect2.getWidth(), Rect2.getHeight());
    }

    public void DrawText(String Text, double x, double y, B4XViewWrapper.B4XFont Font2, int Color2, TextAlignment Alignment) {
        GraphicsContext gc = ((Canvas)this.cvs.getObject()).getGraphicsContext2D();
        this.cvs.DrawText(Text, x, y, (Font)Font2.getObject(), (Paint)JFX.Colors.From32Bit(Color2), Alignment);
    }

    public void DrawTextRotated(String Text, double x, double y, B4XViewWrapper.B4XFont Font2, int Color2, TextAlignment Alignment, float Degree) {
        this.cvs.DrawTextRotated(Text, x, y, (Font)Font2.getObject(), (Paint)JFX.Colors.From32Bit(Color2), Alignment, Degree);
    }

    public void Release() {
    }

    public static B4XRect MeasureText(String Text2, B4XViewWrapper.B4XFont Font2) {
        if (Text2.startsWith(" ")) {
            Text2 = "." + Text2.substring(1);
        }
        if (Text2.endsWith(" ")) {
            Text2 = String.valueOf(Text2.substring(0, Text2.length() - 1)) + ".";
        }
        Text t = new Text(Text2);
        t.setFont((Font)Font2.getObject());
        t.setLineSpacing(0.0);
        t.setWrappingWidth(0.0);
        t.setBoundsType(TextBoundsType.VISUAL);
        B4XRect r = new B4XRect();
        Bounds b = t.getLayoutBounds();
        r.Initialize((float)b.getMinX(), (float)b.getMinY(), (float)b.getMaxX(), (float)b.getMaxY());
        return r;
    }

    @BA.ShortName(value="B4XPath")
    public static class B4XPath
    extends AbsObjectWrapper<Path2D> {
        public B4XPath Initialize(float x, float y) {
            Path2D p = new Path2D();
            p.moveTo(x, y);
            this.setObject(p);
            return this;
        }

        public B4XPath InitializeOval(B4XRect Rect2) {
            Path2D p = new Path2D();
            p.append((Shape)new Ellipse2D(Rect2.left, Rect2.top, Rect2.getWidth(), Rect2.getHeight()), true);
            this.setObject(p);
            return this;
        }

        public B4XPath InitializeArc(float x, float y, float Radius, float StartingAngle, float SweepAngle) {
            Path2D p = new Path2D();
            p.append((Shape)new Arc2D(x - Radius, y - Radius, 2.0f * Radius, 2.0f * Radius, -StartingAngle, -SweepAngle, 2), true);
            this.setObject(p);
            return this;
        }

        public B4XPath InitializeRoundedRect(B4XRect Rect2, float CornersRadius) {
            Path2D p = new Path2D();
            p.append((Shape)new RoundRectangle2D(Rect2.left, Rect2.top, Rect2.getWidth(), Rect2.getHeight(), CornersRadius, CornersRadius), true);
            this.setObject(p);
            return this;
        }

        public B4XPath LineTo(float x, float y) {
            ((Path2D)this.getObject()).lineTo(x, y);
            return this;
        }
    }

    @BA.ShortName(value="B4XRect")
    public static class B4XRect {
        private float left;
        private float top;
        private float right;
        private float bottom;

        public void Initialize(float Left, float Top, float Right, float Bottom) {
            this.left = Left;
            this.top = Top;
            this.right = Right;
            this.bottom = Bottom;
        }

        public float getLeft() {
            return this.left;
        }

        public void setLeft(float left) {
            this.left = left;
        }

        public float getTop() {
            return this.top;
        }

        public void setTop(float top) {
            this.top = top;
        }

        public float getRight() {
            return this.right;
        }

        public void setRight(float right) {
            this.right = right;
        }

        public float getBottom() {
            return this.bottom;
        }

        public void setBottom(float bottom) {
            this.bottom = bottom;
        }

        public float getWidth() {
            return this.right - this.left;
        }

        public void setWidth(int w) {
            this.right = this.left + (float)w;
        }

        public float getHeight() {
            return this.bottom - this.top;
        }

        public void setHeight(float h) {
            this.bottom = this.top + h;
        }

        public float getCenterX() {
            return (this.left + this.right) * 0.5f;
        }

        public float getCenterY() {
            return (this.top + this.bottom) * 0.5f;
        }

        @BA.Hide
        public String toString() {
            return "(" + this.left + ", " + this.top + ", " + this.right + ", " + this.bottom + ")";
        }
    }
}

