﻿Type=Class
Version=4.7
ModulesStructureVersion=1
B4J=true
@EndOfDesignText@
'Custom View class
#Event: ExampleEvent (Value As Int)
#DesignerProperty: Key: BooleanExample, DisplayName: Boolean Example, FieldType: Boolean, DefaultValue: True, Description: Example of a boolean property.
#DesignerProperty: Key: IntExample, DisplayName: Int Example, FieldType: Int, DefaultValue: 10, MinRange: 0, MaxRange: 100, Description: Note that MinRange and MaxRange are optional.
#DesignerProperty: Key: StringWithListExample, DisplayName: String With List, FieldType: String, DefaultValue: Sunday, List: Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday
#DesignerProperty: Key: StringExample, DisplayName: String Example, FieldType: String, DefaultValue: Text
#DesignerProperty: Key: ColorExample, DisplayName: Color Example, FieldType: Color, DefaultValue: 0xFFCFDCDC, Description: You can use the built-in color picker to find the color values.
Sub Class_Globals
	Private fx As JFX
	Private mEventName As String 'ignore
	Private mCallBack As Object 'ignore
	Private mParent As Pane
	
	Private jCircle As JavaObject	
	Private mCenterX, mCenterY, mRadius, mLineWidth As Double
	Private mColor As Paint
	Private mFill As Boolean
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
End Sub

Public Sub DesignerCreateView (Base As Pane, Lbl As Label, Props As Map)
	mParent = Base.Parent
	
End Sub

Private Sub Base_Resize (Width As Double, Height As Double)
	
End Sub

Public Sub AddToParent(Parent As Pane, CenterX As Double, CenterY As Double, Radius As Double, LineWidth As Double, Color As Paint, Fill As Boolean)
	mParent = Parent
	mCenterX = CenterX
	mCenterY = CenterY
	mRadius = Radius
	mLineWidth = LineWidth
	mColor = Color
	mFill = Fill
	Init
End Sub

Private Sub Init
	jCircle.InitializeNewInstance("javafx.scene.shape.Circle", Null)
	jCircle.RunMethod("setCenterX", Array As Object(mCenterX))
	jCircle.RunMethod("setCenterY", Array As Object(mCenterY))
	jCircle.RunMethod("setRadius", Array As Object(mRadius))
	jCircle.RunMethod("setStrokeWidth", Array As Object(mLineWidth))
	If mFill = True Then
		jCircle.RunMethod("setFill", Array As Object(mColor))		
	Else	
		jCircle.RunMethod("setFill", Array As Object(fx.Colors.Transparent))	
		jCircle.RunMethod("setStroke", Array As Object(mColor))
	End If
	mParent.AddNode(jCircle, mCenterX, mCenterY, -1, -1)
End Sub