﻿Type=Class
Version=4.7
ModulesStructureVersion=1
B4J=true
@EndOfDesignText@
'Custom View class
#Event: ExampleEvent (Value As Int)
'#DesignerProperty: Key: BooleanExample, DisplayName: Boolean Example, FieldType: Boolean, DefaultValue: True, Description: Example of a boolean property.
'#DesignerProperty: Key: IntExample, DisplayName: Int Example, FieldType: Int, DefaultValue: 10, MinRange: 0, MaxRange: 100, Description: Note that MinRange and MaxRange are optional.
#DesignerProperty: Key: Color, DisplayName: line color, FieldType: Color, DefaultValue: 0xFF000000, Description: You can use the built-in color picker to find the color values.
#DesignerProperty: Key: LineWidth, DisplayName: Line width, FieldType: Int, DefaultValue: 1
#DesignerProperty: Key: LineCap, DisplayName: Line cap, FieldType: String, DefaultValue: SQUARE, List: BUT|SQUARE|ROUND
Sub Class_Globals
	Private fx As JFX
	Private mEventName As String 'ignore
	Private mCallBack As Object 'ignore
	Private mParent, mBase As Pane
	
	Private jLine As JavaObject	
	Private mStartX, mStartY, mEndX, mEndY, mLineWidth As Double
	Private mColor As Paint
	Private mLineCap As String
End Sub

Public Sub Initialize (CallBack As Object, EventName As String)
	EventName = EventName
	CallBack = CallBack
	mLineWidth = 1
End Sub

Public Sub DesignerCreateView (Base As Pane, Lbl As Label, Props As Map)
	mBase = Base
	mParent = Base.Parent
	mStartX = Base.Left
	mStartY = Base.Top
	mEndX = Base.Left + Base.Width
	mEndY = Base.Top + Base.Height
	mLineWidth = Props.Get("LineWidth")
	mColor = Props.Get("Color")
	mLineCap = Props.Get("LineCap")
	Base.Visible = False
End Sub

Private Sub Base_Resize (Width As Double, Height As Double)
	If mBase.IsInitialized Then
		mStartX = mBase.Left
		mStartY = mBase.Top
		mEndX = mBase.Left + Width
		mEndY = mBase.Top + Height
		If jLine.IsInitialized Then
			jLine.RunMethod("setStartX", Array As Object(mStartX))
			jLine.RunMethod("setStartY", Array As Object(mStartY))		
			jLine.RunMethod("setEndX", Array As Object(mEndX))
			jLine.RunMethod("setEndY", Array As Object(mEndY))		
		Else
			Init
		End If
	End If	
End Sub

Public Sub AddToParent(Parent As Pane, x1 As Double, y1 As Double, x2 As Double, y2 As Double, LineWidth As Double, Color As Paint, LineCap As String)
	mParent = Parent
	mStartX = x1
	mStartY = y1
	mEndX = x2
	mEndY = y2
	mLineWidth = LineWidth
	mColor = Color
	mLineCap = LineCap
	Init
End Sub

Private Sub Init
	jLine.InitializeNewInstance("javafx.scene.shape.Line", Null)
	jLine.RunMethod("setStartX", Array As Object(mStartX))
	jLine.RunMethod("setStartY", Array As Object(mStartY))
	jLine.RunMethod("setEndX", Array As Object(mEndX))
	jLine.RunMethod("setEndY", Array As Object(mEndY))
	jLine.RunMethod("setStrokeWidth", Array As Object(mLineWidth))
	jLine.RunMethod("setStrokeLineCap", Array As Object(mLineCap))
	jLine.RunMethod("setStroke", Array As Object(mColor))
	
	Private jParent, jChildren As JavaObject
	jParent = mParent
	jChildren = jParent.RunMethod("getChildren", Null)
	jChildren.RunMethod("add", Array As Object(jLine))
End Sub

'gets or sets the x1 property
Public Sub getX1 As Double
	Return mStartX
End Sub

Public Sub setX1(X1 As Double)
	mStartX = X1
	jLine.RunMethod("setStartX", Array As Object(mStartX))
End Sub

'gets or sets the y1 property
Public Sub getY1 As Double
	Return mStartY
End Sub

Public Sub setY1(Y1 As Double)
	mStartY = Y1
	jLine.RunMethod("setStartY", Array As Object(mStartY))
End Sub

'gets or sets the x2 property
Public Sub getX2 As Double
	Return mEndX
End Sub

Public Sub setX2(X2 As Double)
	mEndX = X2
	jLine.RunMethod("setEndX", Array As Object(mEndX))
End Sub

'gets or sets the y2 property
Public Sub getY2 As Double
	Return mEndY
End Sub

Public Sub setY2(Y2 As Double)
	mEndY = Y2
	jLine.RunMethod("setEndY", Array As Object(mEndY))
End Sub

'gets or sets the Color property
Public Sub getColor As Paint
	Return mColor
End Sub

Public Sub setColor(Color As Paint)
	mColor = Color
	jLine.RunMethod("setStroke", Array As Object(mColor))
End Sub

'gets or sets the LineWidth property
Public Sub getLineWidth As Double
	Return mLineWidth
End Sub

Public Sub setLineWidth(LineWidth As Double)
	mLineWidth = LineWidth
	jLine.RunMethod("setStrokeWidth", Array As Object(mLineWidth))
End Sub

'gets or sets the LineCap property
'possible values: BUT, SQUARE, ROUND default value SQUARE
Public Sub getLineCap As String
	Return mLineCap
End Sub

Public Sub setLineCap(LineCap As String)
	If LineCap <> "BUTT" And LineCap <> "SQUARE" And LineCap <> "ROUND" Then
		Return
	Else
		mLineCap = LineCap
		jLine.RunMethod("setStrokeLineCap", Array As Object(mLineCap))
	End If
End Sub

'gets or sets the MouseCursor
Public Sub getMouseCursor As String
	Private jCursor As JavaObject
	
	jCursor = jLine.RunMethod("getMouseCursor", Null)
	Return jCursor.RunMethod("toString", Null)
End Sub

Public Sub setMouseCursor(NewCursor As String)
	Private jCursor, jNewCursor As JavaObject
	
	jCursor.InitializeStatic("javafx.scene.Cursor")
	jNewCursor = jCursor.RunMethod("cursor", Array As Object(NewCursor))
	jLine.RunMethod("setCursor", Array As Object(jNewCursor))
End Sub

'removes the line from the parent node
Public Sub RemoveNodeFromParent
'	jLine.RunMethod(""), Null)
End Sub