﻿Type=Class
Version=4.7
ModulesStructureVersion=1
B4J=true
@EndOfDesignText@
'Custom View class
#Event: ExampleEvent (Value As Int)
#DesignerProperty: Key: StrokeType, DisplayName: Stroke type, FieldType: String, DefaultValue: CENTERED, List: INSIDE|CENTERED|OUTSIDE
#DesignerProperty: Key: LineWidth, DisplayName: Line width, FieldType: Int, DefaultValue: 1, MinRange: 0, MaxRange: 100, Description: Sets the lije width in pixels.
'#DesignerProperty: Key: StringWithListExample, DisplayName: String With List, FieldType: String, DefaultValue: Sunday, List: Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday
'DesignerProperty: Key: StringExample, DisplayName: String Example, FieldType: String, DefaultValue: Text
#DesignerProperty: Key: Color, DisplayName: Fill or line color, FieldType: Color, DefaultValue: 0xFFFFFFFF, Description: You can use the built-in color picker to find the color values.
#DesignerProperty: Key: Fill, DisplayName: Fill the rectangle, FieldType: Boolean, DefaultValue: True, Description: True fills the rectangle, False draws only the border.
Sub Class_Globals
	Private fx As JFX
	Private mEventName As String 'ignore
	Private mCallBack As Object 'ignore
	Private mParent, mBase As Pane
	Private jRectangle As JavaObject	
	Private mX, mY, mWidth, mHeight, mLineWidth As Double
	Private mColor As Paint
	Private mFill As Boolean
	Private mStrokeType As String
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	mColor = fx.Colors.Blue
	mFill = False
	mStrokeType = "CENTERED"
End Sub

Public Sub DesignerCreateView (Base As Pane, Lbl As Label, Props As Map)
	mBase = Base
	mParent = mBase.Parent
	mX = Base.Left
	mY = Base.Top
	mLineWidth = Props.Get("LineWidth")
	mColor = Props.Get("Color")
	mFill = Props.Get("Fill")
	mStrokeType = Props.Get("StrokeType")
	Base.Visible = False
End Sub

Private Sub Base_Resize (Width As Double, Height As Double)
	If mBase.IsInitialized Then
		mX = mBase.Left
		mY = mBase.Top
		mWidth = Width
		mHeight	= Height		
		If jRectangle.IsInitialized Then
			jRectangle.RunMethod("setX", Array As Object(mX))
			jRectangle.RunMethod("setY", Array As Object(mY))		
			jRectangle.RunMethod("setWidth", Array As Object(mWidth))
			jRectangle.RunMethod("setHeight", Array As Object(mHeight))		
		Else
			Init
		End If
	End If
End Sub

'adds the node onto the given parent pane.
'Left, Top, Width, Height = position and dimensions of the rectangle
'LineWidth = line width in pixels
'Color = line or fill color
'Fill = True > fills the rectangle with the fill color
'StrokeType = position of the border line: INSIDE, CENTERED, OUTSIDE
Public Sub AddToParent(Parent As Pane, Left As Double, Top As Double, Width As Double, Height As Double, LineWidth As Double, Color As Paint, Fill As Boolean, StrokeType As String)
	mParent = Parent
	mX = Left
	mY = Top
	mWidth = Width
	mHeight = Height
	mLineWidth = LineWidth
	mColor = Color
	mFill = Fill
	mStrokeType = StrokeType
	Init
End Sub

Private Sub Init
	jRectangle.InitializeNewInstance("javafx.scene.shape.Rectangle", Null)
	jRectangle.RunMethod("setX", Array As Object(mX))
	jRectangle.RunMethod("setY", Array As Object(mY))
	jRectangle.RunMethod("setWidth", Array As Object(mWidth))
	jRectangle.RunMethod("setHeight", Array As Object(mHeight))
	jRectangle.RunMethod("setStrokeWidth", Array As Object(mLineWidth))
	jRectangle.RunMethod("setStrokeType", Array As Object(mStrokeType))
	If mFill = True Then
		jRectangle.RunMethod("setFill", Array As Object(mColor))	
	Else	
		jRectangle.RunMethod("setFill", Array As Object(fx.Colors.Transparent))	
		jRectangle.RunMethod("setStroke", Array As Object(mColor))
	End If
	Private jParent, jChildren As JavaObject
	jParent = mParent
	jChildren = jParent.RunMethod("getChildren", Null)
	jChildren.RunMethod("add", Array As Object(jRectangle))
	
	Private MouseListener As JavaObject
	MouseListener = jRectangle.CreateEvent("javafx.event.EventHandler", "MouseClicked", Null)
	jRectangle.RunMethod("setOnMouseClicked", Array As Object(MouseListener))

	Private MouseListener As JavaObject
	MouseListener = jRectangle.CreateEvent("javafx.event.EventHandler", "MouseDragged", Null)
	jRectangle.RunMethod("setOnMouseDragged", Array As Object(MouseListener))

	Private MouseListener As JavaObject
	MouseListener = jRectangle.CreateEvent("javafx.event.EventHandler", "MouseMoved", Null)
	jRectangle.RunMethod("setOnMouseMoved", Array As Object(MouseListener))

	Private MouseListener As JavaObject
	MouseListener = jRectangle.CreateEvent("javafx.event.EventHandler", "MousePressed", Null)
	jRectangle.RunMethod("setOnMousePressed", Array As Object(MouseListener))

	Private MouseListener As JavaObject
	MouseListener = jRectangle.CreateEvent("javafx.event.EventHandler", "MouseReleased", Null)
	jRectangle.RunMethod("setOnMouseReleased", Array As Object(MouseListener))
End Sub

Public Sub TranslateX(X As Double)
	jRectangle.RunMethod("setTranslateX", Array As Object(X))	
End Sub

Public Sub Rotate(Angle As Double)
	jRectangle.RunMethod("setRotate", Array As Object(Angle))	
End Sub

'gets or sets the MouseCursor
Public Sub getMouseCursor As String
	Private jCursor As JavaObject
	
	jCursor = jRectangle.RunMethod("getMouseCursor", Null)
	Return jCursor.RunMethod("toString", Null)
End Sub

Public Sub setMouseCursor(NewCursor As String)
	Private jCursor, jNewCursor As JavaObject
	
	jCursor.InitializeStatic("javafx.scene.Cursor")
	jNewCursor = jCursor.RunMethod("cursor", Array As Object(NewCursor))
	jRectangle.RunMethod("setCursor", Array As Object(jNewCursor))
End Sub

'gets or sets the Visible property
Public Sub getVisible As Boolean
	Return jRectangle.RunMethod("getVisible", Null)
End Sub

Public Sub setVisible(Visible As Boolean)
	jRectangle.RunMethod("setVisible", Array As Object(Visible))	
End Sub

Private Sub MouseClicked_Event(MethodName As String, Args() As Object)
	If SubExists(mCallBack, mEventName & "_MouseClicked") Then
		CallSub2(mCallBack, mEventName & "_MouseClicked", Args(0))
	End If
End Sub

Private Sub MouseDragged_Event(MethodName As String, Args() As Object)
	If SubExists(mCallBack, mEventName & "_MouseDragged") Then
		CallSub2(mCallBack, mEventName & "_MouseDragged", Args(0))
	End If
End Sub

Private Sub MouseMoved_Event(MethodName As String, Args() As Object)
	If SubExists(mCallBack, mEventName & "_MouseMoved") Then
		CallSub2(mCallBack, mEventName & "_MouseMoved", Args(0))
	End If
End Sub

Private Sub MousePressed_Event(MethodName As String, Args() As Object)
	If SubExists(mCallBack, mEventName & "_MousePressed") Then
		CallSub2(mCallBack, mEventName & "_MousePressed", Args(0))
	End If
End Sub

Private Sub MouseReleased_Event(MethodName As String, Args() As Object)
	If SubExists(mCallBack, mEventName & "_MouseReleased") Then
		CallSub2(mCallBack, mEventName & "_MouseReleased", Args(0))
	End If
End Sub

