/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.ExceptionHandler;
import com.bugsnag.HandledState;
import com.bugsnag.MetaData;
import com.bugsnag.Notification;
import com.bugsnag.Report;
import com.bugsnag.Session;
import com.bugsnag.SessionTracker;
import com.bugsnag.Severity;
import com.bugsnag.callbacks.Callback;
import com.bugsnag.delivery.Delivery;
import com.bugsnag.delivery.HttpDelivery;
import com.bugsnag.util.DaemonThreadFactory;
import java.net.Proxy;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bugsnag {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bugsnag.class);
    private static final int SHUTDOWN_TIMEOUT_MS = 5000;
    private static final int SESSION_TRACKING_PERIOD_MS = 60000;
    private static final int CORE_POOL_SIZE = 1;
    private ExecutorService sessionFlusherService = new ThreadPoolExecutor(0, 1, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private ScheduledThreadPoolExecutor sessionExecutorService = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory(), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            LOGGER.error("Rejected execution for sessionExecutorService");
        }
    });
    private Configuration config;
    private final SessionTracker sessionTracker;
    private static final ThreadLocal<MetaData> THREAD_METADATA = new ThreadLocal<MetaData>(){

        @Override
        public MetaData initialValue() {
            return new MetaData();
        }
    };

    public Bugsnag(String apiKey) {
        this(apiKey, true);
    }

    public Bugsnag(String apiKey, boolean sendUncaughtExceptions) {
        if (apiKey == null) {
            throw new NullPointerException("You must provide a Bugsnag API key");
        }
        this.config = new Configuration(apiKey);
        this.sessionTracker = new SessionTracker(this.config);
        this.config.setSendUncaughtExceptions(sendUncaughtExceptions);
        if (sendUncaughtExceptions) {
            ExceptionHandler.enable(this);
        }
        this.addSessionTrackingShutdownHook();
        this.scheduleSessionFlushes();
    }

    private void scheduleSessionFlushes() {
        this.sessionExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Bugsnag.this.sessionFlusherService.submit(new Runnable(){

                    @Override
                    public void run() {
                        Bugsnag.this.sessionTracker.flushSessions(new Date());
                    }
                });
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    private void addSessionTrackingShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bugsnag.this.sessionTracker.shutdown();
                Bugsnag.this.sessionExecutorService.shutdown();
                try {
                    if (!Bugsnag.this.sessionExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                        LOGGER.warn("Shutdown of 'session tracking' threads took too long - forcing a shutdown");
                        Bugsnag.this.sessionExecutorService.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Shutdown of 'session tracking' thread was interrupted - forcing a shutdown");
                    Bugsnag.this.sessionExecutorService.shutdownNow();
                }
            }
        });
    }

    public void addCallback(Callback callback) {
        this.config.addCallback(callback);
    }

    public Delivery getDelivery() {
        return this.config.delivery;
    }

    public Delivery getSessionDelivery() {
        return this.config.sessionDelivery;
    }

    public void setAppType(String appType) {
        this.config.appType = appType;
    }

    public void setAppVersion(String appVersion) {
        this.config.appVersion = appVersion;
    }

    public void setDelivery(Delivery delivery) {
        this.config.delivery = delivery;
    }

    public void setSessionDelivery(Delivery delivery) {
        this.config.sessionDelivery = delivery;
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        if (this.config.delivery instanceof HttpDelivery) {
            ((HttpDelivery)this.config.delivery).setEndpoint(endpoint);
        }
    }

    public void setFilters(String ... filters) {
        this.config.filters = filters;
    }

    public void setIgnoreClasses(String ... ignoreClasses) {
        this.config.ignoreClasses = ignoreClasses;
    }

    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        this.config.notifyReleaseStages = notifyReleaseStages;
    }

    public void setProjectPackages(String ... projectPackages) {
        this.config.projectPackages = projectPackages;
    }

    public void setProxy(Proxy proxy) {
        if (this.config.delivery instanceof HttpDelivery) {
            ((HttpDelivery)this.config.delivery).setProxy(proxy);
        }
        if (this.config.sessionDelivery instanceof HttpDelivery) {
            ((HttpDelivery)this.config.sessionDelivery).setProxy(proxy);
        }
    }

    public void setReleaseStage(String releaseStage) {
        this.config.releaseStage = releaseStage;
    }

    public void setSendThreads(boolean sendThreads) {
        this.config.sendThreads = sendThreads;
    }

    public void setTimeout(int timeout) {
        if (this.config.delivery instanceof HttpDelivery) {
            ((HttpDelivery)this.config.delivery).setTimeout(timeout);
        }
        if (this.config.sessionDelivery instanceof HttpDelivery) {
            ((HttpDelivery)this.config.sessionDelivery).setTimeout(timeout);
        }
    }

    public Report buildReport(Throwable throwable) {
        return new Report(this.config, throwable);
    }

    public boolean notify(Throwable throwable) {
        return this.notify(this.buildReport(throwable));
    }

    public boolean notify(Throwable throwable, Callback callback) {
        return this.notify(this.buildReport(throwable), callback);
    }

    public boolean notify(Throwable throwable, Severity severity) {
        return this.notify(throwable, severity, null);
    }

    public boolean notify(Throwable throwable, Severity severity, Callback callback) {
        if (throwable == null) {
            LOGGER.warn("Tried to notify with a null Throwable");
            return false;
        }
        HandledState handledState = HandledState.newInstance(HandledState.SeverityReasonType.REASON_USER_SPECIFIED, severity);
        Report report = new Report(this.config, throwable, handledState, Thread.currentThread());
        return this.notify(report, callback);
    }

    public boolean notify(Report report) {
        return this.notify(report, null);
    }

    boolean notify(Throwable throwable, HandledState handledState, Thread currentThread) {
        Report report = new Report(this.config, throwable, handledState, currentThread);
        return this.notify(report, null);
    }

    public boolean notify(Report report, Callback reportCallback) {
        if (report == null) {
            LOGGER.warn("Tried to call notify with a null Report");
            return false;
        }
        if (this.config.shouldIgnoreClass(report.getExceptionName())) {
            LOGGER.debug("Error not reported to Bugsnag - {} is in 'ignoreClasses'", (Object)report.getExceptionName());
            return false;
        }
        if (!this.config.shouldNotifyForReleaseStage()) {
            LOGGER.debug("Error not reported to Bugsnag - {} is not in 'notifyReleaseStages'", (Object)this.config.releaseStage);
            return false;
        }
        for (Callback callback : this.config.callbacks) {
            try {
                callback.beforeNotify(report);
                if (!report.getShouldCancel()) continue;
                LOGGER.debug("Error not reported to Bugsnag - cancelled by a client-wide beforeNotify callback");
                return false;
            }
            catch (Throwable ex) {
                LOGGER.warn("Callback threw an exception", ex);
            }
        }
        report.mergeMetaData(THREAD_METADATA.get());
        if (reportCallback != null) {
            try {
                reportCallback.beforeNotify(report);
                if (report.getShouldCancel()) {
                    LOGGER.debug("Error not reported to Bugsnag - cancelled by a report-specific callback");
                    return false;
                }
            }
            catch (Throwable ex) {
                LOGGER.warn("Callback threw an exception", ex);
            }
        }
        if (this.config.delivery == null) {
            LOGGER.debug("Error not reported to Bugsnag - no delivery is set");
            return false;
        }
        Session session = this.sessionTracker.getSession();
        if (session != null) {
            if (report.getUnhandled()) {
                session.incrementUnhandledCount();
            } else {
                session.incrementHandledCount();
            }
            report.setSession(session);
        }
        Notification notification = new Notification(this.config, report);
        LOGGER.debug("Reporting error to Bugsnag");
        this.config.delivery.deliver(this.config.serializer, notification, this.config.getErrorApiHeaders());
        return true;
    }

    public void startSession() {
        this.sessionTracker.startSession(new Date(), false);
    }

    public void setAutoCaptureSessions(boolean autoCaptureSessions) {
        this.config.setAutoCaptureSessions(autoCaptureSessions);
    }

    public boolean shouldAutoCaptureSessions() {
        return this.config.shouldAutoCaptureSessions();
    }

    @Deprecated
    public void setSessionEndpoint(String endpoint) {
        if (this.config.sessionDelivery instanceof HttpDelivery) {
            ((HttpDelivery)this.config.sessionDelivery).setEndpoint(endpoint);
        }
    }

    public void setEndpoints(String notify, String sessions) throws IllegalArgumentException {
        this.config.setEndpoints(notify, sessions);
    }

    public void close() {
        LOGGER.debug("Closing connection to Bugsnag");
        if (this.config.delivery != null) {
            this.config.delivery.close();
        }
        ExceptionHandler.disable(this);
    }

    public static void addThreadMetaData(String tabName, String key, Object value) {
        THREAD_METADATA.get().addToTab(tabName, key, value);
    }

    public static void clearThreadMetaData() {
        THREAD_METADATA.get().clear();
    }

    public static void clearThreadMetaData(String tabName) {
        THREAD_METADATA.get().clearTab(tabName);
    }

    public static void clearThreadMetaData(String tabName, String key) {
        THREAD_METADATA.get().clearKey(tabName, key);
    }

    Configuration getConfig() {
        return this.config;
    }

    SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }

    public static Set<Bugsnag> uncaughtExceptionClients() {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        if (handler instanceof ExceptionHandler) {
            ExceptionHandler bugsnagHandler = (ExceptionHandler)handler;
            return Collections.unmodifiableSet(bugsnagHandler.uncaughtExceptionClients());
        }
        return Collections.emptySet();
    }
}

