/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class DateUtils {
    private static final ThreadLocal<Calendar> calendarThreadLocal = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final ThreadLocal<DateFormat> iso8601Holder = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            iso8601.setTimeZone(tz);
            return iso8601;
        }
    };

    DateUtils() {
    }

    static String toIso8601(Date date) {
        return iso8601Holder.get().format(date);
    }

    static Date roundTimeToLatestMinute(Date date) {
        Calendar calendar = calendarThreadLocal.get();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

