/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Configuration;
import com.bugsnag.DateUtils;
import com.bugsnag.Session;
import com.bugsnag.SessionCount;
import com.bugsnag.SessionPayload;
import com.bugsnag.delivery.Delivery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class SessionTracker {
    private final Configuration config;
    private final ThreadLocal<Session> session = new ThreadLocal();
    private final AtomicReference<SessionCount> batchCount = new AtomicReference();
    private final Collection<SessionCount> enqueuedSessionCounts = new ConcurrentLinkedQueue<SessionCount>();
    private final Semaphore flushingRequest = new Semaphore(1);
    private final AtomicBoolean shuttingDown = new AtomicBoolean();

    SessionTracker(Configuration configuration) {
        this.config = configuration;
    }

    void startSession(Date date, boolean autoCaptured) {
        if (!this.config.shouldAutoCaptureSessions() && autoCaptured || !this.config.shouldNotifyForReleaseStage() || this.shuttingDown.get()) {
            return;
        }
        Date roundedStartDate = DateUtils.roundTimeToLatestMinute(date);
        this.session.set(new Session(UUID.randomUUID().toString(), roundedStartDate));
        this.updateBatchCountIfNeeded(roundedStartDate);
        this.batchCount.get().incrementSessionsStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatchCountIfNeeded(Date roundedStartDate) {
        if (this.isNewBatchPeriod(roundedStartDate)) {
            AtomicReference<SessionCount> atomicReference = this.batchCount;
            synchronized (atomicReference) {
                SessionCount newCount;
                SessionCount prevCount;
                if (this.isNewBatchPeriod(roundedStartDate) && (prevCount = this.batchCount.getAndSet(newCount = new SessionCount(roundedStartDate))) != null && prevCount.getSessionsStarted() > 0L) {
                    this.enqueuedSessionCounts.add(prevCount);
                }
            }
        }
    }

    private boolean isNewBatchPeriod(Date roundedStartDate) {
        SessionCount currentCount = this.batchCount.get();
        return currentCount == null || roundedStartDate.after(currentCount.getRoundedDate());
    }

    Session getSession() {
        return this.session.get();
    }

    SessionCount getBatchCount() {
        return this.batchCount.get();
    }

    void flushSessions(Date now) {
        if (this.shuttingDown.get()) {
            return;
        }
        this.sendSessions(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSessions(Date now) {
        this.updateBatchCountIfNeeded(DateUtils.roundTimeToLatestMinute(now));
        if (!this.enqueuedSessionCounts.isEmpty() && this.flushingRequest.tryAcquire(1)) {
            try {
                ArrayList<SessionCount> requestValues = new ArrayList<SessionCount>(this.enqueuedSessionCounts);
                SessionPayload payload = new SessionPayload(requestValues, this.config);
                Delivery delivery = this.config.sessionDelivery;
                delivery.deliver(this.config.serializer, payload, this.config.getSessionApiHeaders());
                this.enqueuedSessionCounts.removeAll(requestValues);
            }
            finally {
                this.flushingRequest.release(1);
            }
        }
    }

    void shutdown() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            this.sendSessions(new Date(Long.MAX_VALUE));
        }
    }
}

