/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.callbacks;

import com.bugsnag.Report;
import com.bugsnag.callbacks.Callback;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class DeviceCallback
implements Callback {
    private static volatile String hostname;
    private static volatile transient boolean hostnameInitialised;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostnameValue() {
        if (!hostnameInitialised) {
            Object object = lock;
            synchronized (object) {
                if (!hostnameInitialised) {
                    hostname = DeviceCallback.lookupHostname();
                    hostnameInitialised = true;
                }
            }
        }
        return hostname;
    }

    private static String lookupHostname() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return System.getenv("COMPUTERNAME");
        }
        String hostname = System.getenv("HOSTNAME");
        if (hostname != null) {
            return hostname;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static void initializeCache() {
        DeviceCallback.getHostnameValue();
    }

    @Override
    public void beforeNotify(Report report) {
        report.setDeviceInfo("hostname", DeviceCallback.getHostnameValue()).setDeviceInfo("osName", System.getProperty("os.name")).setDeviceInfo("osVersion", System.getProperty("os.version")).setDeviceInfo("osArch", System.getProperty("os.arch")).setDeviceInfo("runtimeName", System.getProperty("java.runtime.name")).setDeviceInfo("runtimeVersion", System.getProperty("java.runtime.version")).setDeviceInfo("locale", Locale.getDefault());
    }

    static {
        lock = new Object();
    }
}

