/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.security.IAuthenticator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

@BA.Version(value=2.01f)
@BA.ShortName(value="MqttBroker")
public class MqttBroker {
    @BA.Hide
    public Server server;
    @BA.Hide
    public IConfig config;
    private boolean logEnabled;

    public void Initialize(String EventName, int Port) {
        this.server = new Server();
        this.config = new MemoryConfig(new Properties());
        this.config.setProperty("port", Integer.toString(Port));
        this.config.setProperty("websocket_port", "disabled");
        AppenderSkeleton appender = new AppenderSkeleton(){

            public boolean requiresLayout() {
                return false;
            }

            public void close() {
            }

            protected void append(LoggingEvent arg0) {
                if (MqttBroker.this.logEnabled) {
                    BA.Log((String)String.valueOf(this.getLayout().format(arg0)));
                    if (arg0.getThrowableInformation() != null && arg0.getThrowableInformation().getThrowable() != null) {
                        arg0.getThrowableInformation().getThrowable().printStackTrace();
                    }
                }
            }
        };
        appender.setLayout((Layout)new PatternLayout("%m%n"));
        appender.activateOptions();
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)appender);
    }

    public void SetUserAndPassword(String Username, String Password) {
        this.config.setProperty("b4x_user", Username);
        this.config.setProperty("b4x_password", Password);
        this.config.setProperty("allow_anonymous", String.valueOf(false));
        this.config.setProperty("authenticator_class", B4XAuthenticator.class.getName());
    }

    public void setDebugLog(boolean b) {
        this.logEnabled = b;
    }

    public void Start() throws IOException {
        this.server.startServer(this.config);
    }

    public void Stop() {
        this.server.stopServer();
    }

    @BA.Hide
    public static class B4XAuthenticator
    implements IAuthenticator {
        final String b4xUsername;
        final String b4xPassword;

        public B4XAuthenticator(IConfig config) {
            this.b4xUsername = config.getProperty("b4x_user", "");
            this.b4xPassword = config.getProperty("b4x_password", "");
        }

        @Override
        public boolean checkValid(String clientId, String username, byte[] password) {
            try {
                return this.b4xUsername.equals(username) && this.b4xPassword.equals(Common.BytesToString((byte[])password, (int)0, (int)password.length, (String)"UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

