/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.subscriptions.Topic;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class MemoryRetainedRepository
implements IRetainedRepository {
    private final ConcurrentMap<Topic, RetainedMessage> storage = new ConcurrentHashMap<Topic, RetainedMessage>();

    MemoryRetainedRepository() {
    }

    @Override
    public void cleanRetained(Topic topic) {
        this.storage.remove(topic);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg) {
        ByteBuf payload = msg.content();
        byte[] rawPayload = new byte[payload.readableBytes()];
        payload.getBytes(0, rawPayload);
        RetainedMessage toStore = new RetainedMessage(msg.fixedHeader().qosLevel(), rawPayload);
        this.storage.put(topic, toStore);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public List<RetainedMessage> retainedOnTopic(String topic) {
        Topic searchTopic = new Topic(topic);
        ArrayList<RetainedMessage> matchingMessages = new ArrayList<RetainedMessage>();
        for (Map.Entry entry : this.storage.entrySet()) {
            Topic scanTopic = (Topic)entry.getKey();
            if (!searchTopic.match(scanTopic)) continue;
            matchingMessages.add((RetainedMessage)entry.getValue());
        }
        return matchingMessages;
    }
}

