/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.InflightResender;
import io.moquette.broker.MQTTConnection;
import io.moquette.broker.MQTTConnectionFactory;
import io.moquette.broker.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NewNettyMQTTHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NewNettyMQTTHandler.class);
    private static final String ATTR_CONNECTION = "connection";
    private static final AttributeKey<Object> ATTR_KEY_CONNECTION = AttributeKey.valueOf((String)"connection");
    private MQTTConnectionFactory connectionFactory;

    NewNettyMQTTHandler(MQTTConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    private static void mqttConnection(Channel channel, MQTTConnection connection) {
        channel.attr(ATTR_KEY_CONNECTION).set((Object)connection);
    }

    private static MQTTConnection mqttConnection(Channel channel) {
        return (MQTTConnection)channel.attr(ATTR_KEY_CONNECTION).get();
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        MqttMessage msg = (MqttMessage)message;
        if (msg.fixedHeader() == null) {
            throw new IOException("Unknown packet");
        }
        MQTTConnection mqttConnection = NewNettyMQTTHandler.mqttConnection(ctx.channel());
        try {
            try {
                mqttConnection.handleMessage(msg);
            }
            catch (Throwable ex) {
                LOG.error("Error processing protocol message: {}", (Object)msg.fixedHeader().messageType(), (Object)ex);
                ctx.channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        LOG.info("Closed client channel due to exception in processing");
                    }
                });
                ReferenceCountUtil.release((Object)msg);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        MQTTConnection connection = this.connectionFactory.create(ctx.channel());
        NewNettyMQTTHandler.mqttConnection(ctx.channel(), connection);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        MQTTConnection mqttConnection = NewNettyMQTTHandler.mqttConnection(ctx.channel());
        mqttConnection.handleConnectionLost();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Unexpected exception while processing MQTT message. Closing Netty channel. CId={}", (Object)NettyUtils.clientID(ctx.channel()), (Object)cause);
        ctx.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        MQTTConnection mqttConnection = NewNettyMQTTHandler.mqttConnection(ctx.channel());
        mqttConnection.writabilityChanged();
        ctx.fireChannelWritabilityChanged();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof InflightResender.ResendNotAckedPublishes) {
            MQTTConnection mqttConnection = NewNettyMQTTHandler.mqttConnection(ctx.channel());
            mqttConnection.resendNotAckedPublishes();
        }
        ctx.fireUserEventTriggered(evt);
    }
}

