/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.potentiometer.microchip;

import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometer;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerChannel;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerDeviceStatus;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerNonVolatileMode;
import com.pi4j.component.potentiometer.microchip.impl.MicrochipPotentiometerBase;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.util.Random;

public class MCP4641
extends MicrochipPotentiometerBase
implements MicrochipPotentiometer {
    private static final MicrochipPotentiometerChannel[] supportedChannels = new MicrochipPotentiometerChannel[]{MicrochipPotentiometerChannel.A, MicrochipPotentiometerChannel.B};

    public MCP4641(I2CBus i2cBus, boolean pinA0, boolean pinA1, boolean pinA2, MicrochipPotentiometerChannel channel, MicrochipPotentiometerNonVolatileMode nonVolatileMode) throws IOException {
        super(i2cBus, pinA0, pinA1, pinA2, channel, nonVolatileMode, 0);
    }

    @Override
    public boolean isCapableOfNonVolatileWiper() {
        return true;
    }

    @Override
    public void setNonVolatileMode(MicrochipPotentiometerNonVolatileMode nonVolatileMode) {
        super.setNonVolatileMode(nonVolatileMode);
    }

    @Override
    public int getMaxValue() {
        return MCP4641.maxValue();
    }

    public static int maxValue() {
        return 128;
    }

    @Override
    public boolean isRheostat() {
        return false;
    }

    @Override
    public MicrochipPotentiometerChannel[] getSupportedChannelsByDevice() {
        return supportedChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws I2CFactory.UnsupportedBusNumberException, IOException {
        I2CBus bus = I2CFactory.getInstance((int)1);
        try {
            MCP4641 a = new MCP4641(bus, false, false, false, MicrochipPotentiometerChannel.A, MicrochipPotentiometerNonVolatileMode.VOLATILE_ONLY);
            MCP4641 b = new MCP4641(bus, false, false, false, MicrochipPotentiometerChannel.B, MicrochipPotentiometerNonVolatileMode.VOLATILE_ONLY);
            MicrochipPotentiometerDeviceStatus aStatus = a.getDeviceStatus();
            System.out.println("WiperLock for A active: " + aStatus.isWiperLockActive());
            MicrochipPotentiometerDeviceStatus bStatus = b.getDeviceStatus();
            System.out.println("WiperLock for B active: " + bStatus.isWiperLockActive());
            System.out.println("A: " + a.getCurrentValue() + "/" + a.updateCacheFromDevice());
            System.out.println("B: " + b.getCurrentValue() + "/" + b.updateCacheFromDevice());
            for (int i = 0; i < MCP4641.maxValue() / 2; ++i) {
                a.increase();
                b.decrease();
                try {
                    Thread.sleep(24L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println("A: " + a.getCurrentValue() + "/" + a.updateCacheFromDevice());
            System.out.println("B: " + b.getCurrentValue() + "/" + b.updateCacheFromDevice());
            boolean aDirectionUp = false;
            boolean bDirectionUp = true;
            int counter1 = 130;
            for (int i = 0; i < 130; ++i) {
                if (aDirectionUp) {
                    a.increase(10);
                } else {
                    a.decrease(10);
                }
                if (bDirectionUp) {
                    b.increase(10);
                } else {
                    b.decrease(10);
                }
                if (aDirectionUp && a.getCurrentValue() == a.getMaxValue() || !aDirectionUp && a.getCurrentValue() == 0) {
                    boolean bl = aDirectionUp = !aDirectionUp;
                }
                if (bDirectionUp && b.getCurrentValue() == b.getMaxValue() || !bDirectionUp && b.getCurrentValue() == 0) {
                    bDirectionUp = !bDirectionUp;
                }
                try {
                    Thread.sleep(39L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Random randomizer = new Random(System.currentTimeMillis());
            int counter2 = 10;
            for (int i = 0; i < counter2; ++i) {
                int nextA = randomizer.nextInt(MCP4641.maxValue() + 1);
                a.setCurrentValue(nextA);
                int nextB = randomizer.nextInt(MCP4641.maxValue() + 1);
                b.setCurrentValue(nextB);
                try {
                    Thread.sleep(499L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println("A: " + a.getCurrentValue() + "/" + a.updateCacheFromDevice());
            System.out.println("B: " + b.getCurrentValue() + "/" + b.updateCacheFromDevice());
            a.setNonVolatileMode(MicrochipPotentiometerNonVolatileMode.VOLATILE_AND_NONVOLATILE);
            int nextA = randomizer.nextInt(MCP4641.maxValue() + 1);
            a.setCurrentValue(nextA);
            int nextB = randomizer.nextInt(MCP4641.maxValue() + 1);
            b.setCurrentValue(nextB);
        }
        finally {
            try {
                bus.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

