/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.potentiometer.microchip.impl;

import com.pi4j.component.potentiometer.microchip.impl.DeviceControllerChannel;
import com.pi4j.component.potentiometer.microchip.impl.DeviceControllerDeviceStatus;
import com.pi4j.component.potentiometer.microchip.impl.DeviceControllerTerminalConfiguration;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import java.util.Arrays;

public class MicrochipPotentiometerDeviceController {
    public static final boolean VOLATILE_WIPER = false;
    public static final boolean NONVOLATILE_WIPER = true;
    static final byte MEMADDR_WIPER0 = 0;
    static final byte MEMADDR_WIPER1 = 1;
    static final byte MEMADDR_WIPER0_NV = 2;
    static final byte MEMADDR_WIPER1_NV = 3;
    static final byte MEMADDR_TCON01 = 4;
    private static final byte MEMADDR_STATUS = 5;
    static final byte MEMADDR_WIPER2 = 6;
    static final byte MEMADDR_WIPER3 = 7;
    static final byte MEMADDR_WIPER2_NV = 8;
    static final byte MEMADDR_WIPER3_NV = 9;
    static final byte MEMADDR_TCON23 = 4;
    private static final byte MEMADDR_WRITEPROTECTION = 15;
    private static final byte CMD_WRITE = 0;
    private static final byte CMD_INC = 4;
    private static final byte CMD_DEC = 8;
    private static final byte CMD_READ = 12;
    static final int TCON_RH02HW = 8;
    static final int TCON_RH02A = 4;
    static final int TCON_RH02W = 2;
    static final int TCON_RH02B = 1;
    static final int TCON_RH13HW = 128;
    static final int TCON_RH13A = 64;
    static final int TCON_RH13W = 32;
    static final int TCON_RH13B = 16;
    private static final int STATUS_RESERVED_MASK = 496;
    private static final int STATUS_RESERVED_VALUE = 496;
    private static final int STATUS_EEPROM_WRITEACTIVE_BIT = 8;
    private static final int STATUS_WIPERLOCK1_BIT = 4;
    private static final int STATUS_WIPERLOCK0_BIT = 2;
    private static final int STATUS_EEPROM_WRITEPROTECTION_BIT = 1;
    private I2CDevice i2cDevice;

    public MicrochipPotentiometerDeviceController(I2CDevice i2cDevice) throws IOException {
        if (i2cDevice == null) {
            throw new RuntimeException("Parameter 'i2cDevice' must not be null!");
        }
        this.i2cDevice = i2cDevice;
    }

    public DeviceControllerDeviceStatus getDeviceStatus() throws IOException {
        int deviceStatus = this.read((byte)5);
        int reservedValue = deviceStatus & 0x1F0;
        if (reservedValue != 496) {
            throw new IOException("status-bits 4 to 8 must be 1 according to documentation chapter 4.2.2.1. got '" + Integer.toString(reservedValue, 2) + "'!");
        }
        boolean eepromWriteActive = (deviceStatus & 8) > 0;
        boolean eepromWriteProtection = (deviceStatus & 1) > 0;
        boolean wiperLock0 = (deviceStatus & 2) > 0;
        boolean wiperLock1 = (deviceStatus & 4) > 0;
        return new DeviceControllerDeviceStatus(eepromWriteActive, eepromWriteProtection, wiperLock0, wiperLock1);
    }

    public void increase(DeviceControllerChannel channel, int steps) throws IOException {
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        byte memAddr = channel.getVolatileMemoryAddress();
        this.increaseOrDecrease(memAddr, true, steps);
    }

    public void decrease(DeviceControllerChannel channel, int steps) throws IOException {
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        byte memAddr = channel.getVolatileMemoryAddress();
        this.increaseOrDecrease(memAddr, false, steps);
    }

    public int getValue(DeviceControllerChannel channel, boolean nonVolatile) throws IOException {
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        byte memAddr = nonVolatile ? channel.getNonVolatileMemoryAddress() : channel.getVolatileMemoryAddress();
        int currentValue = this.read(memAddr);
        return currentValue;
    }

    public void setValue(DeviceControllerChannel channel, int value, boolean nonVolatile) throws IOException {
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        if (value < 0) {
            throw new RuntimeException("only positive values are allowed! Got value '" + value + "' for writing to channel '" + channel.name() + "'");
        }
        byte memAddr = nonVolatile ? channel.getNonVolatileMemoryAddress() : channel.getVolatileMemoryAddress();
        this.write(memAddr, value);
    }

    public DeviceControllerTerminalConfiguration getTerminalConfiguration(DeviceControllerChannel channel) throws IOException {
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        int tcon = this.read(channel.getTerminalControllAddress());
        boolean channelEnabled = (tcon & channel.getHardwareConfigControlBit()) > 0;
        boolean pinAEnabled = (tcon & channel.getTerminalAConnectControlBit()) > 0;
        boolean pinWEnabled = (tcon & channel.getWiperConnectControlBit()) > 0;
        boolean pinBEnabled = (tcon & channel.getTerminalBConnectControlBit()) > 0;
        return new DeviceControllerTerminalConfiguration(channel, channelEnabled, pinAEnabled, pinWEnabled, pinBEnabled);
    }

    public void setTerminalConfiguration(DeviceControllerTerminalConfiguration config) throws IOException {
        if (config == null) {
            throw new RuntimeException("null-config is not allowed!");
        }
        DeviceControllerChannel channel = config.getChannel();
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        byte memAddr = config.getChannel().getTerminalControllAddress();
        int tcon = this.read(memAddr);
        tcon = this.setBit(tcon, channel.getHardwareConfigControlBit(), config.isChannelEnabled());
        tcon = this.setBit(tcon, channel.getTerminalAConnectControlBit(), config.isPinAEnabled());
        tcon = this.setBit(tcon, channel.getWiperConnectControlBit(), config.isPinWEnabled());
        tcon = this.setBit(tcon, channel.getTerminalBConnectControlBit(), config.isPinBEnabled());
        this.write(memAddr, tcon);
    }

    public void setWiperLock(DeviceControllerChannel channel, boolean locked) throws IOException {
        if (channel == null) {
            throw new RuntimeException("null-channel is not allowed. For devices knowing just one wiper Channel.A is mandatory for parameter 'channel'");
        }
        byte memAddr = channel.getNonVolatileMemoryAddress();
        this.increaseOrDecrease(memAddr, locked, 1);
    }

    public void setWriteProtection(boolean enabled) throws IOException {
        this.increaseOrDecrease((byte)15, enabled, 1);
    }

    private int setBit(int mem, int mask, boolean value) {
        int result = value ? mem | mask : mem & ~mask;
        return result;
    }

    private int read(byte memAddr) throws IOException {
        byte[] cmd = new byte[]{(byte)(memAddr << 4 | 0xC)};
        byte[] buf = new byte[2];
        int read = this.i2cDevice.read(cmd, 0, cmd.length, buf, 0, buf.length);
        if (read != 2) {
            throw new IOException("Expected to read two bytes but got: " + read);
        }
        int first = buf[0] & 0xFF;
        int second = buf[1] & 0xFF;
        return first << 8 | second;
    }

    private void write(byte memAddr, int value) throws IOException {
        byte firstBit = (byte)(value >> 8 & 1);
        byte cmd = (byte)(memAddr << 4 | 0 | firstBit);
        byte data = (byte)(value & 0xFF);
        byte[] sequence = new byte[]{cmd, data};
        this.i2cDevice.write(sequence, 0, sequence.length);
    }

    private void increaseOrDecrease(byte memAddr, boolean increase, int steps) throws IOException {
        int actualSteps;
        boolean actualIncrease;
        if (steps == 0) {
            return;
        }
        if (steps < 0) {
            actualIncrease = !increase;
            actualSteps = Math.abs(steps);
        } else {
            actualIncrease = increase;
            actualSteps = steps;
        }
        byte cmd = (byte)(memAddr << 4 | (actualIncrease ? 4 : 8));
        byte[] sequence = new byte[actualSteps];
        Arrays.fill(sequence, cmd);
        this.i2cDevice.write(sequence, 0, sequence.length);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append("{\n");
        result.append("  i2cDevice='").append(this.i2cDevice);
        result.append("'\n}");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        MicrochipPotentiometerDeviceController other = (MicrochipPotentiometerDeviceController)obj;
        return this.i2cDevice.equals(other.i2cDevice);
    }
}

