/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.base;

import com.pi4j.gpio.extension.base.DacGpioProvider;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;

public abstract class DacGpioProviderBase
extends GpioProviderBase
implements DacGpioProvider {
    protected Pin[] allPins = null;
    protected Double[] shutdownValues = null;

    public DacGpioProviderBase(Pin[] pins) {
        this.allPins = pins;
        this.shutdownValues = new Double[pins.length];
        for (int index = 0; index < this.shutdownValues.length; ++index) {
            this.shutdownValues[index] = null;
        }
    }

    @Override
    public void setPercentValue(Pin pin, Number percent) {
        if (percent.doubleValue() <= 0.0) {
            this.setValue(pin, this.getMinSupportedValue());
        } else if (percent.doubleValue() >= 100.0) {
            this.setValue(pin, this.getMaxSupportedValue());
        } else {
            double value = (this.getMaxSupportedValue() - this.getMinSupportedValue()) * (percent.doubleValue() / 100.0);
            this.setValue(pin, value);
        }
    }

    @Override
    public void setPercentValue(GpioPinAnalogOutput pin, Number percent) {
        this.setPercentValue(pin.getPin(), percent);
    }

    @Override
    public void setValue(Pin pin, Number value) {
        super.setValue(pin, value.doubleValue());
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            for (Pin pin : this.allPins) {
                Double value = this.getShutdownValue(pin).doubleValue();
                if (value == null) continue;
                this.setValue(pin, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setShutdownValue(Number value, Pin ... pin) {
        for (Pin p : pin) {
            this.shutdownValues[p.getAddress()] = value.doubleValue();
        }
    }

    @Override
    public Number getShutdownValue(Pin pin) {
        return this.shutdownValues[pin.getAddress()];
    }

    @Override
    public void setShutdownValue(Number value, GpioPinAnalogOutput ... pin) {
        for (GpioPinAnalogOutput p : pin) {
            this.setShutdownValue(value, p.getPin());
        }
    }

    @Override
    public Number getShutdownValue(GpioPinAnalogOutput pin) {
        return this.getShutdownValue(pin.getPin());
    }
}

