/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.keywords.Common;
import com.pi4j.gpio.extension.piface.PiFaceGpioProvider;
import com.pi4j.gpio.extension.piface.PiFacePin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinDigital;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import java.io.IOException;
import java.lang.reflect.Field;

@BA.Version(value=2.0f)
@BA.ShortName(value="GpioController")
public class GpioControllerWrapper
extends AbsObjectWrapper<GpioController> {
    private static boolean piFace;

    @BA.Hide
    public static Pin pinFromNumber(int n, boolean output) {
        try {
            Field f = !piFace ? RaspiPin.class.getField("GPIO_" + Common.NumberFormat2((double)n, (int)2, (int)0, (int)0, (boolean)false)) : PiFacePin.class.getField(String.valueOf(output ? "OUTPUT_" : "INPUT_") + Common.NumberFormat2((double)n, (int)2, (int)0, (int)0, (boolean)false));
            return (Pin)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void Initialize() {
        this.setObject(GpioFactory.getInstance());
    }

    public void InitializePiFace(byte SpiAddress, int SpiChannel) throws IOException {
        piFace = true;
        GpioFactory.setDefaultProvider((GpioProvider)new PiFaceGpioProvider(SpiAddress, SpiChannel));
    }

    public void Shutdown() {
        ((GpioController)this.getObject()).shutdown();
    }

    @BA.ShortName(value="GpioPinAnalogInput")
    public static class GpioPinAnalogInputWrapper
    extends AbsObjectWrapper<GpioPinAnalogInput> {
        public void Initialize(int PinNumber) {
            this.setObject(GpioFactory.getInstance().provisionAnalogInputPin(GpioControllerWrapper.pinFromNumber(PinNumber, false)));
        }

        public double getValue() {
            return ((GpioPinAnalogInput)this.getObject()).getValue();
        }
    }

    @BA.ShortName(value="GpioPinDigitalInput")
    public static class GpioPinDigitalInputWrapper
    extends GpioPinDigitalWrapper<GpioPinDigitalInput> {
        public void Initialize(final BA ba, String EventName, int PinNumber) {
            GpioPinDigitalInput pin = GpioFactory.getInstance().provisionDigitalInputPin(GpioControllerWrapper.pinFromNumber(PinNumber, false));
            this.setObject(pin);
            final String eventName = EventName.toLowerCase(BA.cul);
            final Object sender = this.getObject();
            if (ba.subExists(String.valueOf(eventName) + "_statechange")) {
                ((GpioPinDigitalInput)this.getObject()).addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

                    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                        ba.raiseEventFromDifferentThread(sender, null, 0, String.valueOf(eventName) + "_statechange", false, new Object[]{event.getState() == PinState.HIGH});
                    }
                }});
            }
        }

        public boolean getState() {
            return ((GpioPinDigitalInput)this.getObject()).getState() == PinState.HIGH;
        }

        public GpioPinDigitalOutputWrapper ChangeToOutput() {
            ((GpioPinDigitalInput)this.getObject()).setMode(PinMode.DIGITAL_OUTPUT);
            return (GpioPinDigitalOutputWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new GpioPinDigitalOutputWrapper(), (Object)this.getObject());
        }
    }

    @BA.ShortName(value="GpioPinDigitalOutput")
    public static class GpioPinDigitalOutputWrapper
    extends GpioPinDigitalWrapper<GpioPinDigitalOutput> {
        public void Initialize(int PinNumber, boolean State) {
            this.setObject(GpioFactory.getInstance().provisionDigitalOutputPin(GpioControllerWrapper.pinFromNumber(PinNumber, true), State ? PinState.HIGH : PinState.LOW));
        }

        public void setState(boolean b) {
            ((GpioPinDigitalOutput)this.getObject()).setState(b);
        }

        public boolean getState() {
            return ((GpioPinDigitalOutput)this.getObject()).getState() == PinState.HIGH;
        }

        public void Blink(long Delay) {
            ((GpioPinDigitalOutput)this.getObject()).blink(Delay);
        }

        public void Pulse(long Delay) {
            ((GpioPinDigitalOutput)this.getObject()).pulse(Delay);
        }

        public GpioPinDigitalInputWrapper ChangeToInput() {
            ((GpioPinDigitalOutput)this.getObject()).setMode(PinMode.DIGITAL_OUTPUT);
            return (GpioPinDigitalInputWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new GpioPinDigitalInputWrapper(), (Object)this.getObject());
        }
    }

    @BA.Hide
    public static class GpioPinDigitalWrapper<T extends GpioPinDigital>
    extends AbsObjectWrapper<T> {
        public void SetPinPullResistance(PinPullResistance Resistance) {
            ((GpioPinDigital)this.getObject()).setPullResistance(Resistance);
        }

        public String getName() {
            return BA.ReturnString((String)((GpioPinDigital)this.getObject()).getName());
        }

        public void setName(String s) {
            ((GpioPinDigital)this.getObject()).setName(s);
        }

        public void SetShutdownOptions(boolean Unexport, boolean State, PinPullResistance Resistance) {
            ((GpioPinDigital)this.getObject()).setShutdownOptions(Boolean.valueOf(Unexport), State ? PinState.HIGH : PinState.LOW, Resistance);
        }
    }
}

