/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import com.pi4j.component.light.LED;
import com.pi4j.component.relay.Relay;
import com.pi4j.component.switches.Switch;
import com.pi4j.component.switches.SwitchListener;
import com.pi4j.component.switches.SwitchState;
import com.pi4j.component.switches.SwitchStateChangeEvent;
import com.pi4j.device.piface.PiFace;
import com.pi4j.device.piface.impl.PiFaceDevice;
import java.io.IOException;

@BA.ShortName(value="PiFace")
public class PiFaceWrapper
extends AbsObjectWrapper<PiFace> {
    public void Initialize(byte SpiAddress, int SpiChannel) throws IOException {
        this.setObject(new PiFaceDevice(SpiAddress, SpiChannel));
    }

    public SwitchWrapper GetSwitch(int Index) {
        return (SwitchWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new SwitchWrapper(), (Object)((PiFace)this.getObject()).getSwitch(Index));
    }

    public LEDWrapper GetLED(int Index) {
        return (LEDWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new LEDWrapper(), (Object)((PiFace)this.getObject()).getLed(Index));
    }

    public RelayWrapper GetRelay(int Index) {
        return (RelayWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new RelayWrapper(), (Object)((PiFace)this.getObject()).getRelay(Index));
    }

    @BA.ShortName(value="LED")
    public static class LEDWrapper
    extends AbsObjectWrapper<LED> {
        public boolean getState() {
            return ((LED)this.getObject()).isOn();
        }

        public void setState(boolean b) {
            if (b) {
                ((LED)this.getObject()).on();
            } else {
                ((LED)this.getObject()).off();
            }
        }
    }

    @BA.ShortName(value="Relay")
    public static class RelayWrapper
    extends AbsObjectWrapper<Relay> {
        public boolean getState() {
            return ((Relay)this.getObject()).isClosed();
        }

        public void setState(boolean b) {
            if (b) {
                ((Relay)this.getObject()).close();
            } else {
                ((Relay)this.getObject()).open();
            }
        }
    }

    @BA.ShortName(value="Switch")
    public static class SwitchWrapper
    extends AbsObjectWrapper<Switch> {
        public boolean getState() {
            return ((Switch)this.getObject()).isOn();
        }

        public void AddListener(final BA ba, String EventName) {
            final String eventName = EventName.toLowerCase(BA.cul);
            final Object sender = this.getObject();
            ((Switch)this.getObject()).addListener(new SwitchListener[]{new SwitchListener(){

                public void onStateChange(SwitchStateChangeEvent event) {
                    ba.raiseEventFromDifferentThread(sender, null, 0, String.valueOf(eventName) + "_statechange", false, new Object[]{event.getNewState() == SwitchState.ON});
                }
            }});
        }
    }
}

