/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.object;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.object.BackgroundWorkersManager;
import anywheresoftware.b4j.object.JServlet;
import anywheresoftware.b4j.object.WebSocketModule;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@BA.Version(value=3.0f)
@BA.ShortName(value="Server")
public class ServerWrapper {
    @BA.Hide
    public Server server;
    private BA ba;
    private String eventName;
    private String staticFiles = File.Combine((String)File.getDirApp(), (String)"www");
    private int retainDays = 30;
    private int port = 8080;
    private String logsFileFolder = File.Combine((String)File.getDirApp(), (String)"logs");
    private ArrayList<HandlerData> webSockets = new ArrayList();
    @BA.Hide
    public ArrayList<HandlerData> filters = new ArrayList();
    private ArrayList<HandlerData> backgroundWorkers = new ArrayList();
    private boolean http2Enabled;
    @BA.Hide
    public ServletContextHandler context;
    @BA.Hide
    public String host = null;
    @BA.Hide
    public GzipHandler gzipHandler;
    private int threadsIndexCounter;
    private Map<String, String> staticFilesOptions;
    private Map<String, String> errorMap;
    private SslContextFactory sslFactory;
    private int SslPort;
    private final ArrayList<HandlerData> handlers = new ArrayList();
    private final ThreadLocal<Integer> threadsIndex = new ThreadLocal<Integer>(){

        @Override
        protected synchronized Integer initialValue() {
            ServerWrapper serverWrapper = ServerWrapper.this;
            int n = serverWrapper.threadsIndexCounter;
            serverWrapper.threadsIndexCounter = n + 1;
            return n;
        }
    };
    public static boolean LogWaitingMessages = true;
    static int debugNetworkLatency = 100;

    public void Initialize(BA ba, String EventName) {
        this.ba = ba;
        this.eventName = EventName.toLowerCase(BA.cul);
        this.threadsIndex.get().intValue();
        this.server = new Server();
        this.context = new ServletContextHandler();
        this.context.setContextPath("/");
    }

    public void Start() throws Exception {
        ServletHolder sh;
        Connector[] connectors;
        BA.exitOnUnhandledExceptions = false;
        ServerConnector http = new ServerConnector(this.server);
        http.setPort(this.port);
        if (this.host != null) {
            http.setHost(this.host);
        }
        if (this.http2Enabled && this.sslFactory == null) {
            throw new RuntimeException("SSL must be configured for HTTP2 to be enabled.");
        }
        if (this.sslFactory != null) {
            ServerConnector https;
            HttpConfiguration https_config = new HttpConfiguration();
            https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            HttpConnectionFactory http1 = new HttpConnectionFactory(https_config);
            SslConnectionFactory ssl = new SslConnectionFactory(this.sslFactory, this.http2Enabled ? "alpn" : "HTTP/1.1");
            if (this.http2Enabled) {
                HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(https_config);
                ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                alpn.setDefaultProtocol(http1.getProtocol());
                https = new ServerConnector(this.server, new ConnectionFactory[]{ssl, alpn, http2, http1});
            } else {
                https = new ServerConnector(this.server, new ConnectionFactory[]{ssl, http1});
            }
            this.sslFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
            this.sslFactory.setUseCipherSuitesOrder(true);
            https.setPort(this.SslPort);
            if (this.host != null) {
                https.setHost(this.host);
            }
            connectors = new Connector[]{http, https};
        } else {
            connectors = new Connector[]{http};
        }
        this.server.setConnectors(connectors);
        this.context.setResourceBase(this.staticFiles);
        final boolean debug = BA.isShellModeRuntimeCheck((BA)this.ba);
        for (HandlerData hd : this.handlers) {
            JServlet js = new JServlet(Class.forName(this.fixClassName(hd)), hd.singleThread | debug);
            sh = new ServletHolder((Servlet)js);
            this.context.addServlet(sh, hd.path);
        }
        for (HandlerData hd : this.filters) {
            FilterHolder fh;
            if (hd.internal) {
                fh = new FilterHolder(Class.forName(hd.clazz));
                anywheresoftware.b4a.objects.collections.Map settings = (anywheresoftware.b4a.objects.collections.Map)hd.extra;
                if (settings != null && settings.IsInitialized()) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    this.copyMap(settings, m, true);
                    fh.setInitParameters(m);
                }
            } else {
                JServlet js = new JServlet(Class.forName(this.fixClassName(hd)), hd.singleThread | debug);
                fh = new FilterHolder((Filter)js);
            }
            this.context.addFilter(fh, hd.path, EnumSet.of(DispatcherType.REQUEST));
        }
        for (HandlerData hd : this.webSockets) {
            WebSocketModule.Servlet s = new WebSocketModule.Servlet(Class.forName(this.fixClassName(hd)), hd.singleThread | debug, hd.maxIdleTime);
            sh = new ServletHolder((Servlet)s);
            this.context.addServlet(sh, hd.path);
        }
        ServletHolder staticHolder = this.context.addServlet(DefaultServlet.class, "/");
        if (this.staticFilesOptions != null) {
            staticHolder.setInitParameters(this.staticFilesOptions);
        }
        this.context.setSessionHandler(new SessionHandler());
        SessionHandler manager = this.context.getSessionHandler();
        manager.setHttpOnly(true);
        if (this.errorMap != null) {
            ErrorPageErrorHandler err = new ErrorPageErrorHandler();
            err.setErrorPages(this.errorMap);
            this.context.setErrorHandler((ErrorHandler)err);
        }
        HandlerCollection handlers = new HandlerCollection();
        RequestLogHandler log = new RequestLogHandler();
        File.MakeDir(null, (String)this.logsFileFolder);
        NCSARequestLog rl = new NCSARequestLog(File.Combine((String)this.logsFileFolder, (String)"b4j-yyyy_mm_dd.request.log"));
        rl.setRetainDays(this.retainDays);
        rl.setExtended(true);
        rl.setAppend(true);
        log.setRequestLog((RequestLog)rl);
        handlers.setHandlers(new Handler[]{this.context, new DefaultHandler(), log});
        HandlerCollection h = handlers;
        if (this.gzipHandler != null) {
            this.gzipHandler.setHandler((Handler)handlers);
            h = this.gzipHandler;
        }
        this.server.setHandler((Handler)h);
        this.server.start();
        if (!debug) {
            debugNetworkLatency = 0;
        }
        if (debugNetworkLatency > 0) {
            System.out.println("Emulated network latency: " + debugNetworkLatency + "ms");
        }
        if (this.backgroundWorkers.size() > 0) {
            this.ba.postRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        BackgroundWorkersManager backWorkers = new BackgroundWorkersManager(ServerWrapper.this.ba, debug);
                        for (HandlerData hd : ServerWrapper.this.backgroundWorkers) {
                            backWorkers.startWorker(Class.forName(ServerWrapper.this.fixClassName(hd)));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private String fixClassName(HandlerData hd) {
        String className = hd.clazz.toLowerCase(BA.cul);
        if (!className.contains(".")) {
            className = String.valueOf(BA.packageName) + "." + className;
        }
        return className;
    }

    public void setDebugNetworkLatency(int i) {
        debugNetworkLatency = i;
    }

    public void setStaticFilesFolder(String s) {
        this.staticFiles = s;
    }

    public String getStaticFilesFolder() {
        return this.staticFiles;
    }

    public void setLogsFileFolder(String s) {
        this.logsFileFolder = s;
    }

    public String getLogsFileFolder() {
        return this.logsFileFolder;
    }

    public boolean getHttp2Enabled() {
        return this.http2Enabled;
    }

    public void setHttp2Enabled(boolean b) {
        this.http2Enabled = b;
    }

    public void setGzipEnabled(boolean b) {
        if (b) {
            this.gzipHandler = new GzipHandler();
            this.gzipHandler.setIncludedMethods(new String[]{HttpMethod.POST.toString(), HttpMethod.GET.toString()});
        } else {
            this.gzipHandler = null;
        }
    }

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public void setLogsRetainDays(int p) {
        this.retainDays = p;
    }

    public int getLogsRetainDays() {
        return this.retainDays;
    }

    public int getCurrentThreadIndex() {
        return this.threadsIndex.get();
    }

    public void AddHandler(String Path2, String Class2, boolean SingleThreadHandler) {
        this.handlers.add(new HandlerData(Class2, Path2, SingleThreadHandler));
    }

    public void AddWebSocket(String Path2, String Class2) {
        HandlerData hd = new HandlerData(Class2, Path2, false);
        hd.maxIdleTime = 180;
        this.webSockets.add(hd);
    }

    public void AddFilter(String Path2, String Class2, boolean SingleThreadHandler) {
        this.filters.add(new HandlerData(Class2, Path2, SingleThreadHandler));
    }

    public void AddDoSFilter(String Path2, anywheresoftware.b4a.objects.collections.Map Settings) {
        HandlerData hd = new HandlerData("org.eclipse.jetty.servlets.DoSFilter", Path2, false);
        hd.extra = Settings;
        hd.internal = true;
        this.filters.add(hd);
    }

    public void AddBackgroundWorker(String Class2) {
        HandlerData hd = new HandlerData(Class2, null, false);
        this.backgroundWorkers.add(hd);
    }

    public void SetCustomErrorPages(anywheresoftware.b4a.objects.collections.Map PagesMap) {
        this.errorMap = new HashMap<String, String>();
        this.copyMap(PagesMap, this.errorMap, false);
    }

    public void SetStaticFilesOptions(anywheresoftware.b4a.objects.collections.Map Options) {
        this.staticFilesOptions = new HashMap<String, String>();
        this.copyMap(Options, this.staticFilesOptions, true);
    }

    private void copyMap(anywheresoftware.b4a.objects.collections.Map m, Map<String, String> o, boolean integerNumbersOnly) {
        for (Map.Entry e : ((Map.MyMap)m.getObject()).entrySet()) {
            String value = integerNumbersOnly && e.getValue() instanceof Number ? String.valueOf(((Number)e.getValue()).longValue()) : String.valueOf(e.getValue());
            o.put(String.valueOf(e.getKey()), value);
        }
    }

    public void SetSslConfiguration(SslContextFactoryWrapper Config, int Port) {
        this.sslFactory = (SslContextFactory)Config.getObject();
        this.SslPort = Port;
    }

    public int getSslPort() {
        return this.SslPort;
    }

    public anywheresoftware.b4a.objects.collections.Map CreateThreadSafeMap() {
        MyMapWrapper m = new MyMapWrapper();
        m.setObject((Object)new ConcurrentMyMap());
        return m;
    }

    static class ConcurrentMyMap
    extends Map.MyMap {
        ConcurrentMyMap() {
        }

        public Object getKey(int index) {
            throw new RuntimeException("Concurrent Map does not support this method.");
        }

        public Object getValue(int index) {
            throw new RuntimeException("Concurrent Map does not support this method.");
        }

        protected Map<Object, Object> createInnerMap() {
            return new ConcurrentHashMap<Object, Object>();
        }
    }

    @BA.Hide
    public static class HandlerData {
        public final String clazz;
        public final String path;
        public final boolean singleThread;
        public int maxIdleTime;
        public Object extra;
        public boolean internal;

        public HandlerData(String clazz, String path, boolean singleThread) {
            this.clazz = clazz;
            this.path = path;
            this.singleThread = singleThread;
        }
    }

    @BA.Hide
    public static class MyMapWrapper
    extends anywheresoftware.b4a.objects.collections.Map {
        public BA.IterableList Values() {
            List l1 = new List();
            l1.Initialize();
            for (Object o : ((Map.MyMap)this.getObject()).values()) {
                l1.Add(o);
            }
            return l1;
        }

        public BA.IterableList Keys() {
            List l1 = new List();
            l1.Initialize();
            for (Object o : ((Map.MyMap)this.getObject()).keySet()) {
                l1.Add(o);
            }
            return l1;
        }
    }

    @BA.ShortName(value="SslConfiguration")
    public static class SslContextFactoryWrapper
    extends AbsObjectWrapper<SslContextFactory> {
        public void Initialize() {
            this.setObject(new SslContextFactory());
        }

        public void SetKeyStorePath(String Dir, String FileName) {
            ((SslContextFactory)this.getObject()).setKeyStorePath(File.Combine((String)Dir, (String)FileName));
        }

        public void setKeyStorePassword(String p) {
            ((SslContextFactory)this.getObject()).setKeyStorePassword(p);
        }

        public void setKeyManagerPassword(String p) {
            ((SslContextFactory)this.getObject()).setKeyManagerPassword(p);
        }

        public void EnableConscryptProvider() throws Exception {
            Security.addProvider((Provider)Class.forName("org.conscrypt.OpenSSLProvider").newInstance());
            ((SslContextFactory)this.getObject()).setProvider("Conscrypt");
        }
    }
}

