/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.object;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.B4AClass;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4j.object.JServlet;
import anywheresoftware.b4j.object.WebSocket;
import anywheresoftware.b4j.objects.collections.JSONParser;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketModule {

    @BA.Hide
    public static class Adapter
    extends WebSocketAdapter {
        private ThreadHandler handler;
        private final Servlet parentServlet;
        private BA ba;
        private WebSocket ws;
        private boolean disconnectRun;

        public Adapter(Servlet servlet) {
            this.parentServlet = servlet;
        }

        public void onWebSocketConnect(Session sess) {
            super.onWebSocketConnect(sess);
            ((WebSocketRemoteEndpoint)sess.getRemote()).setBatchMode(BatchMode.ON);
            this.handler = new ThreadHandler();
            if (this.parentServlet.singleThread) {
                BA.firstInstance.postRunnable((Runnable)this.handler);
            } else {
                Servlet.pool.submit(this.handler);
            }
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            this.runDisconnect(true);
        }

        public void onWebSocketError(Throwable cause) {
            super.onWebSocketError(cause);
            if (cause instanceof SocketTimeoutException || cause instanceof EOFException) {
                System.err.println("onWebSocketError: " + cause.getMessage());
            } else {
                cause.printStackTrace();
            }
        }

        public void onWebSocketText(String message) {
            try {
                JSONParser jp = new JSONParser();
                jp.Initialize(message);
                Map map = jp.NextObject();
                String type = (String)map.Get((Object)"type");
                if (type.equals("event")) {
                    final String eventName = (String)map.Get((Object)"event");
                    if (!eventName.contains("_")) {
                        throw new RuntimeException("Invalid event name: " + eventName);
                    }
                    final Map params = map.ContainsKey((Object)"params") ? (Map)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new Map(), (Object)map.Get((Object)"params")) : new Map();
                    this.ba.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Adapter.this.ba.raiseEvent(null, eventName.toLowerCase(BA.cul), new Object[]{params});
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                Adapter.this.ws.Flush();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else if (type.equals("data")) {
                    WebSocket.SimpleFuture sf = this.ws.futures.removeFirst();
                    sf.value = map.Get((Object)"data");
                    sf.latch.countDown();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void runDisconnect(boolean messageLoopIsRunning) {
            if (this.ba != null) {
                if (messageLoopIsRunning) {
                    this.ba.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            if (Adapter.this.ba != null) {
                                if (!Adapter.this.disconnectRun) {
                                    Adapter.this.ba.raiseEvent(null, "websocket_disconnected", new Object[0]);
                                    if (!Adapter.this.parentServlet.singleThread) {
                                        Common.StopMessageLoop((BA)Adapter.this.ba);
                                    }
                                    Adapter.this.disconnectRun = true;
                                }
                                Adapter.this.ba = null;
                            }
                        }
                    });
                } else if (!this.disconnectRun) {
                    this.ba.raiseEvent(null, "websocket_disconnected", new Object[0]);
                    this.disconnectRun = true;
                    this.ba = null;
                }
            }
        }

        public class ThreadHandler
        implements Runnable {
            @Override
            public void run() {
                try {
                    B4AClass handler = JServlet.createInstance(Adapter.this.parentServlet.handlerClass, Adapter.this.parentServlet.initializeMethod);
                    Adapter.this.ba = handler.getBA();
                    Adapter.this.ws = new WebSocket();
                    if (!Adapter.this.parentServlet.singleThread) {
                        Adapter.this.ba.cleanMessageLoop();
                    }
                    ((Adapter)Adapter.this).ws.adapter = Adapter.this;
                    ((Adapter)Adapter.this).ws.session = Adapter.this.getSession();
                    ((Adapter)Adapter.this).ws.singleThread = Adapter.this.parentServlet.singleThread;
                    Adapter.this.ws.setEvents(Adapter.this.ba);
                    Adapter.this.ws.setJQElements(handler);
                    Adapter.this.ba.raiseEvent(null, "websocket_connected", new Object[]{Adapter.this.ws});
                    Adapter.this.ws.Flush();
                    if (!Adapter.this.parentServlet.singleThread) {
                        Adapter.this.ba.startMessageLoop();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Adapter.this.runDisconnect(false);
                        if (Adapter.this.getSession() != null && Adapter.this.getSession().isOpen()) {
                            Adapter.this.getSession().close();
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
    }

    @BA.Hide
    public static class Servlet
    extends WebSocketServlet {
        public static int DATA_TIMEOUT = 10000;
        private final Class<?> handlerClass;
        private final Method initializeMethod;
        private final boolean singleThread;
        private final int maxIdleTimeMinutes;
        static ThreadPoolExecutor pool;

        public Servlet(Class<?> handlerClass, boolean singleThread, int maxIdleTimeMinutes) throws SecurityException, NoSuchMethodException {
            this.handlerClass = handlerClass;
            this.initializeMethod = JServlet.getInitializeMethod(handlerClass);
            this.singleThread = singleThread;
            this.maxIdleTimeMinutes = maxIdleTimeMinutes;
            if (pool == null) {
                pool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 30L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
            }
        }

        public void configure(WebSocketServletFactory factory) {
            factory.getPolicy().setIdleTimeout((long)(this.maxIdleTimeMinutes * 1000 * 60));
            factory.setCreator(new WebSocketCreator(){

                public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                    HttpSession hs = req.getHttpServletRequest().getSession(true);
                    if (hs.isNew()) {
                        hs.setMaxInactiveInterval(Servlet.this.maxIdleTimeMinutes * 60);
                    }
                    return new Adapter(Servlet.this);
                }
            });
        }
    }
}

