/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;
import org.eclipse.jetty.websocket.common.io.FrameFlusher;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES;
    protected static final ByteBuffer TAIL_BYTES_BUF;
    private static final Logger LOG;
    protected static final int TAIL_DROP_NEVER = 0;
    protected static final int TAIL_DROP_ALWAYS = 1;
    protected static final int TAIL_DROP_FIN_ONLY = 2;
    protected static final int RSV_USE_ALWAYS = 0;
    protected static final int RSV_USE_ONLY_FIRST = 1;
    protected static final int INFLATE_BUFFER_SIZE = 8192;
    protected static final int INPUT_MAX_BUFFER_SIZE = 8192;
    private static final int DECOMPRESS_BUF_SIZE = 8192;
    private static final boolean NOWRAP = true;
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private Deflater deflaterImpl;
    private Inflater inflaterImpl;
    protected AtomicInteger decompressCount = new AtomicInteger(0);
    private int tailDrop = this.getTailDropMode();
    private int rsvUse = this.getRsvUseMode();

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -1;
        byArray[3] = -1;
        TAIL_BYTES = byArray;
        TAIL_BYTES_BUF = ByteBuffer.wrap(TAIL_BYTES);
        LOG = Log.getLogger(CompressExtension.class);
    }

    protected CompressExtension() {
    }

    public Deflater getDeflater() {
        if (this.deflaterImpl == null) {
            this.deflaterImpl = new Deflater(-1, true);
        }
        return this.deflaterImpl;
    }

    public Inflater getInflater() {
        if (this.inflaterImpl == null) {
            this.inflaterImpl = new Inflater(true);
        }
        return this.inflaterImpl;
    }

    public boolean isRsv1User() {
        return true;
    }

    abstract int getTailDropMode();

    abstract int getRsvUseMode();

    protected void forwardIncoming(Frame frame, ByteAccumulator accumulator) {
        DataFrame newFrame = new DataFrame(frame);
        newFrame.setRsv1(false);
        ByteBuffer buffer = this.getBufferPool().acquire(accumulator.getLength(), false);
        try {
            BufferUtil.flipToFill((ByteBuffer)buffer);
            accumulator.transferTo(buffer);
            newFrame.setPayload(buffer);
            this.nextIncomingFrame((Frame)newFrame);
        }
        finally {
            this.getBufferPool().release(buffer);
        }
    }

    protected ByteAccumulator newByteAccumulator() {
        int maxSize = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageBufferSize());
        return new ByteAccumulator(maxSize);
    }

    /*
     * Unable to fully structure code
     */
    protected void decompress(ByteAccumulator accumulator, ByteBuffer buf) throws DataFormatException {
        if (buf == null || !buf.hasRemaining()) {
            return;
        }
        output = new byte[8192];
        inflater = this.getInflater();
        block0: while (buf.hasRemaining() && inflater.needsInput()) {
            if (CompressExtension.supplyInput(inflater, buf)) ** GOTO lbl15
            CompressExtension.LOG.debug("Needed input, but no buffer could supply input", new Object[0]);
            return;
lbl-1000:
            // 1 sources

            {
                if (read == 0) {
                    CompressExtension.LOG.debug("Decompress: read 0 {}", new Object[]{CompressExtension.toDetail(inflater)});
                    continue block0;
                }
                if (CompressExtension.LOG.isDebugEnabled()) {
                    CompressExtension.LOG.debug("Decompressed {} bytes: {}", new Object[]{read, CompressExtension.toDetail(inflater)});
                }
                accumulator.copyChunk(output, 0, read);
lbl15:
                // 2 sources

                ** while ((read = inflater.inflate((byte[])output)) >= 0)
            }
lbl16:
            // 1 sources

        }
        if (CompressExtension.LOG.isDebugEnabled()) {
            CompressExtension.LOG.debug("Decompress: exiting {}", new Object[]{CompressExtension.toDetail(inflater)});
        }
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(callback, new ZipException());
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", new Object[]{entry});
        }
        this.offerEntry(entry);
        this.flusher.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry entry) {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            this.entries.offer(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        CompressExtension compressExtension = this;
        synchronized (compressExtension) {
            return this.entries.poll();
        }
    }

    protected void notifyCallbackSuccess(WriteCallback callback) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeSuccess();
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying success of callback " + callback, x);
            }
        }
    }

    protected void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
        block3: {
            try {
                if (callback != null) {
                    callback.writeFailed(failure);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Exception while notifying failure of callback " + callback, x);
            }
        }
    }

    private static boolean supplyInput(Inflater inflater, ByteBuffer buf) {
        int inputOffset;
        byte[] input;
        int len;
        if (buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Inflater", new Object[0]);
            }
            return false;
        }
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        inflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", new Object[]{input.length, CompressExtension.toDetail(inflater)});
        }
        return true;
    }

    private static boolean supplyInput(Deflater deflater, ByteBuffer buf) {
        int inputOffset;
        byte[] input;
        int len;
        if (buf.remaining() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No data left left to supply to Deflater", new Object[0]);
            }
            return false;
        }
        if (buf.hasArray()) {
            len = buf.remaining();
            input = buf.array();
            inputOffset = buf.position() + buf.arrayOffset();
            buf.position(buf.position() + len);
        } else {
            len = Math.min(8192, buf.remaining());
            input = new byte[len];
            inputOffset = 0;
            buf.get(input, 0, len);
        }
        deflater.setInput(input, inputOffset, len);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supplied {} input bytes: {}", new Object[]{input.length, CompressExtension.toDetail(deflater)});
        }
        return true;
    }

    private static String toDetail(Inflater inflater) {
        return String.format("Inflater[finished=%b,read=%d,written=%d,remaining=%d,in=%d,out=%d]", inflater.finished(), inflater.getBytesRead(), inflater.getBytesWritten(), inflater.getRemaining(), inflater.getTotalIn(), inflater.getTotalOut());
    }

    private static String toDetail(Deflater deflater) {
        return String.format("Deflater[finished=%b,read=%d,written=%d,in=%d,out=%d]", deflater.finished(), deflater.getBytesRead(), deflater.getBytesWritten(), deflater.getTotalIn(), deflater.getTotalOut());
    }

    public static boolean endsWithTail(ByteBuffer buf) {
        if (buf == null || buf.remaining() < TAIL_BYTES.length) {
            return false;
        }
        int limit = buf.limit();
        int i = TAIL_BYTES.length;
        while (i > 0) {
            if (buf.get(limit - i) != TAIL_BYTES[TAIL_BYTES.length - i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    protected void doStop() throws Exception {
        if (this.deflaterImpl != null) {
            this.deflaterImpl.end();
        }
        if (this.inflaterImpl != null) {
            this.inflaterImpl.end();
        }
        super.doStop();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private boolean finished = true;

        private Flusher() {
        }

        public void failed(Throwable x) {
            LOG.warn(x);
            super.failed(x);
        }

        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = CompressExtension.this.pollEntry();
                LOG.debug("Processing {}", new Object[]{this.current});
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry entry) {
            Frame frame = entry.frame;
            BatchMode batchMode = entry.batchMode;
            if (OpCode.isControlFrame((byte)frame.getOpCode()) || frame == FrameFlusher.FLUSH_FRAME) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batchMode);
                return;
            }
            this.compress(entry, true);
        }

        private void compress(FrameEntry entry, boolean first) {
            Frame frame = entry.frame;
            ByteBuffer data = frame.getPayload();
            int remaining = data.remaining();
            int outputLength = Math.max(256, data.remaining());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressing {}: {} bytes in {} bytes chunk", new Object[]{entry, remaining, outputLength});
            }
            boolean needsCompress = true;
            Deflater deflater = CompressExtension.this.getDeflater();
            if (deflater.needsInput() && !CompressExtension.supplyInput(deflater, data)) {
                needsCompress = false;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] output = new byte[outputLength];
            boolean fin = frame.isFin();
            while (needsCompress) {
                int compressed = deflater.deflate(output, 0, outputLength, 2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wrote {} bytes to output buffer", (long)compressed);
                }
                out.write(output, 0, compressed);
                if (compressed >= outputLength) continue;
                needsCompress = false;
            }
            ByteBuffer payload = ByteBuffer.wrap(out.toByteArray());
            if (payload.remaining() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compressed bytes[] = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                }
                if (CompressExtension.this.tailDrop == 1) {
                    if (CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_ALWAYS) = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                    }
                } else if (CompressExtension.this.tailDrop == 2) {
                    if (frame.isFin() && CompressExtension.endsWithTail(payload)) {
                        payload.limit(payload.limit() - TAIL_BYTES.length);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("payload (TAIL_DROP_FIN_ONLY) = {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
                    }
                }
            } else if (fin) {
                payload = ByteBuffer.wrap(new byte[1]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compressed {}: input:{} -> payload:{}", new Object[]{entry, outputLength, payload.remaining()});
            }
            boolean continuation = frame.getType().isContinuation() || !first;
            DataFrame chunk = new DataFrame(frame, continuation);
            if (CompressExtension.this.rsvUse == 1) {
                chunk.setRsv1(!continuation);
            } else {
                chunk.setRsv1(true);
            }
            chunk.setPayload(payload);
            chunk.setFin(fin);
            CompressExtension.this.nextOutgoingFrame((Frame)chunk, this, entry.batchMode);
        }

        protected void onCompleteSuccess() {
        }

        protected void onCompleteFailure(Throwable x) {
            FrameEntry entry;
            while ((entry = CompressExtension.this.pollEntry()) != null) {
                CompressExtension.this.notifyCallbackFailure(entry.callback, x);
            }
        }

        public void writeSuccess() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        public void writeFailed(Throwable x) {
            CompressExtension.this.notifyCallbackFailure(this.current.callback, x);
            this.failed(x);
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = callback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

