/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.conscrypt.server;

import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ConscryptServerALPNProcessor
implements ALPNProcessor.Server {
    private static final Logger LOG = Log.getLogger(ConscryptServerALPNProcessor.class);

    @Override
    public void init() {
        if (Security.getProvider("Conscrypt") == null) {
            Security.addProvider((Provider)new OpenSSLProvider());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added Conscrypt provider", new Object[0]);
            }
        }
    }

    @Override
    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.conscrypt.");
    }

    @Override
    public void configure(SSLEngine sslEngine, Connection connection) {
        try {
            Method method = sslEngine.getClass().getMethod("setHandshakeApplicationProtocolSelector", BiFunction.class);
            method.setAccessible(true);
            method.invoke((Object)sslEngine, new ALPNCallback((ALPNServerConnection)connection));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private final class ALPNCallback
    implements BiFunction<SSLEngine, List<String>, String>,
    SslHandshakeListener {
        private final ALPNServerConnection alpnConnection;

        private ALPNCallback(ALPNServerConnection connection) {
            this.alpnConnection = connection;
            ((SslConnection.DecryptedEndPoint)this.alpnConnection.getEndPoint()).getSslConnection().addHandshakeListener(this);
        }

        @Override
        public String apply(SSLEngine engine, List<String> protocols) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("apply {} {}", this.alpnConnection, protocols);
            }
            this.alpnConnection.select(protocols);
            return this.alpnConnection.getProtocol();
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake succeeded, protocol={} for {}", protocol, this.alpnConnection);
            }
            if (protocol == null) {
                this.alpnConnection.unsupported();
            }
        }

        @Override
        public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake failed " + this.alpnConnection, failure);
            }
        }
    }
}

