/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;

@ManagedObject(value="MBean Wrapper for DeploymentManager")
public class DeploymentManagerMBean
extends ObjectMBean {
    private final DeploymentManager _manager;

    public DeploymentManagerMBean(Object managedObject) {
        super(managedObject);
        this._manager = (DeploymentManager)managedObject;
    }

    @ManagedOperation(value="list apps being tracked", impact="INFO")
    public Collection<String> getApps() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DeploymentManager.AppEntry entry : this._manager.getAppEntries()) {
            ret.add(this.toRef(entry.getApp()));
        }
        return ret;
    }

    @ManagedOperation(value="list nodes that are tracked by DeploymentManager", impact="INFO")
    public Collection<String> getNodes() {
        return this._manager.getNodes().stream().map(Node::getName).collect(Collectors.toList());
    }

    @ManagedOperation(value="list apps that are located at specified App LifeCycle nodes", impact="ACTION")
    public Collection<String> getApps(@Name(value="nodeName") String nodeName) {
        Node node = this._manager.getLifeCycle().getNodeByName(nodeName);
        if (node == null) {
            throw new IllegalArgumentException("Unable to find node [" + nodeName + "]");
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (DeploymentManager.AppEntry entry : this._manager.getAppEntries()) {
            if (!node.equals(entry.getLifecyleNode())) continue;
            ret.add(this.toRef(entry.getApp()));
        }
        return ret;
    }

    private String toRef(App app) {
        return String.format("originId=%s,contextPath=%s,appProvider=%s", app.getContextPath(), app.getOriginId(), app.getAppProvider().getClass().getName());
    }

    public Collection<ContextHandler> getContexts() throws Exception {
        ArrayList<ContextHandler> apps = new ArrayList<ContextHandler>();
        for (App app : this._manager.getApps()) {
            apps.add(app.getContextHandler());
        }
        return apps;
    }

    public Collection<AppProvider> getAppProviders() {
        return this._manager.getAppProviders();
    }

    public void requestAppGoal(String appId, String nodeName) {
        this._manager.requestAppGoal(appId, nodeName);
    }
}

